/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.schema;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.collate.OCollate;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexManager;
import com.orientechnologies.orient.core.index.OIndexMetadata;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OGlobalProperty;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OPropertyImpl;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.storage.OAutoshardedStorage;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class OPropertyEmbedded
extends OPropertyImpl {
    protected OPropertyEmbedded(OClassImpl owner) {
        super(owner);
    }

    protected OPropertyEmbedded(OClassImpl owner, ODocument document) {
        super(owner, document);
    }

    protected OPropertyEmbedded(OClassImpl oClassImpl, OGlobalProperty global) {
        super(oClassImpl, global);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPropertyImpl setType(OType type) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        ODatabaseDocumentInternal database = this.getDatabase();
        this.acquireSchemaWriteLock();
        try {
            OStorage storage = database.getStorage();
            if (this.isDistributedCommand()) {
                String cmd = String.format("alter property %s type %s", this.getFullNameQuoted(), OPropertyEmbedded.quoteString(type.toString()));
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.setTypeInternal(type);
            } else {
                this.setTypeInternal(type);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        this.owner.fireDatabaseMigration(database, this.globalRef.getName(), this.globalRef.getType());
        return this;
    }

    protected void setTypeInternal(OType iType) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            if (iType == this.globalRef.getType()) {
                return;
            }
            if (!iType.getCastable().contains((Object)this.globalRef.getType())) {
                throw new IllegalArgumentException("Cannot change property type from " + (Object)((Object)this.globalRef.getType()) + " to " + (Object)((Object)iType));
            }
            this.globalRef = this.owner.owner.findOrCreateGlobalProperty(this.globalRef.getName(), iType);
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OProperty setName(String name) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (this.isDistributedCommand()) {
                String cmd = String.format("alter property %s name %s", this.getFullNameQuoted(), OPropertyEmbedded.quoteString(name));
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.setNameInternal(name);
            } else {
                this.setNameInternal(name);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    protected void setNameInternal(String name) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        String oldName = this.globalRef.getName();
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            this.owner.renameProperty(oldName, name);
            this.globalRef = this.owner.owner.findOrCreateGlobalProperty(name, this.globalRef.getType());
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        this.owner.firePropertyNameMigration(this.getDatabase(), oldName, name, this.globalRef.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPropertyImpl setDescription(String iDescription) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (this.isDistributedCommand()) {
                String cmd = String.format("alter property %s description %s", this.getFullNameQuoted(), OPropertyEmbedded.quoteString(iDescription));
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
                this.setDescriptionInternal(iDescription);
            } else {
                this.setDescriptionInternal(iDescription);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    protected void setDescriptionInternal(String iDescription) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            this.description = iDescription;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OProperty setCollate(String collate) {
        if (collate == null) {
            collate = "default";
        }
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (this.isDistributedCommand()) {
                String cmd = String.format("alter property %s collate %s", this.getFullNameQuoted(), OPropertyEmbedded.quoteString(collate));
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.setCollateInternal(collate);
            } else {
                this.setCollateInternal(collate);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OProperty setCollateInternal(String iCollate) {
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            OCollate oldCollate = this.collate;
            if (iCollate == null) {
                iCollate = "default";
            }
            this.collate = OSQLEngine.getCollate(iCollate);
            if (this.collate != null && !this.collate.equals(oldCollate) || this.collate == null && oldCollate != null) {
                Set<OIndex<?>> indexes = this.owner.getClassIndexes();
                ArrayList indexesToRecreate = new ArrayList();
                for (OIndex<?> index : indexes) {
                    OIndexDefinition definition = index.getDefinition();
                    List<String> list = definition.getFields();
                    if (!list.contains(this.getName())) continue;
                    indexesToRecreate.add(index);
                }
                if (!indexesToRecreate.isEmpty()) {
                    OLogManager.instance().info((Object)this, "Collate value was changed, following indexes will be rebuilt %s", indexesToRecreate);
                    ODatabaseDocumentInternal database = this.getDatabase();
                    OIndexManager indexManager = database.getMetadata().getIndexManager();
                    for (OIndex oIndex : indexesToRecreate) {
                        OIndexMetadata indexMetadata = oIndex.getInternal().loadMetadata(oIndex.getConfiguration());
                        ODocument metadata = oIndex.getMetadata();
                        List<String> fields = indexMetadata.getIndexDefinition().getFields();
                        String[] fieldsToIndex = fields.toArray(new String[fields.size()]);
                        indexManager.dropIndex(indexMetadata.getName());
                        this.owner.createIndex(indexMetadata.getName(), indexMetadata.getType(), (OProgressListener)null, metadata, indexMetadata.getAlgorithm(), fieldsToIndex);
                    }
                }
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCustom() {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            String cmd = String.format("alter property %s custom clear", this.getFullNameQuoted());
            if (this.isDistributedCommand()) {
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.clearCustomInternal();
            } else {
                this.clearCustomInternal();
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    protected void clearCustomInternal() {
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            this.customFields = null;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPropertyImpl setCustom(String name, String value) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            String cmd = String.format("alter property %s custom %s=%s", this.getFullNameQuoted(), name, OPropertyEmbedded.quoteString(value));
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (this.isDistributedCommand()) {
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.setCustomInternal(name, value);
            } else {
                this.setCustomInternal(name, value);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    protected void setCustomInternal(String iName, String iValue) {
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            if (this.customFields == null) {
                this.customFields = new HashMap();
            }
            if (iValue == null || "null".equalsIgnoreCase(iValue)) {
                this.customFields.remove(iName);
            } else {
                this.customFields.put(iName, iValue);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPropertyImpl setRegexp(String regexp) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (this.isDistributedCommand()) {
                String cmd = String.format("alter property %s regexp %s", this.getFullNameQuoted(), OPropertyEmbedded.quoteString(regexp));
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.setRegexpInternal(regexp);
            } else {
                this.setRegexpInternal(regexp);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    protected void setRegexpInternal(String regexp) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            this.regexp = regexp;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPropertyImpl setLinkedClass(OClass linkedClass) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        OPropertyEmbedded.checkSupportLinkedClass(this.getType());
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (this.isDistributedCommand()) {
                String cmd = String.format("alter property %s linkedclass %s", this.getFullNameQuoted(), OPropertyEmbedded.quoteString(linkedClass.getName()));
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.setLinkedClassInternal(linkedClass);
            } else {
                this.setLinkedClassInternal(linkedClass);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    protected void setLinkedClassInternal(OClass iLinkedClass) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            this.linkedClass = iLinkedClass;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OProperty setLinkedType(OType linkedType) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        OPropertyEmbedded.checkLinkTypeSupport(this.getType());
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (this.isDistributedCommand()) {
                String cmd = String.format("alter property %s linkedtype %s", this.getFullNameQuoted(), OPropertyEmbedded.quoteString(linkedType.toString()));
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.setLinkedTypeInternal(linkedType);
            } else {
                this.setLinkedTypeInternal(linkedType);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    protected void setLinkedTypeInternal(OType iLinkedType) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            this.linkedType = iLinkedType;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPropertyImpl setNotNull(boolean isNotNull) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (this.isDistributedCommand()) {
                String cmd = String.format("alter property %s notnull %s", this.getFullNameQuoted(), isNotNull);
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.setNotNullInternal(isNotNull);
            } else {
                this.setNotNullInternal(isNotNull);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    protected void setNotNullInternal(boolean isNotNull) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            this.notNull = isNotNull;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPropertyImpl setDefaultValue(String defaultValue) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (this.isDistributedCommand()) {
                String cmd = String.format("alter property %s default %s", this.getFullNameQuoted(), OPropertyEmbedded.quoteString(defaultValue));
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.setDefaultValueInternal(defaultValue);
            } else {
                this.setDefaultValueInternal(defaultValue);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    protected void setDefaultValueInternal(String defaultValue) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            this.defaultValue = defaultValue;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPropertyImpl setMax(String max) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (this.isDistributedCommand()) {
                String cmd = String.format("alter property %s max %s", this.getFullNameQuoted(), OPropertyEmbedded.quoteString(max));
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.setMaxInternal(max);
            } else {
                this.setMaxInternal(max);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    protected void setMaxInternal(String max) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            this.checkForDateFormat(max);
            this.max = max;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPropertyImpl setMin(String min) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (this.isDistributedCommand()) {
                String cmd = String.format("alter property %s min %s", this.getFullNameQuoted(), OPropertyEmbedded.quoteString(min));
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.setMinInternal(min);
            } else {
                this.setMinInternal(min);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    protected void setMinInternal(String min) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            this.checkForDateFormat(min);
            this.min = min;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPropertyImpl setReadonly(boolean isReadonly) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (this.isDistributedCommand()) {
                String cmd = String.format("alter property %s readonly %s", this.getFullNameQuoted(), isReadonly);
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.setReadonlyInternal(isReadonly);
            } else {
                this.setReadonlyInternal(isReadonly);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    protected void setReadonlyInternal(boolean isReadonly) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            this.readonly = isReadonly;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPropertyImpl setMandatory(boolean isMandatory) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (this.isDistributedCommand()) {
                String cmd = String.format("alter property %s mandatory %s", this.getFullNameQuoted(), isMandatory);
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.setMandatoryInternal(isMandatory);
            } else {
                this.setMandatoryInternal(isMandatory);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    protected void setMandatoryInternal(boolean isMandatory) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            this.mandatory = isMandatory;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }
}

