/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexRemote;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class OIndexRemoteOneValue
extends OIndexRemote<OIdentifiable> {
    protected static final String QUERY_GET = "select rid from index:%s where key = ?";

    public OIndexRemoteOneValue(String iName, String iWrappedType, String algorithm, ORID iRid, OIndexDefinition iIndexDefinition, ODocument iConfiguration, Set<String> clustersToIndex, String database) {
        super(iName, iWrappedType, algorithm, iRid, iIndexDefinition, iConfiguration, clustersToIndex, database);
    }

    @Override
    public OIdentifiable get(Object iKey) {
        try (OResultSet result = this.getDatabase().command(String.format(QUERY_GET, this.name), iKey);){
            if (result != null && result.hasNext()) {
                OIdentifiable oIdentifiable = (OIdentifiable)result.next().getProperty("rid");
                return oIdentifiable;
            }
            OIdentifiable oIdentifiable = null;
            return oIdentifiable;
        }
    }

    public Iterator<Map.Entry<Object, OIdentifiable>> iterator() {
        try (OResultSet result = this.getDatabase().command(String.format("select key, rid from index:%s", this.name), new Object[0]);){
            Map<Object, OIdentifiable> map = result.stream().collect(Collectors.toMap(res -> res.getProperty("key"), res -> (OIdentifiable)res.getProperty("rid")));
            Iterator<Map.Entry<Object, OIdentifiable>> iterator = map.entrySet().iterator();
            return iterator;
        }
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    public boolean supportsOrderedIterations() {
        return false;
    }
}

