/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexAbstractCursor;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexKeyCursor;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OInternalResultSet;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public abstract class OIndexRemote<T>
implements OIndex<T> {
    public static final String QUERY_GET_VALUES_BEETWEN_SELECT = "select from index:%s where ";
    public static final String QUERY_GET_VALUES_BEETWEN_INCLUSIVE_FROM_CONDITION = "key >= ?";
    public static final String QUERY_GET_VALUES_BEETWEN_EXCLUSIVE_FROM_CONDITION = "key > ?";
    public static final String QUERY_GET_VALUES_BEETWEN_INCLUSIVE_TO_CONDITION = "key <= ?";
    public static final String QUERY_GET_VALUES_BEETWEN_EXCLUSIVE_TO_CONDITION = "key < ?";
    public static final String QUERY_GET_VALUES_AND_OPERATOR = " and ";
    public static final String QUERY_GET_VALUES_LIMIT = " limit ";
    protected static final String QUERY_ENTRIES = "select key, rid from index:%s";
    protected static final String QUERY_ENTRIES_DESC = "select key, rid from index:%s order by key desc";
    private static final String QUERY_ITERATE_ENTRIES = "select from index:%s where key in [%s] order by key %s ";
    private static final String QUERY_GET_ENTRIES = "select from index:%s where key in [%s]";
    private static final String QUERY_PUT = "insert into index:%s (key,rid) values (?,?)";
    private static final String QUERY_REMOVE = "delete from index:%s where key = ?";
    private static final String QUERY_REMOVE2 = "delete from index:%s where key = ? and rid = ?";
    private static final String QUERY_REMOVE3 = "delete from index:%s where rid = ?";
    private static final String QUERY_CONTAINS = "select count(*) as size from index:%s where key = ?";
    private static final String QUERY_COUNT = "select count(*) as size from index:%s where key = ?";
    private static final String QUERY_COUNT_RANGE = "select count(*) as size from index:%s where ";
    private static final String QUERY_SIZE = "select count(*) as size from index:%s";
    private static final String QUERY_KEY_SIZE = "select indexKeySize('%s') as size";
    private static final String QUERY_KEYS = "select key from index:%s";
    private static final String QUERY_REBUILD = "rebuild index %s";
    private static final String QUERY_CLEAR = "delete from index:%s";
    private static final String QUERY_DROP = "drop index %s";
    protected final String databaseName;
    private final String wrappedType;
    private final String algorithm;
    private final ORID rid;
    protected OIndexDefinition indexDefinition;
    protected String name;
    protected ODocument configuration;
    protected Set<String> clustersToIndex;

    public OIndexRemote(String iName, String iWrappedType, String algorithm, ORID iRid, OIndexDefinition iIndexDefinition, ODocument iConfiguration, Set<String> clustersToIndex, String database) {
        this.name = iName;
        this.wrappedType = iWrappedType;
        this.algorithm = algorithm;
        this.rid = iRid;
        this.indexDefinition = iIndexDefinition;
        this.configuration = iConfiguration;
        this.clustersToIndex = new HashSet<String>(clustersToIndex);
        this.databaseName = database;
    }

    @Override
    public OIndexRemote<T> create(String name, OIndexDefinition indexDefinition, String clusterIndexName, Set<String> clustersToIndex, boolean rebuild, OProgressListener progressListener) {
        this.name = name;
        return this;
    }

    @Override
    public OIndexRemote<T> delete() {
        this.getDatabase().command(String.format(QUERY_DROP, this.name), new Object[0]);
        return this;
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public long getRebuildVersion() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object iKey) {
        try (OResultSet result = this.getDatabase().command(String.format("select count(*) as size from index:%s where key = ?", this.name), iKey);){
            if (!result.hasNext()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = (Long)result.next().getProperty("size") > 0L;
            return bl;
        }
    }

    @Override
    public long count(Object iKey) {
        try (OResultSet result = this.getDatabase().command(String.format("select count(*) as size from index:%s where key = ?", this.name), iKey);){
            if (!result.hasNext()) {
                long l = 0L;
                return l;
            }
            long l = (Long)result.next().getProperty("size");
            return l;
        }
    }

    public long count(Object iRangeFrom, boolean iFromInclusive, Object iRangeTo, boolean iToInclusive, int maxValuesToFetch) {
        StringBuilder query = new StringBuilder(QUERY_COUNT_RANGE);
        if (iFromInclusive) {
            query.append(QUERY_GET_VALUES_BEETWEN_INCLUSIVE_FROM_CONDITION);
        } else {
            query.append(QUERY_GET_VALUES_BEETWEN_EXCLUSIVE_FROM_CONDITION);
        }
        query.append(QUERY_GET_VALUES_AND_OPERATOR);
        if (iToInclusive) {
            query.append(QUERY_GET_VALUES_BEETWEN_INCLUSIVE_TO_CONDITION);
        } else {
            query.append(QUERY_GET_VALUES_BEETWEN_EXCLUSIVE_TO_CONDITION);
        }
        if (maxValuesToFetch > 0) {
            query.append(QUERY_GET_VALUES_LIMIT).append(maxValuesToFetch);
        }
        try (OResultSet rs = this.getDatabase().command(query.toString(), iRangeFrom, iRangeTo);){
            long l = (Long)rs.next().getProperty("value");
            return l;
        }
    }

    @Override
    public OIndexRemote<T> put(Object iKey, OIdentifiable iValue) {
        if (iValue instanceof ORecord && !iValue.getIdentity().isValid()) {
            ((ORecord)iValue).save();
        }
        if (iValue.getIdentity().isNew()) {
            throw new OIndexException("Cannot insert values in manual indexes against remote protocol during a transaction. Temporary RID cannot be managed at server side");
        }
        this.getDatabase().command(String.format(QUERY_PUT, this.name), iKey, iValue.getIdentity());
        return this;
    }

    @Override
    public boolean remove(Object key) {
        OResultSet result = this.getDatabase().command(String.format(QUERY_REMOVE, this.name), key);
        if (!result.hasNext()) {
            return false;
        }
        return (Long)result.next().getProperty("count") > 0L;
    }

    @Override
    public boolean remove(Object iKey, OIdentifiable iRID) {
        long deleted;
        if (iRID != null) {
            if (iRID.getIdentity().isNew()) {
                throw new OIndexException("Cannot remove values in manual indexes against remote protocol during a transaction. Temporary RID cannot be managed at server side");
            }
            OResultSet result = this.getDatabase().command(String.format(QUERY_REMOVE2, this.name), iKey, iRID);
            deleted = !result.hasNext() ? 0L : (Long)result.next().getProperty("count");
            result.close();
        } else {
            OResultSet result = this.getDatabase().command(String.format(QUERY_REMOVE, this.name), iKey);
            deleted = !result.hasNext() ? 0L : (Long)result.next().getProperty("count");
            result.close();
        }
        return deleted > 0L;
    }

    public int remove(OIdentifiable iRecord) {
        try (OResultSet rs = this.getDatabase().command(String.format(QUERY_REMOVE3, this.name, iRecord.getIdentity()), iRecord);){
            int n = (Integer)rs.next().getProperty("value");
            return n;
        }
    }

    @Override
    public int getVersion() {
        if (this.configuration == null) {
            return -1;
        }
        Integer version = (Integer)this.configuration.field("indexVersion");
        if (version != null) {
            return version;
        }
        return -1;
    }

    public void automaticRebuild() {
        throw new UnsupportedOperationException("autoRebuild()");
    }

    @Override
    public long rebuild() {
        try (OResultSet rs = this.getDatabase().command(String.format(QUERY_REBUILD, this.name), new Object[0]);){
            long l = (Long)rs.next().getProperty("totalIndexed");
            return l;
        }
    }

    @Override
    public OIndexRemote<T> clear() {
        this.getDatabase().command(String.format(QUERY_CLEAR, this.name), new Object[0]);
        return this;
    }

    @Override
    public long getSize() {
        try (OResultSet result = this.getDatabase().query(String.format(QUERY_SIZE, this.name), new Object[0]);){
            if (result.hasNext()) {
                long l = (Long)result.next().getProperty("size");
                return l;
            }
        }
        return 0L;
    }

    @Override
    public long getKeySize() {
        try (OResultSet result = this.getDatabase().query(String.format(QUERY_KEY_SIZE, this.name), new Object[0]);){
            if (result.hasNext()) {
                long l = (Long)result.next().getProperty("size");
                return l;
            }
        }
        return 0L;
    }

    @Override
    public boolean isAutomatic() {
        return this.indexDefinition != null && this.indexDefinition.getClassName() != null;
    }

    @Override
    public boolean isUnique() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void flush() {
    }

    @Override
    public String getType() {
        return this.wrappedType;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public ODocument getConfiguration() {
        return this.configuration;
    }

    @Override
    public ODocument getMetadata() {
        return (ODocument)this.configuration.field("metadata", OType.EMBEDDED);
    }

    public ORID getIdentity() {
        return this.rid;
    }

    public void commit(ODocument iDocument) {
    }

    @Override
    public OIndexInternal<T> getInternal() {
        return null;
    }

    @Override
    public long rebuild(OProgressListener iProgressListener) {
        return this.rebuild();
    }

    @Override
    public OType[] getKeyTypes() {
        if (this.indexDefinition != null) {
            return this.indexDefinition.getTypes();
        }
        return new OType[0];
    }

    public Collection<ODocument> getEntries(Collection<?> iKeys) {
        StringBuilder params = new StringBuilder(128);
        if (!iKeys.isEmpty()) {
            params.append("?");
            for (int i = 1; i < iKeys.size(); ++i) {
                params.append(", ?");
            }
        }
        try (OResultSet rs = this.getDatabase().command(String.format(QUERY_GET_ENTRIES, this.name, params.toString()), iKeys.toArray());){
            Collection collection = rs.stream().map(res -> (ODocument)res.toElement()).collect(Collectors.toList());
            return collection;
        }
    }

    @Override
    public OIndexDefinition getDefinition() {
        return this.indexDefinition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OIndexRemote that = (OIndexRemote)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public Set<String> getClusters() {
        return Collections.unmodifiableSet(this.clustersToIndex);
    }

    @Override
    public boolean isRebuilding() {
        return false;
    }

    @Override
    public Object getFirstKey() {
        throw new UnsupportedOperationException("getFirstKey");
    }

    @Override
    public Object getLastKey() {
        throw new UnsupportedOperationException("getLastKey");
    }

    @Override
    public OIndexCursor iterateEntriesBetween(Object fromKey, boolean fromInclusive, Object toKey, boolean toInclusive, boolean ascOrder) {
        throw new UnsupportedOperationException("iterateEntriesBetween");
    }

    @Override
    public OIndexCursor iterateEntriesMajor(Object fromKey, boolean fromInclusive, boolean ascOrder) {
        throw new UnsupportedOperationException("iterateEntriesMajor");
    }

    @Override
    public OIndexCursor iterateEntriesMinor(Object toKey, boolean toInclusive, boolean ascOrder) {
        throw new UnsupportedOperationException("iterateEntriesMinor");
    }

    @Override
    public OIndexCursor iterateEntries(Collection<?> keys, boolean ascSortOrder) {
        StringBuilder params = new StringBuilder(128);
        if (!keys.isEmpty()) {
            params.append("?");
            for (int i = 1; i < keys.size(); ++i) {
                params.append(", ?");
            }
        }
        OResultSet res = this.getDatabase().command(String.format(QUERY_ITERATE_ENTRIES, this.name, params.toString(), ascSortOrder ? "ASC" : "DESC"), keys.toArray());
        final OInternalResultSet copy = new OInternalResultSet();
        res.forEachRemaining((Consumer<? super OResult>)((Consumer<OResult>)x -> copy.add((OResult)x)));
        res.close();
        return new OIndexAbstractCursor(){

            @Override
            public Map.Entry<Object, OIdentifiable> nextEntry() {
                if (!copy.hasNext()) {
                    return null;
                }
                final OResult next = copy.next();
                return new Map.Entry<Object, OIdentifiable>(){

                    @Override
                    public Object getKey() {
                        return next.getProperty("key");
                    }

                    @Override
                    public OIdentifiable getValue() {
                        return (OIdentifiable)next.getProperty("rid");
                    }

                    @Override
                    public OIdentifiable setValue(OIdentifiable value) {
                        throw new UnsupportedOperationException("cannot set value of index entry");
                    }
                };
            }
        };
    }

    @Override
    public int getIndexId() {
        throw new UnsupportedOperationException("getIndexId");
    }

    @Override
    public OIndexCursor cursor() {
        OResultSet result = this.getDatabase().command(String.format(QUERY_ENTRIES, this.name), new Object[0]);
        final OInternalResultSet copy = new OInternalResultSet();
        result.forEachRemaining((Consumer<? super OResult>)((Consumer<OResult>)x -> copy.add((OResult)x)));
        result.close();
        return new OIndexAbstractCursor(){

            @Override
            public Map.Entry<Object, OIdentifiable> nextEntry() {
                if (!copy.hasNext()) {
                    return null;
                }
                final OResult value = copy.next();
                return new Map.Entry<Object, OIdentifiable>(){

                    @Override
                    public Object getKey() {
                        return value.getProperty("key");
                    }

                    @Override
                    public OIdentifiable getValue() {
                        return (OIdentifiable)value.getProperty("rid");
                    }

                    @Override
                    public OIdentifiable setValue(OIdentifiable value2) {
                        throw new UnsupportedOperationException("setValue");
                    }
                };
            }
        };
    }

    @Override
    public OIndexCursor descCursor() {
        OResultSet result = this.getDatabase().command(String.format(QUERY_ENTRIES_DESC, this.name), new Object[0]);
        final OInternalResultSet copy = new OInternalResultSet();
        result.forEachRemaining((Consumer<? super OResult>)((Consumer<OResult>)x -> copy.add((OResult)x)));
        result.close();
        return new OIndexAbstractCursor(){

            @Override
            public Map.Entry<Object, OIdentifiable> nextEntry() {
                if (!copy.hasNext()) {
                    return null;
                }
                final OResult value = copy.next();
                return new Map.Entry<Object, OIdentifiable>(){

                    @Override
                    public Object getKey() {
                        return value.getProperty("key");
                    }

                    @Override
                    public OIdentifiable getValue() {
                        return (OIdentifiable)value.getProperty("rid");
                    }

                    @Override
                    public OIdentifiable setValue(OIdentifiable value2) {
                        throw new UnsupportedOperationException("setValue");
                    }
                };
            }
        };
    }

    @Override
    public OIndexKeyCursor keyCursor() {
        OResultSet result = this.getDatabase().command(String.format(QUERY_KEYS, this.name), new Object[0]);
        final OInternalResultSet copy = new OInternalResultSet();
        result.forEachRemaining((Consumer<? super OResult>)((Consumer<OResult>)x -> copy.add((OResult)x)));
        result.close();
        return new OIndexKeyCursor(){

            @Override
            public Object next(int prefetchSize) {
                if (!copy.hasNext()) {
                    return null;
                }
                OResult value = copy.next();
                return value.getProperty("key");
            }
        };
    }

    @Override
    public int compareTo(OIndex<T> index) {
        String name = index.getName();
        return this.name.compareTo(name);
    }

    protected ODatabaseDocumentInternal getDatabase() {
        return ODatabaseRecordThreadLocal.instance().get();
    }
}

