/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.encryption.impl;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.encryption.OEncryption;
import com.orientechnologies.orient.core.encryption.impl.OAbstractEncryption;
import com.orientechnologies.orient.core.exception.OInvalidStorageEncryptionKeyException;
import com.orientechnologies.orient.core.exception.OSecurityException;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public class OAESEncryption
extends OAbstractEncryption {
    private final String TRANSFORMATION = "AES/ECB/PKCS5Padding";
    private final String ALGORITHM_NAME = "AES";
    private SecretKeySpec theKey;
    private Cipher cipher;
    private boolean initialized = false;
    public static final String NAME = "aes";

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public OEncryption configure(String iOptions) {
        this.initialized = false;
        if (iOptions == null) {
            throw new OSecurityException("AES encryption has been selected, but no key was found. Please configure it by passing the key as property at database create/open. The property key is: '" + OGlobalConfiguration.STORAGE_ENCRYPTION_KEY.getKey() + "'");
        }
        try {
            byte[] key = Base64.getDecoder().decode(iOptions);
            this.theKey = new SecretKeySpec(key, "AES");
            this.cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        }
        catch (Exception e) {
            throw OException.wrapException(new OInvalidStorageEncryptionKeyException("Cannot initialize AES encryption with current key. Assure the key is a BASE64 - 128 oe 256 bits long"), e);
        }
        this.initialized = true;
        return this;
    }

    @Override
    public byte[] encryptOrDecrypt(int mode, byte[] input, int offset, int length) throws Exception {
        byte[] content;
        if (!this.initialized) {
            throw new OSecurityException("AES encryption algorithm is not available");
        }
        this.cipher.init(mode, this.theKey);
        if (offset == 0 && length == input.length) {
            content = input;
        } else {
            content = new byte[length];
            System.arraycopy(input, offset, content, 0, length);
        }
        return this.cipher.doFinal(content);
    }
}

