/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.orientechnologies.orient.core.cache.OCommandCacheSoftRefs;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.DistributedQueryContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseLifecycleListener;
import com.orientechnologies.orient.core.db.OMetadataUpdateListener;
import com.orientechnologies.orient.core.db.OSharedContext;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexFactory;
import com.orientechnologies.orient.core.index.OIndexManagerShared;
import com.orientechnologies.orient.core.index.OIndexes;
import com.orientechnologies.orient.core.metadata.function.OFunctionLibraryImpl;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchemaEmbedded;
import com.orientechnologies.orient.core.metadata.sequence.OSequenceLibraryImpl;
import com.orientechnologies.orient.core.query.live.OLiveQueryHook;
import com.orientechnologies.orient.core.query.live.OLiveQueryHookV2;
import com.orientechnologies.orient.core.schedule.OSchedulerImpl;
import com.orientechnologies.orient.core.security.OSecurityManager;
import com.orientechnologies.orient.core.sql.executor.OQueryStats;
import com.orientechnologies.orient.core.sql.parser.OExecutionPlanCache;
import com.orientechnologies.orient.core.sql.parser.OStatementCache;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import java.util.HashMap;
import java.util.Map;

public class OSharedContextEmbedded
extends OSharedContext {
    private Map<String, DistributedQueryContext> activeDistributedQueries;

    public OSharedContextEmbedded(OStorage storage) {
        this.schema = new OSchemaEmbedded(this);
        this.security = OSecurityManager.instance().newSecurity();
        this.indexManager = new OIndexManagerShared(storage);
        this.functionLibrary = new OFunctionLibraryImpl();
        this.scheduler = new OSchedulerImpl();
        this.sequenceLibrary = new OSequenceLibraryImpl();
        this.liveQueryOps = new OLiveQueryHook.OLiveQueryOps();
        this.liveQueryOpsV2 = new OLiveQueryHookV2.OLiveQueryOps();
        this.commandCache = new OCommandCacheSoftRefs(storage);
        this.statementCache = new OStatementCache(storage.getConfiguration().getContextConfiguration().getValueAsInteger(OGlobalConfiguration.STATEMENT_CACHE_SIZE));
        this.executionPlanCache = new OExecutionPlanCache(storage.getConfiguration().getContextConfiguration().getValueAsInteger(OGlobalConfiguration.STATEMENT_CACHE_SIZE));
        this.registerListener(this.executionPlanCache);
        this.queryStats = new OQueryStats();
        this.activeDistributedQueries = new HashMap<String, DistributedQueryContext>();
        ((OAbstractPaginatedStorage)storage).setStorageConfigurationUpdateListener(update -> {
            for (OMetadataUpdateListener listener : this.browseListeners()) {
                listener.onStorageConfigurationUpdate(storage.getName(), update);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void load(ODatabaseDocumentInternal database) {
        long timer = PROFILER.startChrono();
        try {
            if (!this.loaded) {
                this.schema.load(database);
                this.indexManager.load(database);
                this.schema.forceSnapshot();
                this.security.load();
                this.functionLibrary.load(database);
                this.scheduler.load(database);
                this.sequenceLibrary.load(database);
                this.schema.onPostIndexManagement();
                this.loaded = true;
            }
        }
        finally {
            PROFILER.stopChrono(PROFILER.getDatabaseMetric(database.getStorage().getName(), "metadata.load"), "Loading of database metadata", timer, "db.*.metadata.load");
        }
    }

    @Override
    public synchronized void close() {
        this.schema.close();
        this.security.close(false);
        this.indexManager.close();
        this.functionLibrary.close();
        this.scheduler.close();
        this.sequenceLibrary.close();
        this.commandCache.clear();
        this.commandCache.shutdown();
        this.statementCache.clear();
        this.executionPlanCache.invalidate();
        this.liveQueryOps.close();
        this.liveQueryOpsV2.close();
        this.activeDistributedQueries.values().forEach(x -> x.close());
    }

    @Override
    public synchronized void reload(ODatabaseDocumentInternal database) {
        this.schema.reload();
        this.indexManager.reload();
        this.schema.forceSnapshot();
        this.security.load();
        this.functionLibrary.load(database);
        this.sequenceLibrary.load(database);
        this.commandCache.clear();
        this.scheduler.load(database);
    }

    public synchronized void create(ODatabaseDocumentInternal database) {
        this.schema.create(database);
        this.indexManager.create(database);
        this.security.create();
        this.functionLibrary.create(database);
        this.sequenceLibrary.create(database);
        this.security.createClassTrigger();
        this.scheduler.create(database);
        this.schema.forceSnapshot();
        this.schema.createClass(database, "V");
        this.schema.createClass(database, "E");
        try {
            OIndexFactory factory = OIndexes.getFactory(OClass.INDEX_TYPE.SPATIAL.toString(), "LUCENE");
            if (factory != null && factory instanceof ODatabaseLifecycleListener) {
                ((ODatabaseLifecycleListener)((Object)factory)).onCreate(database);
            }
        }
        catch (OIndexException oIndexException) {
            // empty catch block
        }
        this.loaded = true;
    }

    public Map<String, DistributedQueryContext> getActiveDistributedQueries() {
        return this.activeDistributedQueries;
    }
}

