/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.orientechnologies.common.concur.resource.OResourcePool;
import com.orientechnologies.common.concur.resource.OResourcePoolListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabasePoolInternal;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.db.OrientDBInternal;

public class ODatabasePoolImpl
implements ODatabasePoolInternal {
    private final OResourcePool<Void, ODatabaseDocumentInternal> pool;
    private final OrientDBInternal factory;
    private final OrientDBConfig config;

    public ODatabasePoolImpl(final OrientDBInternal factory, final String database, final String user, final String password, OrientDBConfig config) {
        int max = config.getConfigurations().getValueAsInteger(OGlobalConfiguration.DB_POOL_MAX);
        this.pool = new OResourcePool<Void, ODatabaseDocumentInternal>(max, new OResourcePoolListener<Void, ODatabaseDocumentInternal>(){

            @Override
            public ODatabaseDocumentInternal createNewResource(Void iKey, Object ... iAdditionalArgs) {
                return factory.poolOpen(database, user, password, ODatabasePoolImpl.this);
            }

            @Override
            public boolean reuseResource(Void iKey, Object[] iAdditionalArgs, ODatabaseDocumentInternal iValue) {
                if (iValue.getStorage().isClosed()) {
                    return false;
                }
                iValue.reuse();
                return true;
            }
        });
        this.factory = factory;
        this.config = config;
    }

    @Override
    public synchronized ODatabaseSession acquire() {
        return this.pool.getResource(null, 1000L, new Object[0]);
    }

    @Override
    public synchronized void close() {
        for (ODatabaseDocumentInternal res : this.pool.getAllResources()) {
            res.realClose();
        }
        this.pool.close();
        this.factory.removePool(this);
    }

    @Override
    public synchronized void release(ODatabaseDocumentInternal database) {
        this.pool.returnResource(database);
    }

    @Override
    public OrientDBConfig getConfig() {
        return this.config;
    }
}

