/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.OSharedContext;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.metadata.security.OToken;
import com.orientechnologies.orient.core.storage.OBasicTransaction;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public interface ODatabaseInternal<T>
extends ODatabase<T> {
    public OStorage getStorage();

    public void setUser(OSecurityUser var1);

    public void replaceStorage(OStorage var1);

    public <V> V callInLock(Callable<V> var1, boolean var2);

    public void resetInitialization();

    public ODatabaseInternal<?> getDatabaseOwner();

    public ODatabaseInternal<?> setDatabaseOwner(ODatabaseInternal<?> var1);

    public <DB extends ODatabase> DB getUnderlying();

    public void setInternal(ODatabase.ATTRIBUTES var1, Object var2);

    @Deprecated
    public <DB extends ODatabase> DB open(OToken var1);

    public OSharedContext getSharedContext();

    public OBasicTransaction getMicroOrRegularTransaction();

    default public String getLocalNodeName() {
        return "local";
    }

    default public Map<String, Set<String>> getActiveClusterMap() {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        result.put(this.getLocalNodeName(), this.getStorage().getClusterNames());
        return result;
    }

    default public Map<String, Set<String>> getActiveDataCenterMap() {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        HashSet<String> val = new HashSet<String>();
        val.add(this.getLocalNodeName());
        result.put("local", val);
        return result;
    }

    default public boolean isSharded() {
        return false;
    }
}

