/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.command.script.transformer;

import com.orientechnologies.orient.core.command.script.OScriptResultSet;
import com.orientechnologies.orient.core.command.script.OScriptResultSets;
import com.orientechnologies.orient.core.command.script.transformer.OScriptTransformer;
import com.orientechnologies.orient.core.command.script.transformer.result.MapTransformer;
import com.orientechnologies.orient.core.command.script.transformer.result.OResultTransformer;
import com.orientechnologies.orient.core.command.script.transformer.resultset.ONashornObjectMirrorTransformer;
import com.orientechnologies.orient.core.command.script.transformer.resultset.OResultSetTransformer;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import jdk.nashorn.api.scripting.ScriptObjectMirror;

public class OScriptTransformerImpl
implements OScriptTransformer {
    protected Map<Class, OResultSetTransformer> resultSetTransformers = new HashMap<Class, OResultSetTransformer>();
    protected Map<Class, OResultTransformer> transformers = new HashMap<Class, OResultTransformer>();

    public OScriptTransformerImpl() {
        this.registerResultTransformer(HashMap.class, new MapTransformer(this));
        this.registerResultTransformer(LinkedHashMap.class, new MapTransformer(this));
        this.registerResultSetTransformer(ScriptObjectMirror.class, new ONashornObjectMirrorTransformer(this));
    }

    @Override
    public OResultSet toResultSet(Object value) {
        if (value == null) {
            return OScriptResultSets.empty();
        }
        if (value instanceof OResultSet) {
            return (OResultSet)value;
        }
        if (value instanceof Iterator) {
            return new OScriptResultSet((Iterator)value, this);
        }
        OResultSetTransformer oResultSetTransformer = this.resultSetTransformers.get(value.getClass());
        if (oResultSetTransformer != null) {
            return oResultSetTransformer.transform(value);
        }
        return this.defaultResultSet(value);
    }

    private OResultSet defaultResultSet(Object value) {
        return new OScriptResultSet(Collections.singletonList(value).iterator(), this);
    }

    @Override
    public OResult toResult(Object value) {
        OResultTransformer transformer = this.transformers.get(value.getClass());
        if (transformer == null) {
            return this.defaultTransformer(value);
        }
        return transformer.transform(value);
    }

    @Override
    public boolean doesHandleResult(Object value) {
        return this.transformers.get(value.getClass()) != null;
    }

    private OResult defaultTransformer(Object value) {
        OResultInternal internal = new OResultInternal();
        internal.setProperty("value", value);
        return internal;
    }

    @Override
    public void registerResultTransformer(Class clazz, OResultTransformer transformer) {
        this.transformers.put(clazz, transformer);
    }

    public void registerResultSetTransformer(Class clazz, OResultSetTransformer transformer) {
        this.resultSetTransformers.put(clazz, transformer);
    }
}

