/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.profiler;

import com.orientechnologies.common.concur.resource.OSharedResourceAbstract;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.common.profiler.OProfilerEntry;
import com.orientechnologies.common.profiler.OProfilerListener;
import com.orientechnologies.common.profiler.OProfilerMXBean;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.OOrientStartupListener;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.cache.OReadCache;
import com.orientechnologies.orient.core.storage.cache.OWriteCache;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import java.io.File;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public abstract class OAbstractProfiler
extends OSharedResourceAbstract
implements OProfiler,
OOrientStartupListener,
OProfilerMXBean {
    protected final Map<String, OProfilerHookRuntime> hooks = new ConcurrentHashMap<String, OProfilerHookRuntime>();
    protected final ConcurrentHashMap<String, String> dictionary = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, OProfiler.METRIC_TYPE> types = new ConcurrentHashMap();
    protected long recordingFrom = -1L;
    protected TimerTask autoDumpTask;
    protected List<OProfilerListener> listeners = new ArrayList<OProfilerListener>();
    private static long statsCreateRecords = 0L;
    private static long statsReadRecords = 0L;
    private static long statsUpdateRecords = 0L;
    private static long statsDeleteRecords = 0L;
    private static long statsCommands = 0L;
    private static long statsTxCommit = 0L;
    private static long statsTxRollback = 0L;
    private static long statsLastAutoDump = 0L;

    public OAbstractProfiler() {
        this(true);
    }

    public OAbstractProfiler(boolean registerListener) {
        if (registerListener) {
            Orient.instance().registerWeakOrientStartupListener(this);
        }
    }

    public OAbstractProfiler(OAbstractProfiler profiler) {
        this.hooks.putAll(profiler.hooks);
        this.dictionary.putAll(profiler.dictionary);
        this.types.putAll(profiler.types);
        Orient.instance().registerWeakOrientStartupListener(this);
    }

    protected abstract void setTip(String var1, AtomicInteger var2);

    protected abstract AtomicInteger getTip(String var1);

    public static String dumpEnvironment(String dumpType) {
        StringBuilder buffer = new StringBuilder();
        Runtime runtime = Runtime.getRuntime();
        long freeSpaceInMB = new File(".").getFreeSpace();
        long totalSpaceInMB = new File(".").getTotalSpace();
        int stgs = 0;
        long diskCacheUsed = 0L;
        long diskCacheTotal = 0L;
        for (OStorage stg : Orient.instance().getStorages()) {
            if (!(stg instanceof OLocalPaginatedStorage)) continue;
            diskCacheUsed += ((OLocalPaginatedStorage)stg).getReadCache().getUsedMemory();
            diskCacheTotal += OGlobalConfiguration.DISK_CACHE_SIZE.getValueAsLong() * 1024L * 1024L;
            ++stgs;
        }
        try {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName osMBeanName = ObjectName.getInstance("java.lang:type=OperatingSystem");
            if (mbs.isInstanceOf(osMBeanName, "com.sun.management.OperatingSystemMXBean")) {
                long osTotalMem = ((Number)mbs.getAttribute(osMBeanName, "TotalPhysicalMemorySize")).longValue();
                long osUsedMem = osTotalMem - ((Number)mbs.getAttribute(osMBeanName, "FreePhysicalMemorySize")).longValue();
                buffer.append(String.format("OrientDB Memory profiler: HEAP=%s of %s - DISKCACHE (%s dbs)=%s of %s - OS=%s of %s - FS=%s of %s", OFileUtils.getSizeAsString(runtime.totalMemory() - runtime.freeMemory()), OFileUtils.getSizeAsString(runtime.maxMemory()), stgs, OFileUtils.getSizeAsString(diskCacheUsed), OFileUtils.getSizeAsString(diskCacheTotal), OFileUtils.getSizeAsString(osUsedMem), OFileUtils.getSizeAsString(osTotalMem), OFileUtils.getSizeAsString(freeSpaceInMB), OFileUtils.getSizeAsString(totalSpaceInMB)));
            }
        }
        catch (Exception e) {
            buffer.append(String.format("OrientDB Memory profiler: HEAP=%s of %s - DISKCACHE (%s dbs)=%s of %s - FS=%s of %s", OFileUtils.getSizeAsString(runtime.totalMemory() - runtime.freeMemory()), OFileUtils.getSizeAsString(runtime.maxMemory()), stgs, OFileUtils.getSizeAsString(diskCacheUsed), OFileUtils.getSizeAsString(diskCacheTotal), OFileUtils.getSizeAsString(freeSpaceInMB), OFileUtils.getSizeAsString(totalSpaceInMB)));
        }
        if ("performance".equalsIgnoreCase(dumpType)) {
            try {
                long lastCreateRecords = 0L;
                long lastReadRecords = 0L;
                long lastUpdateRecords = 0L;
                long lastDeleteRecords = 0L;
                long lastCommands = 0L;
                long lastTxCommit = 0L;
                long lastTxRollback = 0L;
                if (statsLastAutoDump > 0L) {
                    long lastTxCommitSec;
                    long lastCommandsSec;
                    long lastDeleteRecordsSec;
                    long lastUpdateRecordsSec;
                    long lastCreateRecordsSec;
                    String[] hooks;
                    long msFromLastDump = System.currentTimeMillis() - statsLastAutoDump;
                    for (String h : hooks = Orient.instance().getProfiler().getHookAsString()) {
                        if (h.startsWith("db.") && h.endsWith("createRecord")) {
                            lastCreateRecords += ((Long)Orient.instance().getProfiler().getHookValue(h)).longValue();
                            continue;
                        }
                        if (h.startsWith("db.") && h.endsWith("readRecord")) {
                            lastReadRecords += ((Long)Orient.instance().getProfiler().getHookValue(h)).longValue();
                            continue;
                        }
                        if (h.startsWith("db.") && h.endsWith("updateRecord")) {
                            lastUpdateRecords += ((Long)Orient.instance().getProfiler().getHookValue(h)).longValue();
                            continue;
                        }
                        if (h.startsWith("db.") && h.endsWith("deleteRecord")) {
                            lastDeleteRecords += ((Long)Orient.instance().getProfiler().getHookValue(h)).longValue();
                            continue;
                        }
                        if (h.startsWith("db.") && h.endsWith("txCommit")) {
                            lastTxCommit += ((Long)Orient.instance().getProfiler().getHookValue(h)).longValue();
                            continue;
                        }
                        if (!h.startsWith("db.") || !h.endsWith("txRollback")) continue;
                        lastTxRollback += ((Long)Orient.instance().getProfiler().getHookValue(h)).longValue();
                    }
                    List<String> chronos = Orient.instance().getProfiler().getChronos();
                    for (String c : chronos) {
                        OProfilerEntry chrono = Orient.instance().getProfiler().getChrono(c);
                        if (chrono == null || !c.startsWith("db.") || !c.contains(".command.")) continue;
                        lastCommands += chrono.entries;
                    }
                    long l = lastCreateRecords == 0L ? (msFromLastDump < 1000L ? 1L : 0L) : (lastCreateRecordsSec = (lastCreateRecords - statsCreateRecords) / (msFromLastDump / 1000L));
                    long lastReadRecordsSec = lastReadRecords == 0L ? 0L : (msFromLastDump < 1000L ? 1L : (lastReadRecords - statsReadRecords) / (msFromLastDump / 1000L));
                    long l2 = lastUpdateRecordsSec = lastUpdateRecords == 0L || msFromLastDump < 1000L ? 0L : (lastUpdateRecords - statsUpdateRecords) / (msFromLastDump / 1000L);
                    long l3 = lastDeleteRecords == 0L ? 0L : (lastDeleteRecordsSec = msFromLastDump < 1000L ? 1L : (lastDeleteRecords - statsDeleteRecords) / (msFromLastDump / 1000L));
                    long l4 = lastCommands == 0L ? 0L : (lastCommandsSec = msFromLastDump < 1000L ? 1L : (lastCommands - statsCommands) / (msFromLastDump / 1000L));
                    long l5 = lastTxCommit == 0L ? 0L : (lastTxCommitSec = msFromLastDump < 1000L ? 1L : (lastTxCommit - statsTxCommit) / (msFromLastDump / 1000L));
                    long lastTxRollbackSec = lastTxRollback == 0L ? 0L : (msFromLastDump < 1000L ? 1L : (lastTxRollback - statsTxRollback) / (msFromLastDump / 1000L));
                    buffer.append(String.format("\nCRUD: C(%d %d/sec) R(%d %d/sec) U(%d %d/sec) D(%d %d/sec) - COMMANDS (%d %d/sec) - TX: COMMIT(%d %d/sec) ROLLBACK(%d %d/sec)", lastCreateRecords, lastCreateRecordsSec, lastReadRecords, lastReadRecordsSec, lastUpdateRecords, lastUpdateRecordsSec, lastDeleteRecords, lastDeleteRecordsSec, lastCommands, lastCommandsSec, lastTxCommit, lastTxCommitSec, lastTxRollback, lastTxRollbackSec));
                }
                statsLastAutoDump = System.currentTimeMillis();
                statsCreateRecords = lastCreateRecords;
                statsReadRecords = lastReadRecords;
                statsUpdateRecords = lastUpdateRecords;
                statsDeleteRecords = lastDeleteRecords;
                statsCommands = lastCommands;
                statsTxCommit = lastTxCommit;
                statsTxRollback = lastTxRollback;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return buffer.toString();
    }

    @Override
    public void onStartup() {
        if (OGlobalConfiguration.PROFILER_ENABLED.getValueAsBoolean()) {
            this.startRecording();
        }
        this.installMemoryChecker();
    }

    @Override
    public void shutdown() {
        this.stopRecording();
    }

    @Override
    public int reportTip(String iMessage) {
        AtomicInteger counter = this.getTip(iMessage);
        if (counter == null) {
            OLogManager.instance().info((Object)this, "[TIP] " + iMessage, new Object[0]);
            counter = new AtomicInteger(0);
        }
        this.setTip(iMessage, counter);
        return counter.incrementAndGet();
    }

    @Override
    public boolean startRecording() {
        if (this.isRecording()) {
            return false;
        }
        this.recordingFrom = System.currentTimeMillis();
        return true;
    }

    @Override
    public boolean stopRecording() {
        if (!this.isRecording()) {
            return false;
        }
        this.recordingFrom = -1L;
        return true;
    }

    @Override
    public boolean isRecording() {
        return this.recordingFrom > -1L;
    }

    @Override
    public void updateCounter(String iStatName, String iDescription, long iPlus) {
        this.updateCounter(iStatName, iDescription, iPlus, iStatName);
    }

    @Override
    public String getName() {
        return "profiler";
    }

    @Override
    public void startup() {
        this.startRecording();
    }

    @Override
    public String dump() {
        return OAbstractProfiler.dumpEnvironment(OGlobalConfiguration.PROFILER_AUTODUMP_TYPE.getValueAsString());
    }

    @Override
    public void dump(PrintStream out) {
        out.println(OAbstractProfiler.dumpEnvironment(OGlobalConfiguration.PROFILER_AUTODUMP_TYPE.getValueAsString()));
    }

    @Override
    public String dump(String type) {
        return OAbstractProfiler.dumpEnvironment(type);
    }

    @Override
    public String dumpCounters() {
        return null;
    }

    @Override
    public OProfilerEntry getChrono(String string) {
        return null;
    }

    @Override
    public long startChrono() {
        return 0L;
    }

    @Override
    public long stopChrono(String iName, String iDescription, long iStartTime) {
        return 0L;
    }

    @Override
    public long stopChrono(String iName, String iDescription, long iStartTime, String iDictionary) {
        return 0L;
    }

    @Override
    public String dumpChronos() {
        return null;
    }

    @Override
    public String[] getCountersAsString() {
        return null;
    }

    @Override
    public String[] getChronosAsString() {
        return null;
    }

    @Override
    public Date getLastReset() {
        return null;
    }

    @Override
    public void setAutoDump(int iSeconds) {
        if (this.autoDumpTask != null) {
            this.autoDumpTask.cancel();
            this.autoDumpTask = null;
        }
        if (iSeconds > 0) {
            OLogManager.instance().info((Object)this, "Enabled auto dump of profiler every %d second(s)", iSeconds);
            int ms = iSeconds * 1000;
            this.autoDumpTask = new TimerTask(){

                @Override
                public void run() {
                    StringBuilder output = new StringBuilder();
                    String dumpType = OGlobalConfiguration.PROFILER_AUTODUMP_TYPE.getValueAsString();
                    output.append("\n*******************************************************************************************************************************************");
                    output.append("\nPROFILER AUTO DUMP '" + dumpType + "' OUTPUT (to disabled it set 'profiler.autoDump.interval' = 0):\n");
                    output.append(OAbstractProfiler.this.dump(dumpType));
                    output.append("\n*******************************************************************************************************************************************");
                    OLogManager.instance().info(null, output.toString(), new Object[0]);
                }
            };
            Orient.instance().scheduleTask(this.autoDumpTask, ms, (long)ms);
        } else {
            OLogManager.instance().info((Object)this, "Auto dump of profiler disabled", iSeconds);
        }
    }

    @Override
    public String metadataToJSON() {
        return null;
    }

    @Override
    public Map<String, OPair<String, OProfiler.METRIC_TYPE>> getMetadata() {
        HashMap<String, OPair<String, OProfiler.METRIC_TYPE>> metadata = new HashMap<String, OPair<String, OProfiler.METRIC_TYPE>>();
        for (Map.Entry<String, String> entry : this.dictionary.entrySet()) {
            metadata.put(entry.getKey(), new OPair<Comparable, OProfiler.METRIC_TYPE>((Comparable)((Object)entry.getValue()), this.types.get(entry.getKey())));
        }
        return metadata;
    }

    @Override
    public String[] getHookAsString() {
        ArrayList<String> keys = new ArrayList<String>(this.hooks.keySet());
        String[] array = new String[keys.size()];
        return keys.toArray(array);
    }

    @Override
    public void registerHookValue(String iName, String iDescription, OProfiler.METRIC_TYPE iType, OProfilerHookValue iHookValue) {
        this.registerHookValue(iName, iDescription, iType, iHookValue, iName);
    }

    @Override
    public void registerHookValue(String iName, String iDescription, OProfiler.METRIC_TYPE iType, OProfilerHookValue iHookValue, String iMetadataName) {
        if (iName != null) {
            this.unregisterHookValue(iName);
            this.updateMetadata(iMetadataName, iDescription, iType);
            this.hooks.put(iName, new OProfilerHookRuntime(iHookValue, iType));
        }
    }

    @Override
    public void unregisterHookValue(String iName) {
        if (iName != null) {
            this.hooks.remove(iName);
        }
    }

    @Override
    public String getSystemMetric(String iMetricName) {
        StringBuilder buffer = new StringBuilder("system.".length() + iMetricName.length() + 1);
        buffer.append("system.");
        buffer.append(iMetricName);
        return buffer.toString();
    }

    @Override
    public String getProcessMetric(String iMetricName) {
        StringBuilder buffer = new StringBuilder("process.".length() + iMetricName.length() + 1);
        buffer.append("process.");
        buffer.append(iMetricName);
        return buffer.toString();
    }

    @Override
    public String getDatabaseMetric(String iDatabaseName, String iMetricName) {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append("db.");
        buffer.append(iDatabaseName != null ? iDatabaseName : "*");
        buffer.append('.');
        buffer.append(iMetricName);
        return buffer.toString();
    }

    @Override
    public String toJSON(String command, String iPar1) {
        return null;
    }

    protected void installMemoryChecker() {
        long memoryCheckInterval = OGlobalConfiguration.PROFILER_MEMORYCHECK_INTERVAL.getValueAsLong();
        if (memoryCheckInterval > 0L) {
            Orient.instance().scheduleTask((TimerTask)new MemoryChecker(), memoryCheckInterval, memoryCheckInterval);
        }
    }

    protected void updateMetadata(String iName, String iDescription, OProfiler.METRIC_TYPE iType) {
        if (iDescription != null && this.dictionary.putIfAbsent(iName, iDescription) == null) {
            this.types.put(iName, iType);
        }
    }

    @Override
    public void registerListener(OProfilerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void unregisterListener(OProfilerListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public String threadDump() {
        ThreadInfo[] threadInfos;
        StringBuilder dump = new StringBuilder();
        dump.append("THREAD DUMP\n");
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        for (ThreadInfo threadInfo : threadInfos = threadMXBean.getThreadInfo(threadMXBean.getAllThreadIds(), 100)) {
            StackTraceElement[] stackTraceElements;
            dump.append('\"');
            dump.append(threadInfo.getThreadName());
            dump.append("\" ");
            Thread.State state = threadInfo.getThreadState();
            dump.append("\n   java.lang.Thread.State: ");
            dump.append((Object)state);
            for (StackTraceElement stackTraceElement : stackTraceElements = threadInfo.getStackTrace()) {
                dump.append("\n        at ");
                dump.append(stackTraceElement);
            }
            dump.append("\n\n");
        }
        return dump.toString();
    }

    @Override
    public OProfiler.METRIC_TYPE getType(String k) {
        return this.types.get(k);
    }

    private static final class MemoryChecker
    extends TimerTask {
        private MemoryChecker() {
        }

        @Override
        public void run() {
            try {
                long jvmTotMemory = Runtime.getRuntime().totalMemory();
                long jvmMaxMemory = Runtime.getRuntime().maxMemory();
                for (OStorage s : Orient.instance().getStorages()) {
                    if (!(s instanceof OLocalPaginatedStorage)) continue;
                    OReadCache dk = ((OLocalPaginatedStorage)s).getReadCache();
                    OWriteCache wk = ((OLocalPaginatedStorage)s).getWriteCache();
                    if (dk == null || wk == null) continue;
                    long totalDiskCacheUsedMemory = (dk.getUsedMemory() + wk.getExclusiveWriteCachePagesSize()) / 0x100000L;
                    long maxDiskCacheUsedMemory = OGlobalConfiguration.DISK_CACHE_SIZE.getValueAsLong();
                    if (jvmTotMemory * 140L / 100L >= jvmMaxMemory || totalDiskCacheUsedMemory * 120L / 100L <= maxDiskCacheUsedMemory) continue;
                    long suggestedMaxHeap = jvmTotMemory * 120L / 100L;
                    long suggestedDiskCache = OGlobalConfiguration.DISK_CACHE_SIZE.getValueAsLong() + (jvmMaxMemory - suggestedMaxHeap) / 0x100000L;
                    OLogManager.instance().info((Object)this, "Database '%s' uses %,dMB/%,dMB of DISKCACHE memory, while Heap is not completely used (usedHeap=%dMB maxHeap=%dMB). To improve performance set maxHeap to %dMB and DISKCACHE to %dMB", s.getName(), totalDiskCacheUsedMemory, maxDiskCacheUsedMemory, jvmTotMemory / 0x100000L, jvmMaxMemory / 0x100000L, suggestedMaxHeap / 0x100000L, suggestedDiskCache);
                    OLogManager.instance().info((Object)this, "-> Open server.sh (or server.bat on Windows) and change the following variables: 1) MAXHEAP=-Xmx%dM 2) MAXDISKCACHE=%d", suggestedMaxHeap / 0x100000L, suggestedDiskCache);
                }
            }
            catch (Exception e) {
                OLogManager.instance().debug((Object)this, "Error on memory checker task", e, new Object[0]);
            }
            catch (Error e) {
                OLogManager.instance().debug((Object)this, "Error on memory checker task", e, new Object[0]);
                throw e;
            }
        }
    }

    public class OProfilerHookStatic {
        public Object value;
        public OProfiler.METRIC_TYPE type;

        public OProfilerHookStatic(Object value, OProfiler.METRIC_TYPE type) {
            this.value = value;
            this.type = type;
        }
    }

    public class OProfilerHookRuntime {
        public OProfilerHookValue hook;
        public OProfiler.METRIC_TYPE type;

        public OProfilerHookRuntime(OProfilerHookValue hook, OProfiler.METRIC_TYPE type) {
            this.hook = hook;
            this.type = type;
        }
    }

    public static interface OProfilerHookValue {
        public Object getValue();
    }
}

