/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.jna;

import com.orientechnologies.common.jna.OCLibrary;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OMemory;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class ONative {
    private static volatile OCLibrary C_LIBRARY;
    private static final String DEFAULT_MEMORY_CGROUP_PATH = "/sys/fs/memory";
    private static volatile ONative instance;
    private static final Lock initLock;

    public static ONative instance() {
        if (instance != null) {
            return instance;
        }
        initLock.lock();
        try {
            if (instance != null) {
                ONative oNative = instance;
                return oNative;
            }
            C_LIBRARY = Platform.isLinux() ? (OCLibrary)Native.loadLibrary((String)"c", OCLibrary.class) : null;
            instance = new ONative();
        }
        finally {
            initLock.unlock();
        }
        return instance;
    }

    private ONative() {
    }

    public MemoryLimitResult getMemoryLimit(boolean printSteps) {
        long memoryLimit = this.getPhysicalMemorySize();
        boolean insideContainer = false;
        if (printSteps) {
            OLogManager.instance().infoNoDb(this, "%d B/%d MB/%d GB of physical memory were detected on machine", memoryLimit, ONative.convertToMB(memoryLimit), ONative.convertToGB(memoryLimit));
        }
        if (Platform.isLinux()) {
            String memoryCGroupPath;
            OCLibrary.Rlimit rlimit = new OCLibrary.Rlimit();
            int result = C_LIBRARY.getrlimit(9, rlimit);
            if (result == 0) {
                if (printSteps) {
                    OLogManager.instance().infoNoDb(this, "Soft memory limit for this process is set to %d B/%d MB/%d GB", rlimit.rlim_cur, ONative.convertToMB(rlimit.rlim_cur), ONative.convertToGB(rlimit.rlim_cur));
                }
                memoryLimit = this.updateMemoryLimit(memoryLimit, rlimit.rlim_cur);
                if (printSteps) {
                    OLogManager.instance().infoNoDb(this, "Hard memory limit for this process is set to %d B/%d MB/%d GB", rlimit.rlim_max, ONative.convertToMB(rlimit.rlim_max), ONative.convertToGB(rlimit.rlim_max));
                }
                memoryLimit = this.updateMemoryLimit(memoryLimit, rlimit.rlim_max);
            }
            if ((memoryCGroupPath = this.findMemoryGCGroupPath()) != null) {
                File memoryCGroup;
                if (printSteps) {
                    OLogManager.instance().infoNoDb(this, "Path to 'memory' cgroup is '%s'", memoryCGroupPath);
                }
                String memoryCGroupRoot = this.findMemoryGCRoot();
                if (printSteps) {
                    OLogManager.instance().infoNoDb(this, "Mounting path for memory cgroup controller is '%s'", memoryCGroupRoot);
                }
                if (!(memoryCGroup = new File(memoryCGroupRoot, memoryCGroupPath)).exists()) {
                    if (printSteps) {
                        OLogManager.instance().infoNoDb(this, "Can not find '%s' path for memory cgroup, it is supposed that process is running in container, will try to read root '%s' memory cgroup data", memoryCGroup, memoryCGroupRoot);
                    }
                    memoryCGroup = new File(memoryCGroupRoot);
                    insideContainer = true;
                }
                long softMemoryLimit = this.fetchCGroupSoftMemoryLimit(memoryCGroup, printSteps);
                memoryLimit = this.updateMemoryLimit(memoryLimit, softMemoryLimit);
                long hardMemoryLimit = this.fetchCGroupHardMemoryLimit(memoryCGroup, printSteps);
                memoryLimit = this.updateMemoryLimit(memoryLimit, hardMemoryLimit);
            }
        }
        if (printSteps) {
            if (memoryLimit > 0L) {
                OLogManager.instance().infoNoDb(this, "Detected memory limit for current process is %d B/%d MB/%d GB", memoryLimit, ONative.convertToMB(memoryLimit), ONative.convertToGB(memoryLimit));
            } else {
                OLogManager.instance().infoNoDb(this, "Memory limit for current process is not set", new Object[0]);
            }
        }
        if (memoryLimit <= 0L) {
            return null;
        }
        return new MemoryLimitResult(memoryLimit, insideContainer);
    }

    private long updateMemoryLimit(long memoryLimit, long newMemoryLimit) {
        if (newMemoryLimit <= 0L) {
            return memoryLimit;
        }
        if (memoryLimit <= 0L) {
            memoryLimit = newMemoryLimit;
        }
        if (memoryLimit > newMemoryLimit) {
            memoryLimit = newMemoryLimit;
        }
        return memoryLimit;
    }

    /*
     * Exception decompiling
     */
    private long fetchCGroupSoftMemoryLimit(File memoryCGroup, boolean printSteps) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private long fetchCGroupHardMemoryLimit(File memoryCGroup, boolean printSteps) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String findMemoryGCGroupPath() {
        String memoryCGroupPath = null;
        File cgroupList = new File("/proc/self/cgroup");
        if (cgroupList.exists()) {
            try {
                FileReader cgroupListReader = new FileReader(cgroupList);
                try (BufferedReader bufferedCGroupReader = new BufferedReader(cgroupListReader);){
                    try {
                        String cgroupData;
                        while ((cgroupData = bufferedCGroupReader.readLine()) != null) {
                            String[] cgroupParts = cgroupData.split(":");
                            if (!cgroupParts[1].equals("memory")) continue;
                            memoryCGroupPath = cgroupParts[2];
                        }
                    }
                    catch (IOException ioe) {
                        OLogManager.instance().errorNoDb(this, "Error during reading of details of list of cgroups for the current process, no restrictions applied by cgroups will be taken into account", ioe, new Object[0]);
                        memoryCGroupPath = null;
                    }
                }
                catch (IOException e) {
                    OLogManager.instance().errorNoDb(this, "Error during closing of reader which reads details of list of cgroups for the current process", e, new Object[0]);
                }
            }
            catch (FileNotFoundException fnfe) {
                OLogManager.instance().warnNoDb(this, "Can not retrieve list of cgroups to which process belongs, no restrictions applied by cgroups will be taken into account", new Object[0]);
            }
        }
        return memoryCGroupPath;
    }

    private String findMemoryGCRoot() {
        String memoryCGroupRoot = null;
        File procMounts = new File("/proc/mounts");
        if (procMounts.exists()) {
            try {
                FileReader mountsReader = new FileReader(procMounts);
                try (BufferedReader bufferedMountsReader = new BufferedReader(mountsReader);){
                    String fileSystem;
                    while ((fileSystem = bufferedMountsReader.readLine()) != null) {
                        String fsMountingPath;
                        String[] fsPathParts;
                        String fsType;
                        String[] fsParts = fileSystem.split("\\s+");
                        if (fsParts.length == 0 || !(fsType = fsParts[0]).equals("cgroup") || !(fsPathParts = (fsMountingPath = fsParts[1]).split(File.separator))[fsPathParts.length - 1].equals("memory")) continue;
                        memoryCGroupRoot = fsMountingPath;
                    }
                }
                catch (IOException e) {
                    OLogManager.instance().errorNoDb(this, "Error during reading a list of mounted file systems", e, new Object[0]);
                    memoryCGroupRoot = DEFAULT_MEMORY_CGROUP_PATH;
                }
            }
            catch (FileNotFoundException fnfe) {
                memoryCGroupRoot = DEFAULT_MEMORY_CGROUP_PATH;
            }
        }
        if (memoryCGroupRoot == null) {
            memoryCGroupRoot = DEFAULT_MEMORY_CGROUP_PATH;
        }
        return memoryCGroupRoot;
    }

    private long getPhysicalMemorySize() {
        long osMemory;
        block11: {
            osMemory = -1L;
            try {
                MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
                Object attribute = mBeanServer.getAttribute(new ObjectName("java.lang", "type", "OperatingSystem"), "TotalPhysicalMemorySize");
                if (attribute != null) {
                    if (attribute instanceof Long) {
                        osMemory = (Long)attribute;
                        break block11;
                    }
                    try {
                        osMemory = Long.parseLong(attribute.toString());
                    }
                    catch (NumberFormatException e) {
                        if (!OLogManager.instance().isDebugEnabled()) {
                            OLogManager.instance().warnNoDb(OMemory.class, "Unable to determine the amount of installed RAM.", new Object[0]);
                            break block11;
                        }
                        OLogManager.instance().debugNoDb(OMemory.class, "Unable to determine the amount of installed RAM.", e, new Object[0]);
                    }
                    break block11;
                }
                if (!OLogManager.instance().isDebugEnabled()) {
                    OLogManager.instance().warnNoDb(OMemory.class, "Unable to determine the amount of installed RAM.", new Object[0]);
                }
            }
            catch (AttributeNotFoundException | InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
                if (!OLogManager.instance().isDebugEnabled()) {
                    OLogManager.instance().warnNoDb(OMemory.class, "Unable to determine the amount of installed RAM.", new Object[0]);
                } else {
                    OLogManager.instance().debugNoDb(OMemory.class, "Unable to determine the amount of installed RAM.", e, new Object[0]);
                }
            }
            catch (RuntimeException e) {
                OLogManager.instance().warnNoDb(OMemory.class, "Unable to determine the amount of installed RAM.", e);
            }
        }
        return osMemory;
    }

    private static long convertToMB(long bytes) {
        if (bytes < 0L) {
            return bytes;
        }
        return bytes / 0x100000L;
    }

    private static long convertToGB(long bytes) {
        if (bytes < 0L) {
            return bytes;
        }
        return bytes / 0x40000000L;
    }

    static {
        instance = null;
        initLock = new ReentrantLock();
    }

    public final class MemoryLimitResult {
        public final long memoryLimit;
        public final boolean insideContainer;

        MemoryLimitResult(long memoryLimit, boolean insideContainer) {
            this.memoryLimit = memoryLimit;
            this.insideContainer = insideContainer;
        }
    }
}

