/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.directmemory;

import com.orientechnologies.common.directmemory.OByteBufferPoolMXBean;
import com.orientechnologies.common.directmemory.ODirectMemoryAllocator;
import com.orientechnologies.common.directmemory.OPointer;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class OByteBufferPool
implements OByteBufferPoolMXBean {
    private static final boolean TRACK = OGlobalConfiguration.DIRECT_MEMORY_TRACK_MODE.getValueAsBoolean();
    private static final AtomicReference<OByteBufferPool> INSTANCE_HOLDER = new AtomicReference();
    private final int poolSize;
    private static final String MBEAN_NAME = "com.orientechnologies.common.directmemory:type=OByteBufferPoolMXBean";
    private final int pageSize;
    private final ConcurrentHashMap<ByteBufferHolder, PointerHolder> bufferPointerMapping = new ConcurrentHashMap();
    private final ConcurrentLinkedQueue<OPointer> pointersPool = new ConcurrentLinkedQueue();
    private final AtomicInteger pointersPoolSize = new AtomicInteger();
    private final ODirectMemoryAllocator allocator;

    public static OByteBufferPool instance() {
        OByteBufferPool instance = INSTANCE_HOLDER.get();
        if (instance != null) {
            return instance;
        }
        OByteBufferPool newInstance = new OByteBufferPool(OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger() * 1024);
        if (INSTANCE_HOLDER.compareAndSet(null, newInstance)) {
            return newInstance;
        }
        return INSTANCE_HOLDER.get();
    }

    public OByteBufferPool(int pageSize) {
        this.pageSize = pageSize;
        this.allocator = ODirectMemoryAllocator.instance();
        this.poolSize = OGlobalConfiguration.DIRECT_MEMORY_POOL_LIMIT.getValueAsInteger();
    }

    public OByteBufferPool(int pageSize, ODirectMemoryAllocator allocator, int poolSize) {
        this.pageSize = pageSize;
        this.allocator = allocator;
        this.poolSize = poolSize;
    }

    public ByteBuffer acquireDirect(boolean clear) {
        OPointer pointer = this.pointersPool.poll();
        if (pointer != null) {
            this.pointersPoolSize.decrementAndGet();
        } else {
            pointer = this.allocator.allocate(this.pageSize);
        }
        if (clear) {
            pointer.clear();
        }
        ByteBuffer buffer = pointer.getNativeByteBuffer();
        buffer.position(0);
        this.bufferPointerMapping.put(this.wrapBuffer(buffer), this.wrapPointer(pointer));
        return buffer;
    }

    public void release(ByteBuffer buffer) {
        PointerHolder holder = this.bufferPointerMapping.remove(this.wrapBuffer(buffer));
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Buffer %X is not acquired", System.identityHashCode(buffer)));
        }
        long poolSize = this.pointersPoolSize.incrementAndGet();
        if (poolSize > (long)this.poolSize) {
            this.pointersPoolSize.decrementAndGet();
            this.allocator.deallocate(holder.pointer);
        } else {
            this.pointersPool.add(holder.pointer);
        }
    }

    @Override
    public int getPoolSize() {
        return this.pointersPoolSize.get();
    }

    public void logTrackedBufferInfo(String prefix, ByteBuffer buffer) {
        if (TRACK) {
            StringBuilder builder = new StringBuilder();
            builder.append("DIRECT-TRACK: ").append(prefix).append(String.format(" buffer `%X` ", System.identityHashCode(buffer)));
            PointerHolder holder = this.bufferPointerMapping.get(this.wrapBuffer(buffer));
            if (holder == null) {
                builder.append("untracked");
            } else {
                builder.append("allocated from: ").append('\n').append(OByteBufferPool.getStackTraceAsString(holder.allocation)).append('\n');
            }
            OLogManager.instance().errorNoDb(this, builder.toString(), null, new Object[0]);
        }
    }

    public void checkMemoryLeaks() {
        boolean detected = false;
        if (TRACK) {
            for (Map.Entry<ByteBufferHolder, PointerHolder> entry : this.bufferPointerMapping.entrySet()) {
                OLogManager.instance().errorNoDb(this, "DIRECT-TRACK: unreleased direct memory buffer `%X` detected.", entry.getValue().allocation, System.identityHashCode(entry.getKey().byteBuffer));
                detected = true;
            }
        }
        assert (!detected);
    }

    public void clear() {
        for (OPointer pointer : this.pointersPool) {
            this.allocator.deallocate(pointer);
        }
        this.pointersPool.clear();
        this.pointersPoolSize.set(0);
        if (!TRACK && !this.bufferPointerMapping.isEmpty()) {
            String message = "There are not released allocations in ByteBufferPool which may indicate presence of memory leaks in database!!Start JVM with system property" + OGlobalConfiguration.DIRECT_MEMORY_TRACK_MODE.getKey() + " = true for more details";
            OLogManager.instance().warnNoDb(this, message, new Object[0]);
        }
        for (PointerHolder holder : this.bufferPointerMapping.values()) {
            this.allocator.deallocate(holder.pointer);
        }
        this.bufferPointerMapping.clear();
    }

    public void registerMBean() {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            ObjectName mbeanName = new ObjectName(MBEAN_NAME);
            if (!server.isRegistered(mbeanName)) {
                server.registerMBean(this, mbeanName);
            } else {
                OLogManager.instance().warnNoDb(this, "MBean with name %s has already registered. Probably your system was not shutdown correctly or you have several running applications which use OrientDB engine inside", mbeanName.getCanonicalName());
            }
        }
        catch (Exception e) {
            OLogManager.instance().errorNoDb(this, "Error during registration of MBean", e, new Object[0]);
        }
    }

    public void unregisterMBean() {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            ObjectName mbeanName = new ObjectName(MBEAN_NAME);
            server.unregisterMBean(mbeanName);
        }
        catch (Exception e) {
            OLogManager.instance().errorNoDb(this, "Error during de-registration of MBean", e, new Object[0]);
        }
    }

    private ByteBufferHolder wrapBuffer(ByteBuffer byteBuffer) {
        return new ByteBufferHolder(byteBuffer);
    }

    private PointerHolder wrapPointer(OPointer pointer) {
        if (TRACK) {
            return new PointerHolder(pointer, new Exception());
        }
        return new PointerHolder(pointer, null);
    }

    private static String getStackTraceAsString(Throwable throwable) {
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    private static final class PointerHolder {
        private final OPointer pointer;
        private final Exception allocation;

        PointerHolder(OPointer pointer, Exception allocation) {
            this.pointer = pointer;
            this.allocation = allocation;
        }
    }

    private static final class ByteBufferHolder {
        private final ByteBuffer byteBuffer;

        ByteBufferHolder(ByteBuffer byteBuffer) {
            this.byteBuffer = byteBuffer;
        }

        public int hashCode() {
            return System.identityHashCode(this.byteBuffer);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ByteBufferHolder)) {
                return false;
            }
            return ((ByteBufferHolder)obj).byteBuffer == this.byteBuffer;
        }
    }
}

