/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.concur.lock;

import com.orientechnologies.common.concur.lock.OLockManager;
import com.orientechnologies.common.concur.lock.OReadersWriterSpinLock;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class OPartitionedLockManager<T>
implements OLockManager<T> {
    private static final int HASH_BITS = Integer.MAX_VALUE;
    private final int concurrencyLevel = OPartitionedLockManager.closestInteger(OGlobalConfiguration.ENVIRONMENT_LOCK_MANAGER_CONCURRENCY_LEVEL.getValueAsInteger());
    private final int mask = this.concurrencyLevel - 1;
    private final ReadWriteLock[] locks;
    private final OReadersWriterSpinLock[] spinLocks;
    private final boolean useSpinLock;
    private final Comparator comparator = new Comparator(){

        public int compare(Object one, Object two) {
            int indexTwo;
            int indexOne = one == null ? 0 : OPartitionedLockManager.this.index(one.hashCode());
            if (indexOne > (indexTwo = two == null ? 0 : OPartitionedLockManager.this.index(two.hashCode()))) {
                return 1;
            }
            if (indexOne < indexTwo) {
                return -1;
            }
            return 0;
        }
    };

    public OPartitionedLockManager() {
        this(false);
    }

    public OPartitionedLockManager(boolean useSpinLock) {
        this.useSpinLock = useSpinLock;
        if (useSpinLock) {
            OReadersWriterSpinLock[] lcks = new OReadersWriterSpinLock[this.concurrencyLevel];
            for (int i = 0; i < lcks.length; ++i) {
                lcks[i] = new OReadersWriterSpinLock();
            }
            this.spinLocks = lcks;
            this.locks = null;
        } else {
            ReadWriteLock[] lcks = new ReadWriteLock[this.concurrencyLevel];
            for (int i = 0; i < lcks.length; ++i) {
                lcks[i] = new ReentrantReadWriteLock();
            }
            this.locks = lcks;
            this.spinLocks = null;
        }
    }

    private static int closestInteger(int value) {
        return 1 << 32 - Integer.numberOfLeadingZeros(value - 1);
    }

    private static int longHashCode(long value) {
        return (int)(value ^ value >>> 32);
    }

    private int index(int hashCode) {
        return OPartitionedLockManager.shuffleHashCode(hashCode) & this.mask;
    }

    public static int shuffleHashCode(int h) {
        return (h ^ h >>> 16) & Integer.MAX_VALUE;
    }

    @Override
    public Lock acquireExclusiveLock(long value) {
        int hashCode = OPartitionedLockManager.longHashCode(value);
        int index = this.index(hashCode);
        if (this.useSpinLock) {
            OReadersWriterSpinLock spinLock = this.spinLocks[index];
            spinLock.acquireWriteLock();
            return new SpinLockWrapper(false, spinLock);
        }
        ReadWriteLock rwLock = this.locks[index];
        Lock lock = rwLock.writeLock();
        lock.lock();
        return lock;
    }

    @Override
    public Lock acquireExclusiveLock(int value) {
        int index = this.index(value);
        if (this.useSpinLock) {
            OReadersWriterSpinLock spinLock = this.spinLocks[index];
            spinLock.acquireWriteLock();
            return new SpinLockWrapper(false, spinLock);
        }
        ReadWriteLock rwLock = this.locks[index];
        Lock lock = rwLock.writeLock();
        lock.lock();
        return lock;
    }

    @Override
    public Lock acquireExclusiveLock(T value) {
        int index = value == null ? 0 : this.index(value.hashCode());
        if (this.useSpinLock) {
            OReadersWriterSpinLock spinLock = this.spinLocks[index];
            spinLock.acquireWriteLock();
            return new SpinLockWrapper(false, spinLock);
        }
        ReadWriteLock rwLock = this.locks[index];
        Lock lock = rwLock.writeLock();
        lock.lock();
        return lock;
    }

    public void lockAllExclusive() {
        if (this.useSpinLock) {
            for (OReadersWriterSpinLock spinLock : this.spinLocks) {
                spinLock.acquireWriteLock();
            }
        } else {
            for (ReadWriteLock readWriteLock : this.locks) {
                readWriteLock.writeLock().lock();
            }
        }
    }

    public void unlockAllExclusive() {
        if (this.useSpinLock) {
            for (OReadersWriterSpinLock spinLock : this.spinLocks) {
                spinLock.releaseWriteLock();
            }
        } else {
            for (ReadWriteLock readWriteLock : this.locks) {
                readWriteLock.writeLock().unlock();
            }
        }
    }

    public boolean tryAcquireExclusiveLock(T value, long timeout) throws InterruptedException {
        if (this.useSpinLock) {
            throw new IllegalStateException("Spin lock does not support try lock mode");
        }
        int index = value == null ? 0 : this.index(value.hashCode());
        ReadWriteLock rwLock = this.locks[index];
        Lock lock = rwLock.writeLock();
        return lock.tryLock(timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public Lock[] acquireExclusiveLocksInBatch(T ... value) {
        if (value == null) {
            return new Lock[0];
        }
        Lock[] locks = new Lock[value.length];
        T[] sortedValues = this.getOrderedValues(value);
        for (int n = 0; n < sortedValues.length; ++n) {
            locks[n] = this.acquireExclusiveLock(sortedValues[n]);
        }
        return locks;
    }

    @Override
    public Lock[] acquireSharedLocksInBatch(T ... value) {
        if (value == null) {
            return new Lock[0];
        }
        Lock[] locks = new Lock[value.length];
        T[] sortedValues = this.getOrderedValues(value);
        for (int i = 0; i < sortedValues.length; ++i) {
            locks[i] = this.acquireSharedLock(sortedValues[i]);
        }
        return locks;
    }

    @Override
    public Lock[] acquireExclusiveLocksInBatch(Collection<T> values) {
        if (values == null || values.isEmpty()) {
            return new Lock[0];
        }
        Collection<T> valCopy = this.getOrderedValues(values);
        Lock[] locks = new Lock[values.size()];
        int i = 0;
        for (T val : valCopy) {
            locks[i++] = this.acquireExclusiveLock(val);
        }
        return locks;
    }

    @Override
    public Lock acquireSharedLock(long value) {
        int hashCode = OPartitionedLockManager.longHashCode(value);
        int index = this.index(hashCode);
        if (this.useSpinLock) {
            OReadersWriterSpinLock spinLock = this.spinLocks[index];
            spinLock.acquireReadLock();
            return new SpinLockWrapper(true, spinLock);
        }
        ReadWriteLock rwLock = this.locks[index];
        Lock lock = rwLock.readLock();
        lock.lock();
        return lock;
    }

    public boolean tryAcquireSharedLock(T value, long timeout) throws InterruptedException {
        if (this.useSpinLock) {
            throw new IllegalStateException("Spin lock does not support try lock mode");
        }
        int index = value == null ? 0 : this.index(value.hashCode());
        ReadWriteLock rwLock = this.locks[index];
        Lock lock = rwLock.readLock();
        return lock.tryLock(timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public Lock acquireSharedLock(int value) {
        int index = this.index(value);
        if (this.useSpinLock) {
            OReadersWriterSpinLock spinLock = this.spinLocks[index];
            spinLock.acquireReadLock();
            return new SpinLockWrapper(true, spinLock);
        }
        ReadWriteLock rwLock = this.locks[index];
        Lock lock = rwLock.readLock();
        lock.lock();
        return lock;
    }

    @Override
    public Lock acquireSharedLock(T value) {
        int index = value == null ? 0 : this.index(value.hashCode());
        if (this.useSpinLock) {
            OReadersWriterSpinLock spinLock = this.spinLocks[index];
            spinLock.acquireReadLock();
            return new SpinLockWrapper(true, spinLock);
        }
        ReadWriteLock rwLock = this.locks[index];
        Lock lock = rwLock.readLock();
        lock.lock();
        return lock;
    }

    @Override
    public void releaseSharedLock(int value) {
        int index = this.index(value);
        if (this.useSpinLock) {
            OReadersWriterSpinLock spinLock = this.spinLocks[index];
            spinLock.releaseReadLock();
            return;
        }
        ReadWriteLock rwLock = this.locks[index];
        rwLock.readLock().unlock();
    }

    @Override
    public void releaseSharedLock(long value) {
        int hashCode = OPartitionedLockManager.longHashCode(value);
        int index = this.index(hashCode);
        if (this.useSpinLock) {
            OReadersWriterSpinLock spinLock = this.spinLocks[index];
            spinLock.releaseReadLock();
            return;
        }
        ReadWriteLock rwLock = this.locks[index];
        Lock lock = rwLock.readLock();
        lock.unlock();
    }

    @Override
    public void releaseSharedLock(T value) {
        int index = value == null ? 0 : this.index(value.hashCode());
        if (this.useSpinLock) {
            OReadersWriterSpinLock spinLock = this.spinLocks[index];
            spinLock.releaseReadLock();
            return;
        }
        ReadWriteLock rwLock = this.locks[index];
        Lock lock = rwLock.readLock();
        lock.unlock();
    }

    @Override
    public void releaseExclusiveLock(int value) {
        int index = this.index(value);
        if (this.useSpinLock) {
            OReadersWriterSpinLock spinLock = this.spinLocks[index];
            spinLock.releaseWriteLock();
            return;
        }
        ReadWriteLock rwLock = this.locks[index];
        rwLock.writeLock().unlock();
    }

    @Override
    public void releaseExclusiveLock(long value) {
        int hashCode = OPartitionedLockManager.longHashCode(value);
        int index = this.index(hashCode);
        if (this.useSpinLock) {
            OReadersWriterSpinLock spinLock = this.spinLocks[index];
            spinLock.releaseWriteLock();
            return;
        }
        ReadWriteLock rwLock = this.locks[index];
        Lock lock = rwLock.writeLock();
        lock.unlock();
    }

    @Override
    public void releaseExclusiveLock(T value) {
        int index = value == null ? 0 : this.index(value.hashCode());
        if (this.useSpinLock) {
            OReadersWriterSpinLock spinLock = this.spinLocks[index];
            spinLock.releaseWriteLock();
            return;
        }
        ReadWriteLock rwLock = this.locks[index];
        Lock lock = rwLock.writeLock();
        lock.unlock();
    }

    public void releaseLock(Lock lock) {
        lock.unlock();
    }

    private <T> T[] getOrderedValues(T[] values) {
        if (values.length < 2) {
            return values;
        }
        T[] copy = Arrays.copyOf(values, values.length);
        Arrays.sort(copy, 0, copy.length, this.comparator);
        return copy;
    }

    private <T> Collection<T> getOrderedValues(Collection<T> values) {
        if (values.size() < 2) {
            return values;
        }
        ArrayList<T> valCopy = new ArrayList<T>(values);
        Collections.sort(valCopy, this.comparator);
        return valCopy;
    }

    private static final class SpinLockWrapper
    implements Lock {
        private final boolean readLock;
        private final OReadersWriterSpinLock spinLock;

        private SpinLockWrapper(boolean readLock, OReadersWriterSpinLock spinLock) {
            this.readLock = readLock;
            this.spinLock = spinLock;
        }

        @Override
        public void lock() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryLock() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void unlock() {
            if (this.readLock) {
                this.spinLock.releaseReadLock();
            } else {
                this.spinLock.releaseWriteLock();
            }
        }

        @Override
        public Condition newCondition() {
            throw new UnsupportedOperationException();
        }
    }
}

