/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.orientdb.traversal.step.sideEffect;

import com.google.common.annotations.VisibleForTesting;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.orientdb.OGraph;
import org.apache.tinkerpop.gremlin.orientdb.OrientGraphBaseQuery;
import org.apache.tinkerpop.gremlin.orientdb.OrientGraphQueryBuilder;
import org.apache.tinkerpop.gremlin.orientdb.OrientIndexQuery;
import org.apache.tinkerpop.gremlin.orientdb.executor.OGremlinResult;
import org.apache.tinkerpop.gremlin.process.traversal.Compare;
import org.apache.tinkerpop.gremlin.process.traversal.Contains;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.step.HasContainerHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.HasContainer;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.function.TriFunction;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class OrientGraphStep<S, E extends Element>
extends GraphStep<S, E>
implements HasContainerHolder {
    private static final long serialVersionUID = 8141248670294067626L;
    private final List<HasContainer> hasContainers = new ArrayList<HasContainer>();

    public OrientGraphStep(GraphStep<S, E> originalGraphStep) {
        super(originalGraphStep.getTraversal(), originalGraphStep.getReturnClass(), originalGraphStep.isStartStep(), originalGraphStep.getIds());
        originalGraphStep.getLabels().forEach(arg_0 -> ((OrientGraphStep)this).addLabel(arg_0));
        this.setIteratorSupplier(() -> this.isVertexStep() ? this.vertices() : this.edges());
    }

    public boolean isVertexStep() {
        return Vertex.class.isAssignableFrom(this.returnClass);
    }

    private Iterator<? extends Vertex> vertices() {
        return this.elements(Graph::vertices, OGraph::getIndexedVertices, rec$ -> ((Graph)rec$).vertices(new Object[0]), v -> v.getVertex().get());
    }

    private Iterator<? extends Edge> edges() {
        return this.elements(Graph::edges, OGraph::getIndexedEdges, rec$ -> ((Graph)rec$).edges(new Object[0]), e -> e.getEdge().get());
    }

    private <ElementType extends Element> Iterator<? extends ElementType> elements(BiFunction<OGraph, Object[], Iterator<ElementType>> getElementsByIds, TriFunction<OGraph, OIndex<Object>, Iterator<Object>, Stream<? extends ElementType>> getElementsByIndex, Function<OGraph, Iterator<ElementType>> getAllElements, Function<OGremlinResult, ElementType> getElement) {
        OGraph graph = this.getGraph();
        if (this.ids != null && this.ids.length > 0) {
            return this.iteratorList(getElementsByIds.apply(graph, this.ids));
        }
        Optional<Iterator> streamIterator = this.buildQuery().map(query -> query.execute(this.getGraph()).stream().map(getElement::apply).filter(element -> HasContainer.testAll((Element)element, this.hasContainers))).map(stream -> stream.iterator());
        if (streamIterator.isPresent()) {
            return streamIterator.get();
        }
        return this.iteratorList(getAllElements.apply(graph));
    }

    private boolean isLabelKey(String key) {
        try {
            return T.fromString((String)key) == T.label;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private Set<String> findClassLabelsInHasContainers() {
        HashSet<String> classLabels = new HashSet<String>();
        HasContainer container = this.hasContainers.stream().filter(hasContainer -> this.isLabelKey(hasContainer.getKey())).findFirst().orElseGet(() -> {
            String defaultClass = Vertex.class.isAssignableFrom(this.getReturnClass()) ? "V" : "E";
            HasContainer defaultContainer = new HasContainer(T.label.name(), P.eq((Object)defaultClass));
            return defaultContainer;
        });
        Object value = container.getValue();
        if (value instanceof List) {
            ((List)value).forEach(label -> classLabels.add((String)label));
        } else {
            classLabels.add((String)value);
        }
        return classLabels;
    }

    private OGraph getGraph() {
        return (OGraph)this.getTraversal().getGraph().get();
    }

    public Optional<OrientGraphBaseQuery> buildQuery() {
        OrientGraphQueryBuilder builder = new OrientGraphQueryBuilder(this.isVertexStep());
        this.hasContainers.forEach(builder::addCondition);
        return builder.build(this.getGraph());
    }

    @VisibleForTesting
    public Set<OrientIndexQuery> findIndex() {
        HashSet<OrientIndexQuery> indexedQueries = new HashSet<OrientIndexQuery>();
        OGraph graph = this.getGraph();
        OIndexManager indexManager = graph.getRawDatabase().getMetadata().getIndexManager();
        Set<String> classLabels = this.findClassLabelsInHasContainers();
        if (!classLabels.isEmpty()) {
            HashSet indexedKeys = new HashSet();
            classLabels.forEach(label -> indexedKeys.addAll(graph.getIndexedKeys(this.returnClass, (String)label)));
            this.hasContainers.stream().filter(c -> indexedKeys.contains(c.getKey()) && (c.getPredicate().getBiPredicate() == Compare.eq || c.getPredicate().getBiPredicate() == Contains.within)).findAny().ifPresent(requestedKeyValue -> {
                String key = requestedKeyValue.getKey();
                classLabels.forEach(classLabel -> {
                    Iterator<Object> values = this.getValueIterator((HasContainer)requestedKeyValue);
                    String className = graph.labelToClassName((String)classLabel, this.isVertexStep() ? "V" : "E");
                    Set classIndexes = indexManager.getClassIndexes(className);
                    Iterator keyIndexes = classIndexes.stream().filter(idx -> idx.getDefinition().getFields().contains(key)).iterator();
                    if (keyIndexes.hasNext()) {
                        indexedQueries.add(new OrientIndexQuery((OIndex)keyIndexes.next(), values));
                    } else {
                        OLogManager.instance().warn((Object)this, "no index found for class=[" + className + "] and key=[" + key + "]", new Object[0]);
                    }
                });
            });
        }
        return indexedQueries;
    }

    private Iterator<Object> getValueIterator(HasContainer c) {
        return c.getPredicate().getBiPredicate() == Contains.within ? ((Iterable)c.getValue()).iterator() : IteratorUtils.of((Object)c.getValue());
    }

    public String toString() {
        if (this.hasContainers.isEmpty()) {
            return super.toString();
        }
        return 0 == this.ids.length ? StringFactory.stepString((Step)this, (Object[])new Object[]{this.returnClass.getSimpleName().toLowerCase(), this.hasContainers}) : StringFactory.stepString((Step)this, (Object[])new Object[]{this.returnClass.getSimpleName().toLowerCase(), Arrays.toString(this.ids), this.hasContainers});
    }

    private <X extends Element> Iterator<X> iteratorList(Iterator<X> iterator) {
        ArrayList<Element> list = new ArrayList<Element>();
        while (iterator.hasNext()) {
            Element e = (Element)iterator.next();
            if (!HasContainer.testAll((Element)e, this.hasContainers)) continue;
            list.add(e);
        }
        return list.iterator();
    }

    public List<HasContainer> getHasContainers() {
        return Collections.unmodifiableList(this.hasContainers);
    }

    public void addHasContainer(HasContainer hasContainer) {
        this.hasContainers.add(hasContainer);
    }
}

