/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.orientdb.io.graphson;

import com.orientechnologies.orient.core.id.ORecordId;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.tinkerpop.gremlin.orientdb.io.OrientIoRegistry;
import org.apache.tinkerpop.gremlin.orientdb.io.graphson.ORecordIdJacksonDeserializer;
import org.apache.tinkerpop.gremlin.orientdb.io.graphson.ORecordIdJacksonSerializer;
import org.apache.tinkerpop.gremlin.orientdb.io.graphson.OrientGraphSON;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.io.graphson.AbstractObjectDeserializer;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedEdge;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedVertex;
import org.apache.tinkerpop.shaded.jackson.databind.JsonDeserializer;

public class OrientGraphSONV3
extends OrientGraphSON {
    public static OrientGraphSONV3 INSTANCE = new OrientGraphSONV3();
    protected static final Map<Class, String> TYPES = Collections.unmodifiableMap(new LinkedHashMap<Class, String>(){
        {
            this.put(ORecordId.class, "ORecordId");
        }
    });

    public OrientGraphSONV3() {
        super("orient-graphson-v3");
        this.addSerializer(ORecordId.class, new ORecordIdJacksonSerializer());
        this.addDeserializer(ORecordId.class, (JsonDeserializer)new ORecordIdJacksonDeserializer());
        this.addDeserializer(Edge.class, (JsonDeserializer)new EdgeJacksonDeserializer());
        this.addDeserializer(Vertex.class, (JsonDeserializer)new VertexJacksonDeserializer());
        this.addDeserializer(Map.class, (JsonDeserializer)new ORecordIdDeserializer());
    }

    @Override
    public Map<Class, String> getTypeDefinitions() {
        return TYPES;
    }

    static final class ORecordIdDeserializer
    extends AbstractObjectDeserializer<Object> {
        public ORecordIdDeserializer() {
            super(Object.class);
        }

        public Object createObject(Map<String, Object> data) {
            if (OrientIoRegistry.isORecord(data)) {
                return OrientIoRegistry.newORecordId(data);
            }
            return data;
        }
    }

    public static class VertexJacksonDeserializer
    extends AbstractObjectDeserializer<Vertex> {
        public VertexJacksonDeserializer() {
            super(Vertex.class);
        }

        public Vertex createObject(Map<String, Object> vertexData) {
            return new DetachedVertex((Object)OrientIoRegistry.newORecordId(vertexData.get("id")), vertexData.get("label").toString(), (Map)vertexData.get("properties"));
        }
    }

    public static class EdgeJacksonDeserializer
    extends AbstractObjectDeserializer<Edge> {
        public EdgeJacksonDeserializer() {
            super(Edge.class);
        }

        public Edge createObject(Map<String, Object> edgeData) {
            return new DetachedEdge((Object)OrientIoRegistry.newORecordId(edgeData.get("id")), edgeData.get("label").toString(), (Map)edgeData.get("properties"), (Object)OrientIoRegistry.newORecordId(edgeData.get("outV")), edgeData.get("outVLabel").toString(), (Object)OrientIoRegistry.newORecordId(edgeData.get("inV")), edgeData.get("inVLabel").toString());
        }
    }
}

