/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.orientdb.io;

import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.id.ORecordId;
import java.util.Map;
import org.apache.tinkerpop.gremlin.orientdb.io.graphson.OrientGraphSONV3;
import org.apache.tinkerpop.gremlin.orientdb.io.gryo.ORecordIdGyroSerializer;
import org.apache.tinkerpop.gremlin.orientdb.io.gryo.ORidBagGyroSerializer;
import org.apache.tinkerpop.gremlin.structure.io.AbstractIoRegistry;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONIo;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoIo;

public class OrientIoRegistry
extends AbstractIoRegistry {
    public static final String CLUSTER_ID = "clusterId";
    public static final String CLUSTER_POSITION = "clusterPosition";
    private static final OrientIoRegistry INSTANCE = new OrientIoRegistry();

    private OrientIoRegistry() {
        this.register(GryoIo.class, ORecordId.class, (Object)new ORecordIdGyroSerializer());
        this.register(GryoIo.class, ORidBag.class, (Object)new ORidBagGyroSerializer());
        this.register(GraphSONIo.class, ORecordId.class, (Object)OrientGraphSONV3.INSTANCE);
    }

    public static OrientIoRegistry instance() {
        return INSTANCE;
    }

    public static OrientIoRegistry getInstance() {
        return INSTANCE;
    }

    public static ORecordId newORecordId(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof ORecordId) {
            return (ORecordId)obj;
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            return new ORecordId(((Number)map.get(CLUSTER_ID)).intValue(), ((Number)map.get(CLUSTER_POSITION)).longValue());
        }
        throw new IllegalArgumentException("Unable to convert unknow type to ORecordId " + obj.getClass());
    }

    public static boolean isORecord(Object result) {
        if (!(result instanceof Map)) {
            return false;
        }
        Map map = (Map)result;
        return map.containsKey(CLUSTER_ID) && map.containsKey(CLUSTER_POSITION);
    }
}

