/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.iterator;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.object.ODatabaseObject;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClass;
import com.orientechnologies.orient.core.iterator.object.OObjectIteratorClassInterface;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.object.db.OObjectDatabaseTx;
import java.util.Iterator;

public class OObjectIteratorClass<T>
implements OObjectIteratorClassInterface<T> {
    private ODatabaseObject database;
    private ORecordIteratorClass<ODocument> underlying;
    private String fetchPlan;

    public OObjectIteratorClass(OObjectDatabaseTx iDatabase, ODatabaseDocumentInternal iUnderlyingDatabase, String iClusterName, boolean iPolymorphic) {
        this.database = iDatabase;
        this.underlying = new ORecordIteratorClass(iDatabase.getUnderlying(), iUnderlyingDatabase, iClusterName, iPolymorphic, true);
    }

    @Override
    public boolean hasNext() {
        return this.underlying.hasNext();
    }

    @Override
    public T next() {
        return this.next(this.fetchPlan);
    }

    public T next(String iFetchPlan) {
        return (T)this.database.getUserObjectByRecord((OIdentifiable)this.underlying.next(), iFetchPlan);
    }

    @Override
    public void remove() {
        this.underlying.remove();
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    public String getFetchPlan() {
        return this.fetchPlan;
    }

    public OObjectIteratorClass<T> setFetchPlan(String fetchPlan) {
        this.fetchPlan = fetchPlan;
        return this;
    }
}

