/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.verification;

import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.ComparatorHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.LambdaHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.SackValueStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.VerificationException;
import org.javatuples.Pair;

public final class LambdaRestrictionStrategy
extends AbstractTraversalStrategy<TraversalStrategy.VerificationStrategy>
implements TraversalStrategy.VerificationStrategy {
    private static final LambdaRestrictionStrategy INSTANCE = new LambdaRestrictionStrategy();

    private LambdaRestrictionStrategy() {
    }

    @Override
    public void apply(Traversal.Admin<?, ?> traversal) {
        if (traversal instanceof LambdaHolder) {
            throw new VerificationException("The provided traversal is a lambda traversal: ", traversal);
        }
        for (Step step : traversal.getSteps()) {
            String sackString;
            if (step instanceof LambdaHolder) {
                throw new VerificationException("The provided traversal contains a lambda step: " + step, traversal);
            }
            if (step instanceof ComparatorHolder) {
                for (Pair comparator : ((ComparatorHolder)((Object)step)).getComparators()) {
                    String comparatorString = comparator.toString();
                    if (!comparatorString.contains("$") && !comparatorString.contains("@")) continue;
                    throw new VerificationException("The provided step contains a lambda comparator: " + step, traversal);
                }
            }
            if (!(step instanceof SackValueStep) || !(sackString = ((SackValueStep)step).getSackFunction().toString()).contains("$") && !sackString.contains("@")) continue;
            throw new VerificationException("The provided step contains a lambda bi-function: " + step, traversal);
        }
    }

    public static LambdaRestrictionStrategy instance() {
        return INSTANCE;
    }
}

