/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.tx;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.client.remote.message.tx.ORecordOperationRequest;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.storage.OBasicTransaction;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionOptimistic;
import com.orientechnologies.orient.core.tx.OTransactionRecordIndexOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class OTransactionOptimisticProxy
extends OTransactionOptimistic {
    private final Map<ORID, ORecordOperation> tempEntries = new LinkedHashMap<ORID, ORecordOperation>();
    private final Map<ORecordId, ORecord> createdRecords = new HashMap<ORecordId, ORecord>();
    private final Map<ORecordId, ORecord> updatedRecords = new HashMap<ORecordId, ORecord>();
    @Deprecated
    private final int clientTxId = this.id;
    private final short protocolVersion;
    private List<ORecordOperationRequest> operations;
    private final ODocument indexChanges;
    private ORecordSerializer serializer;

    public OTransactionOptimisticProxy(ODatabaseDocumentInternal database, int txId, boolean usingLong, List<ORecordOperationRequest> operations, ODocument indexChanges, short protocolVersion, ORecordSerializer serializer) {
        super(database);
        this.setUsingLog(usingLong);
        this.operations = operations;
        this.indexChanges = indexChanges;
        this.protocolVersion = protocolVersion;
        this.serializer = serializer;
    }

    public void begin() {
        super.begin();
        try {
            for (ORecordOperationRequest operation : this.operations) {
                ORecordOperation entry;
                byte recordStatus = operation.getType();
                ORecordId rid = (ORecordId)operation.getId();
                switch (recordStatus) {
                    case 3: {
                        ORecord record = Orient.instance().getRecordFactoryManager().newInstance(operation.getRecordType(), rid.getClusterId(), this.getDatabase());
                        this.serializer.fromStream(operation.getRecord(), record, null);
                        ORecordInternal.setIdentity((ORecord)record, (ORecordId)rid);
                        ORecordInternal.setVersion((ORecord)record, (int)0);
                        entry = new ORecordOperation((OIdentifiable)record, 3);
                        record.setDirty();
                        this.createdRecords.put(rid.copy(), entry.getRecord());
                        break;
                    }
                    case 1: {
                        int version = operation.getVersion();
                        ORecord updated = Orient.instance().getRecordFactoryManager().newInstance(operation.getRecordType(), rid.getClusterId(), this.getDatabase());
                        ORecordInternal.setIdentity((ORecord)updated, (ORecordId)rid);
                        ORecordInternal.setVersion((ORecord)updated, (int)version);
                        entry = new ORecordOperation((OIdentifiable)updated, 1);
                        updated.setDirty();
                        ORecordInternal.setContentChanged((ORecord)entry.getRecord(), (boolean)operation.isContentChanged());
                        break;
                    }
                    case 2: {
                        ORecord rec = rid.getRecord();
                        entry = new ORecordOperation((OIdentifiable)rec, 2);
                        int deleteVersion = operation.getVersion();
                        if (rec == null) {
                            throw new ORecordNotFoundException(rid.getIdentity());
                        }
                        ORecordInternal.setVersion((ORecord)rec, (int)deleteVersion);
                        entry.setRecord((OIdentifiable)rec);
                        break;
                    }
                    default: {
                        throw new OTransactionException("Unrecognized tx command: " + recordStatus);
                    }
                }
                this.tempEntries.put(entry.getRecord().getIdentity(), entry);
            }
            this.operations = null;
            ODocument remoteIndexEntries = this.indexChanges;
            this.fillIndexOperations(remoteIndexEntries);
            for (Map.Entry<ORID, ORecordOperation> entry : this.tempEntries.entrySet()) {
                if (entry.getValue().type == 1) {
                    ORecord record = entry.getValue().record.getRecord();
                    boolean contentChanged = ORecordInternal.isContentChanged((ORecord)record);
                    ORecord loadedRecord = record.getIdentity().copy().getRecord();
                    if (loadedRecord == null) {
                        throw new ORecordNotFoundException(record.getIdentity());
                    }
                    if (ORecordInternal.getRecordType((ORecord)loadedRecord) == 100 && ORecordInternal.getRecordType((ORecord)loadedRecord) == ORecordInternal.getRecordType((ORecord)record)) {
                        ((ODocument)loadedRecord).merge((ODocument)record, false, false);
                        loadedRecord.setDirty();
                        ORecordInternal.setContentChanged((ORecord)loadedRecord, (boolean)contentChanged);
                        ORecordInternal.setVersion((ORecord)loadedRecord, (int)record.getVersion());
                        entry.getValue().record = loadedRecord;
                        this.updatedRecords.put((ORecordId)entry.getKey(), entry.getValue().getRecord());
                    }
                }
                this.addRecord(entry.getValue().getRecord(), entry.getValue().type, null);
            }
            this.tempEntries.clear();
            for (ORecord record : this.createdRecords.values()) {
                this.unmarshallRecord(record);
                if (!(record instanceof ODocument)) continue;
                ODocumentInternal.autoConvertValueToClass((ODatabaseDocumentInternal)this.getDatabase(), (ODocument)((ODocument)record));
            }
            for (ORecord record : this.updatedRecords.values()) {
                this.unmarshallRecord(record);
            }
        }
        catch (Exception e) {
            this.rollback();
            throw OException.wrapException((OException)((Object)new OSerializationException("Cannot read transaction record from the network. Transaction aborted")), (Throwable)e);
        }
    }

    public ORecord getRecord(ORID rid) {
        ORecord record = super.getRecord(rid);
        if (record == OBasicTransaction.DELETED_RECORD) {
            return record;
        }
        if (record == null && rid.isNew()) {
            record = this.createdRecords.get(rid);
        }
        return record;
    }

    private void fillIndexOperations(ODocument remoteIndexEntries) {
        for (Map.Entry indexEntry : remoteIndexEntries) {
            Collection entries;
            Boolean clearAll;
            String indexName = (String)indexEntry.getKey();
            ODocument indexDoc = (ODocument)indexEntry.getValue();
            if (indexDoc == null) continue;
            OTransactionIndexChanges transactionIndexChanges = (OTransactionIndexChanges)this.indexEntries.get(indexEntry.getKey());
            if (transactionIndexChanges == null) {
                transactionIndexChanges = new OTransactionIndexChanges();
                this.indexEntries.put(indexEntry.getKey(), transactionIndexChanges);
            }
            if ((clearAll = (Boolean)indexDoc.field("clear")) != null && clearAll.booleanValue()) {
                transactionIndexChanges.setCleared();
            }
            if ((entries = (Collection)indexDoc.field("entries")) == null) continue;
            for (ODocument entry : entries) {
                Object storedKey;
                List operations = (List)entry.field("ops");
                if (operations == null) continue;
                ODocument keyContainer = (ODocument)entry.field("k");
                Object key = keyContainer != null ? ((storedKey = keyContainer.field("key")) instanceof List ? new OCompositeKey((List)storedKey) : storedKey) : null;
                for (ODocument op : operations) {
                    int operation = (Integer)op.rawField("o");
                    OTransactionIndexChanges.OPERATION indexOperation = OTransactionIndexChanges.OPERATION.values()[operation];
                    OIdentifiable value = (OIdentifiable)op.field("v");
                    transactionIndexChanges.getChangesPerKey(key).add(value, indexOperation);
                    if (value == null) continue;
                    ORID rid = value.getIdentity();
                    ArrayList<OTransactionRecordIndexOperation> txIndexOperations = (ArrayList<OTransactionRecordIndexOperation>)this.recordIndexOperations.get(rid);
                    if (txIndexOperations == null) {
                        txIndexOperations = new ArrayList<OTransactionRecordIndexOperation>();
                        this.recordIndexOperations.put(rid, txIndexOperations);
                    }
                    txIndexOperations.add(new OTransactionRecordIndexOperation(indexName, key, indexOperation));
                }
            }
        }
    }

    public Map<ORecordId, ORecord> getCreatedRecords() {
        return this.createdRecords;
    }

    public Map<ORecordId, ORecord> getUpdatedRecords() {
        return this.updatedRecords;
    }

    private void unmarshallRecord(ORecord iRecord) {
        if (iRecord instanceof ODocument) {
            ((ODocument)iRecord).deserializeFields(new String[0]);
        }
    }
}

