/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.ODirection;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.serialization.serializer.OJSONWriter;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class OHttpGraphResponse
extends OHttpResponse {
    public OHttpGraphResponse(OHttpResponse iWrapped) {
        super(iWrapped.getOutputStream(), iWrapped.httpVersion, iWrapped.additionalHeaders, iWrapped.characterSet, iWrapped.serverInfo, iWrapped.sessionId, iWrapped.callbackFunction, iWrapped.keepAlive, iWrapped.connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeRecords(Object iRecords, String iFetchPlan, String iFormat, String accept, Map<String, Object> iAdditionalProperties, String mode) throws IOException {
        if (iRecords == null) {
            return;
        }
        if (!mode.equalsIgnoreCase("graph")) {
            super.writeRecords(iRecords, iFetchPlan, iFormat, accept, iAdditionalProperties, mode);
            return;
        }
        if (accept != null && accept.contains("text/csv")) {
            throw new IllegalArgumentException("Graph mode cannot accept '" + accept + "'");
        }
        try (ODatabaseDocumentInternal graph = ODatabaseRecordThreadLocal.instance().get();){
            HashSet<Object> vertices = new HashSet<Object>();
            Iterator iIterator = OMultiValue.getMultiValueIterator((Object)iRecords);
            while (iIterator.hasNext()) {
                Object entry = iIterator.next();
                if (entry != null && entry instanceof OResult && ((OResult)entry).isElement()) {
                    entry = ((OResult)entry).getElement().get();
                } else if (entry == null || !(entry instanceof OIdentifiable)) continue;
                if ((entry = ((OIdentifiable)entry).getRecord()) == null || !(entry instanceof OIdentifiable) || !(entry instanceof OElement)) continue;
                OElement element = (OElement)entry;
                if (element.isVertex()) {
                    vertices.add(element.asVertex().get());
                    continue;
                }
                if (!element.isEdge()) continue;
                OEdge edge = (OEdge)element.asEdge().get();
                vertices.add(edge.getTo());
                vertices.add(edge.getFrom());
            }
            StringWriter buffer = new StringWriter();
            OJSONWriter json = new OJSONWriter((Writer)buffer, "");
            json.beginObject();
            json.beginObject((Object)"graph");
            json.beginCollection("vertices");
            for (OVertex oVertex : vertices) {
                json.beginObject();
                json.writeAttribute("@rid", (Object)oVertex.getIdentity());
                json.writeAttribute("@class", (Object)((OClass)oVertex.getSchemaType().get()).getName());
                for (Object field : oVertex.getPropertyNames()) {
                    Object v = oVertex.getProperty((String)field);
                    if (v == null) continue;
                    json.writeAttribute((String)field, v);
                }
                json.endObject();
            }
            json.endCollection();
            json.beginCollection("edges");
            HashSet<ORID> edgeRids = new HashSet<ORID>();
            for (OVertex oVertex : vertices) {
                Object field;
                field = oVertex.getEdges(ODirection.BOTH).iterator();
                while (field.hasNext()) {
                    OEdge e;
                    OEdge edge = e = (OEdge)field.next();
                    if (edgeRids.contains(e.getIdentity()) || !vertices.contains(edge.getVertex(ODirection.OUT)) || !vertices.contains(edge.getVertex(ODirection.IN))) continue;
                    edgeRids.add(edge.getIdentity());
                    json.beginObject();
                    json.writeAttribute("@rid", (Object)edge.getIdentity());
                    json.writeAttribute("@class", edge.getSchemaType().map(x -> x.getName()).orElse(null));
                    json.writeAttribute("out", (Object)edge.getVertex(ODirection.OUT).getIdentity());
                    json.writeAttribute("in", (Object)edge.getVertex(ODirection.IN).getIdentity());
                    for (String field2 : edge.getPropertyNames()) {
                        Object v = edge.getProperty(field2);
                        if (v == null) continue;
                        json.writeAttribute(field2, v);
                    }
                    json.endObject();
                }
            }
            json.endCollection();
            if (iAdditionalProperties != null) {
                for (Map.Entry<String, Object> entry : iAdditionalProperties.entrySet()) {
                    Object v = entry.getValue();
                    if (OMultiValue.isMultiValue((Object)v)) {
                        json.beginCollection(-1, true, entry.getKey());
                        this.formatMultiValue(OMultiValue.getMultiValueIterator((Object)v), buffer, null);
                        json.endCollection(-1, true);
                    } else {
                        json.writeAttribute(entry.getKey(), v);
                    }
                    if (!Thread.currentThread().isInterrupted()) continue;
                    break;
                }
            }
            json.endObject();
            json.endObject();
            this.send(200, "OK", "application/json", buffer.toString(), null);
        }
    }
}

