/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.orientdb;

import com.orientechnologies.orient.core.db.ODatabaseType;
import com.orientechnologies.orient.core.db.OrientDB;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.OServerMain;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.orientdb.OrientFactory;
import org.apache.tinkerpop.gremlin.orientdb.OrientGraph;
import org.apache.tinkerpop.gremlin.orientdb.OrientGraphBaseFactory;
import org.apache.tinkerpop.gremlin.orientdb.OrientGraphFactory;
import org.apache.tinkerpop.gremlin.orientdb.OrientStandardGraph;

public class OrientEmbeddedFactory {
    public static OrientStandardGraph open(Configuration config) {
        if (config.containsKey(OrientGraph.CONFIG_DB_NAME)) {
            String dbType = config.getString(OrientGraph.CONFIG_DB_TYPE, ODatabaseType.PLOCAL.name()).toUpperCase();
            String dbName = config.getString(OrientGraph.CONFIG_DB_NAME);
            String user = config.getString(OrientGraph.CONFIG_USER, "admin");
            String password = config.getString(OrientGraph.CONFIG_PASS, "admin");
            boolean transactional = config.getBoolean(OrientGraph.CONFIG_TRANSACTIONAL, true);
            config.setProperty(OrientGraph.CONFIG_TRANSACTIONAL, (Object)transactional);
            OServer server = OServerMain.server();
            OrientDB context = server.getContext();
            OrientGraphFactory factory = new OrientGraphFactory(context, dbName, ODatabaseType.valueOf((String)dbType), user, password);
            return new OrientStandardGraph((OrientGraphBaseFactory)factory, config);
        }
        return OrientFactory.open((Configuration)config);
    }
}

