/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.tinkerpop.server.config;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.OrientDB;
import com.orientechnologies.orient.core.db.OrientDBInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.tinkerpop.server.OrientGremlinGraphManager;
import com.orientechnologies.tinkerpop.server.auth.OGremlinServerAuthenticator;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import javax.script.Bindings;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.orientdb.OrientGraph;
import org.apache.tinkerpop.gremlin.orientdb.OrientGraphBaseFactory;
import org.apache.tinkerpop.gremlin.orientdb.OrientStandardGraph;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.structure.Graph;

public class OGraphConfig {
    private ODocument config;

    public OGraphConfig(ODocument config) {
        this.config = config;
    }

    public static OGraphConfig read(String file) throws Exception {
        FileInputStream input = new FileInputStream(new File(file));
        return OGraphConfig.read(input);
    }

    public static OGraphConfig read(InputStream input) throws Exception {
        Objects.requireNonNull(input);
        ODocument document = new ODocument().fromJSON(input);
        return new OGraphConfig(document);
    }

    public Map<String, Map<String, String>> getGraphs() {
        return (Map)this.config.field("graphs");
    }

    public void apply(OServer server, OrientGremlinGraphManager graphManager, Settings settings, Bindings bindings) {
        boolean hasServerAuthenticator = this.hasServerAuthenticator(settings);
        final OrientDB context = server.getContext();
        this.getGraphs().entrySet().forEach(k -> {
            Map val = (Map)k.getValue();
            String graphName = (String)val.get("graph");
            String traversalName = (String)val.get("traversal");
            String username = (String)val.get("username");
            String password = (String)val.get("password");
            if (graphName != null && traversalName != null) {
                if (hasServerAuthenticator || username != null && password != null) {
                    OrientGraphBaseFactory factory = new OrientGraphBaseFactory((Map.Entry)k, username, password){
                        final /* synthetic */ Map.Entry val$k;
                        final /* synthetic */ String val$username;
                        final /* synthetic */ String val$password;
                        {
                            this.val$k = entry;
                            this.val$username = string;
                            this.val$password = string2;
                        }

                        public OrientGraph getNoTx() {
                            BaseConfiguration configuration = new BaseConfiguration();
                            configuration.addProperty(OrientGraph.CONFIG_TRANSACTIONAL, (Object)false);
                            return OGraphConfig.this.newGraph(this, context, configuration, (String)this.val$k.getKey(), this.val$username, this.val$password);
                        }

                        public OrientGraph getTx() {
                            BaseConfiguration configuration = new BaseConfiguration();
                            configuration.addProperty(OrientGraph.CONFIG_TRANSACTIONAL, (Object)true);
                            return OGraphConfig.this.newGraph(this, context, configuration, (String)this.val$k.getKey(), this.val$username, this.val$password);
                        }
                    };
                    OrientStandardGraph graph = new OrientStandardGraph(factory, (Configuration)new BaseConfiguration());
                    graphManager.putGraph(graphName, (Graph)graph);
                    bindings.put(graphName, (Object)graph);
                    GraphTraversalSource traversal = graph.traversal();
                    graphManager.putTraversalSource(traversalName, (TraversalSource)traversal);
                    bindings.put(traversalName, (Object)traversal);
                } else {
                    OLogManager.instance().warn((Object)this, "Cannot configure the graph %s since it's not protected", new Object[]{k});
                }
            } else {
                OLogManager.instance().warn((Object)this, "Cannot configure the graph %s invalid graph/traversal alias", new Object[]{k});
            }
        });
    }

    private OrientGraph newGraph(OrientGraphBaseFactory factory, OrientDB context, BaseConfiguration configuration, String dbName, String username, String password) {
        Object db = username != null && password != null ? context.open(dbName, username, password) : OrientDBInternal.extract((OrientDB)context).openNoAuthenticate(dbName, username);
        return new OrientGraph(factory, (ODatabaseDocument)db, (Configuration)configuration, username, password);
    }

    private boolean hasServerAuthenticator(Settings settings) {
        if (settings.authentication != null && settings.authentication.authenticator != null) {
            return settings.authentication.authenticator.equals(OGremlinServerAuthenticator.class.getName());
        }
        return false;
    }

    public void reload(ODocument config) {
    }

    public ODocument getConfig() {
        return this.config;
    }
}

