/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.tinkerpop.server.auth;

import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.OServerMain;
import java.util.Map;
import org.apache.tinkerpop.gremlin.server.auth.AuthenticatedUser;
import org.apache.tinkerpop.gremlin.server.auth.AuthenticationException;
import org.apache.tinkerpop.gremlin.server.auth.SimpleAuthenticator;

public class OGremlinServerAuthenticator
extends SimpleAuthenticator {
    OServer server;
    private static final String PERMISSION = "gremlin.server";

    public AuthenticatedUser authenticate(Map<String, String> credentials) throws AuthenticationException {
        String password;
        if (!credentials.containsKey("username")) {
            throw new IllegalArgumentException(String.format("Credentials must contain a %s", "username"));
        }
        if (!credentials.containsKey("password")) {
            throw new IllegalArgumentException(String.format("Credentials must contain a %s", "password"));
        }
        String username = credentials.get("username");
        if (!this.server.authenticate(username, password = credentials.get("password"), PERMISSION)) {
            throw new AuthenticationException("Username and/or password are incorrect");
        }
        return new AuthenticatedUser(username);
    }

    public void setup(Map<String, Object> config) {
        this.server = OServerMain.server();
    }
}

