/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.tinkerpop.server;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.OServerLifecycleListener;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import com.orientechnologies.orient.server.plugin.OServerPluginAbstract;
import com.orientechnologies.orient.server.plugin.OServerPluginConfigurable;
import com.orientechnologies.tinkerpop.server.OrientGremlinGraphManager;
import com.orientechnologies.tinkerpop.server.config.OGraphConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import javax.script.Bindings;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.orientdb.OrientEmbeddedFactory;
import org.apache.tinkerpop.gremlin.orientdb.OrientStandardGraph;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.server.GremlinServer;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.util.ServerGremlinExecutor;
import org.apache.tinkerpop.gremlin.structure.Graph;

public class OGremlinServerPlugin
extends OServerPluginAbstract
implements OServerPluginConfigurable,
OServerLifecycleListener {
    protected GremlinServer gremlinServer;
    protected OServer oServer;
    protected OrientGremlinGraphManager graphManager;
    protected ServerGremlinExecutor executor;
    protected OGraphConfig config;

    public String getName() {
        return "gremlin-server";
    }

    public void config(OServer oServer, OServerParameterConfiguration[] iParams) {
        this.oServer = oServer;
        this.oServer.registerLifecycleListener((OServerLifecycleListener)this);
    }

    public InputStream getServerConfig() throws FileNotFoundException {
        String configFile = OSystemVariableResolver.resolveSystemVariables((String)"${ORIENTDB_HOME}/config/gremlin-server.yaml");
        return new FileInputStream(new File(configFile));
    }

    public InputStream getGraphsConfig() throws FileNotFoundException {
        String aliasConfig = OSystemVariableResolver.resolveSystemVariables((String)"${ORIENTDB_HOME}/config/graph-config.json");
        return new FileInputStream(new File(aliasConfig));
    }

    public ODocument getConfig() {
        return this.config.getConfig();
    }

    public void changeConfig(ODocument document) {
        this.config.reload(document);
    }

    public void onBeforeActivate() {
    }

    public void onAfterActivate() {
        try {
            OLogManager.instance().info((Object)this, "Gremlin Server is starting up...", new Object[0]);
            Settings settings = Settings.read((InputStream)this.getServerConfig());
            this.gremlinServer = new GremlinServer(settings);
            CompletableFuture start = this.gremlinServer.start();
            this.executor = (ServerGremlinExecutor)start.join();
            this.graphManager = (OrientGremlinGraphManager)this.executor.getGraphManager();
            OLogManager.instance().info((Object)this, "Gremlin started correctly", new Object[0]);
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on Gremlin Server startup", (Throwable)e, new Object[0]);
        }
    }

    public void onBeforeDeactivate() {
        OLogManager.instance().info((Object)this, "Gremlin Server is shutting down.", new Object[0]);
        this.gremlinServer.stop().join();
        OLogManager.instance().info((Object)this, "Gremlin Server shutting down completed.", new Object[0]);
    }

    public void onAfterDeactivate() {
    }

    public void installCustomGraph(BaseConfiguration configuration, String graphName, String traversalName) {
        OrientStandardGraph graph = OrientEmbeddedFactory.open((Configuration)configuration);
        Bindings bindings = this.executor.getGremlinExecutor().getScriptEngineManager().getBindings();
        GraphTraversalSource traversal = graph.traversal();
        this.graphManager.putGraph(graphName, (Graph)graph);
        bindings.put(graphName, (Object)graph);
        this.graphManager.putTraversalSource(traversalName, (TraversalSource)traversal);
        bindings.put(traversalName, (Object)traversal);
    }
}

