/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.tinkerpop.handler;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.server.OClientConnection;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import com.orientechnologies.orient.server.network.OServerNetworkListener;
import com.orientechnologies.orient.server.network.protocol.http.ONetworkProtocolHttpAbstract;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommand;
import com.orientechnologies.orient.server.plugin.OServerPluginAbstract;
import com.orientechnologies.tinkerpop.command.OServerCommandPostCommandGremlin;
import org.apache.tinkerpop.gremlin.orientdb.executor.OCommandGremlinExecutor;

public class OGraphServerHandler
extends OServerPluginAbstract {
    private boolean enabled = true;
    private int graphPoolMax;
    private OServer server;

    public void config(OServer server, OServerParameterConfiguration[] iParams) {
        this.graphPoolMax = server.getContextConfiguration().getValueAsInteger(OGlobalConfiguration.DB_POOL_MAX);
        for (OServerParameterConfiguration param : iParams) {
            if (param.name.equalsIgnoreCase("enabled")) {
                if (Boolean.parseBoolean(param.value)) continue;
                return;
            }
            if (!param.name.equalsIgnoreCase("graph.pool.max")) continue;
            this.graphPoolMax = Integer.parseInt(param.value);
        }
        OCommandGremlinExecutor executor = (OCommandGremlinExecutor)OCommandManager.instance().getScriptExecutor("gremlin");
        this.enabled = true;
        OLogManager.instance().info((Object)this, "Installed GREMLIN language v.%s - graph.pool.max=%d", new Object[]{executor.getEngineVersion(), this.graphPoolMax});
        this.server = server;
    }

    public String getName() {
        return "graph";
    }

    public void startup() {
        OServerNetworkListener listener = this.server.getListenerByProtocol(ONetworkProtocolHttpAbstract.class);
        if (!this.enabled) {
            return;
        }
        if (listener != null) {
            listener.registerStatelessCommand((OServerCommand)new OServerCommandPostCommandGremlin());
        }
    }

    public void shutdown() {
        if (!this.enabled) {
            return;
        }
    }

    public void onAfterClientRequest(OClientConnection connection, byte requestType) {
        super.onAfterClientRequest(connection, requestType);
    }
}

