/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl.transformer;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.OVertexDelegate;
import com.orientechnologies.orient.etl.transformer.OETLAbstractTransformer;

public class OETLVertexTransformer
extends OETLAbstractTransformer {
    private String vertexClass;
    private String clusterName;
    private boolean skipDuplicates = false;

    @Override
    public ODocument getConfiguration() {
        return new ODocument().fromJSON("{parameters:[" + this.getCommonConfigurationParameters() + ",{class:{optional:true,description:'Vertex class name to assign. Default is V  '}},skipDuplicates:{optional:true,description:'Vertices with duplicate keys are skipped', default:false}],input:['OrientVertex','ODocument'],output:'OrientVertex'}");
    }

    @Override
    public void configure(ODocument iConfiguration, OCommandContext iContext) {
        super.configure(iConfiguration, iContext);
        this.clusterName = (String)iConfiguration.field("cluster");
        if (iConfiguration.containsField("class")) {
            this.vertexClass = (String)this.resolve(iConfiguration.field("class"));
        }
        if (iConfiguration.containsField("skipDuplicates")) {
            this.skipDuplicates = (Boolean)this.resolve(iConfiguration.field("skipDuplicates"));
        }
    }

    @Override
    public void begin(ODatabaseDocument db) {
        super.begin(db);
        if (this.vertexClass != null) {
            OClass cls = db.getClass(this.vertexClass);
            if (cls == null) {
                db.createVertexClass(this.vertexClass);
            }
        } else {
            this.vertexClass = "V";
        }
    }

    @Override
    public String getName() {
        return "vertex";
    }

    @Override
    public Object executeTransform(ODatabaseDocument db, Object input) {
        ODocument doc = (ODocument)input;
        doc.setClassName(this.vertexClass);
        OVertexDelegate v = new OVertexDelegate(doc);
        return v;
    }
}

