/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl.transformer;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.script.OCommandScript;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.etl.transformer.OETLAbstractTransformer;
import java.util.Locale;
import java.util.logging.Level;

public class OETLCommandTransformer
extends OETLAbstractTransformer {
    private String language = "sql";
    private String command;

    @Override
    public ODocument getConfiguration() {
        return new ODocument().fromJSON("{parameters:[" + this.getCommonConfigurationParameters() + ",{language:{optional:true,description:'Command language, SQL by default'}},{command:{optional:false,description:'Command to execute'}}],input:['ODocument'],output:'ODocument'}");
    }

    @Override
    public void configure(ODocument conf, OCommandContext ctx) {
        super.configure(conf, ctx);
        if (conf.containsField("language")) {
            this.language = ((String)conf.field("language")).toLowerCase(Locale.ENGLISH);
        }
        this.command = (String)conf.field("command");
    }

    @Override
    public String getName() {
        return "command";
    }

    @Override
    public Object executeTransform(ODatabaseDocument db, Object input) {
        String runtimeCommand = (String)this.resolve(this.command);
        Object cmd = this.language.equals("sql") ? new OCommandSQL(runtimeCommand) : new OCommandScript(this.language, runtimeCommand);
        cmd.setContext(this.context);
        try {
            Object result = db.command((OCommandRequest)cmd).execute(new Object[0]);
            this.log(Level.FINE, "input=%s - command=%s - result=%s", input, cmd, result);
            return result;
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "exception=%s - input=%s - command=%s ", e.getMessage(), input, cmd);
            throw e;
        }
    }
}

