/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl.loader;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabasePool;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.db.ODatabaseType;
import com.orientechnologies.orient.core.db.OrientDB;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import com.orientechnologies.orient.etl.OETLPipeline;
import com.orientechnologies.orient.etl.context.OETLContextWrapper;
import com.orientechnologies.orient.etl.loader.OETLAbstractLoader;
import com.orientechnologies.orient.etl.loader.OETLLoader;
import com.orientechnologies.orient.etl.loader.OETLLoaderException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;

public class OETLOrientDBLoader
extends OETLAbstractLoader
implements OETLLoader {
    private static String NOT_DEF = "not_defined";
    public ODatabasePool pool;
    public OrientDB orient;
    private String clusterName;
    private String className;
    private List<ODocument> classes;
    private List<ODocument> indexes;
    private OClass schemaClass;
    private String dbURL;
    private String dbUser = "admin";
    private String dbPassword = "admin";
    private String serverUser = NOT_DEF;
    private String serverPassword = NOT_DEF;
    private boolean dbAutoCreate = true;
    private boolean dbAutoDropIfExists = false;
    private boolean dbAutoCreateProperties = false;
    private boolean useLightweightEdges = false;
    private boolean standardElementConstraints = true;
    private boolean tx = false;
    private int batchCommitSize = 0;
    private AtomicLong batchCounter = new AtomicLong(0L);
    private DB_TYPE dbType = DB_TYPE.DOCUMENT;
    private boolean wal = true;
    private boolean txUseLog = false;
    private boolean skipDuplicates = false;

    @Override
    public ODatabasePool getPool() {
        return this.pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void load(ODatabaseDocument db, Object input, OCommandContext context) {
        if (input == null) {
            return;
        }
        if (this.dbAutoCreateProperties) {
            this.autoCreateProperties(db, input);
        }
        if (this.tx && !db.getTransaction().isActive()) {
            db.begin();
            db.getTransaction().setUsingLog(this.txUseLog);
        }
        if (input instanceof OVertex) {
            OVertex v = (OVertex)input;
            try {
                v.save(this.clusterName);
            }
            catch (ORecordDuplicatedException e) {
                if (!this.skipDuplicates) throw e;
            }
        } else if (input instanceof ODocument) {
            ODocument doc = (ODocument)input;
            if (this.className != null) {
                doc.setClassName(this.className);
            }
            if (this.clusterName != null) {
                db.save((Object)doc, this.clusterName);
            } else {
                db.save((Object)doc);
            }
        } else {
            OETLContextWrapper.getInstance().getMessageHandler().error((Object)this, "input type not supported::  %s", new Object[]{input.getClass()});
        }
        this.progress.incrementAndGet();
        if (this.tx && this.batchCommitSize > 0 && this.batchCounter.get() > (long)this.batchCommitSize) {
            OETLOrientDBLoader oETLOrientDBLoader = this;
            synchronized (oETLOrientDBLoader) {
                if (this.batchCommitSize <= 0) return;
                if (this.batchCounter.get() <= (long)this.batchCommitSize) return;
                this.log(Level.FINE, "committing document batch %d", this.progress.get());
                db.commit();
                db.begin();
                db.getTransaction().setUsingLog(this.txUseLog);
                this.batchCounter.set(0L);
                return;
            }
        }
        this.batchCounter.incrementAndGet();
    }

    private void autoCreateProperties(ODatabaseDocument db, Object input) {
        if (this.dbType == DB_TYPE.DOCUMENT && input instanceof ODocument) {
            this.autoCreatePropertiesOnDocument(db, (ODocument)input);
        } else if (this.dbType == DB_TYPE.GRAPH && input instanceof OVertex) {
            this.autoCreatePropertiesOnElement(db, (OVertex)input);
        }
    }

    private void autoCreatePropertiesOnElement(ODatabaseDocument db, OVertex element) {
        Optional schemaType = element.getSchemaType();
        String clsName = ((OClass)schemaType.get()).getName();
        if (clsName == null) {
            throw new IllegalArgumentException("No class defined on graph element: " + element);
        }
        OClass cls = this.getOrCreateClass(db, clsName, ((OClass)element.getSchemaType().get()).getName());
        for (String f : element.getPropertyNames()) {
            String newName = this.transformFieldName(f);
            String fName = newName != null ? newName : f;
            OProperty p = cls.getProperty(fName);
            if (p != null) continue;
            Object fValue = element.getProperty(f);
            this.createProperty(cls, fName, fValue);
            if (newName == null) continue;
            element.removeProperty(f);
            element.setProperty(newName, fValue);
        }
    }

    private void autoCreatePropertiesOnDocument(ODatabaseDocument db, ODocument doc) {
        OClass cls = this.className != null ? this.getOrCreateClass(db, this.className, null) : doc.getSchemaClass();
        for (String f : doc.fieldNames()) {
            String newName = this.transformFieldName(f);
            String fName = newName != null ? newName : f;
            OProperty p = cls.getProperty(fName);
            if (p != null) continue;
            Object fValue = doc.field(f);
            this.createProperty(cls, fName, fValue);
            if (newName == null) continue;
            doc.removeField(f);
            doc.field(newName, fValue);
        }
    }

    @Override
    public String getUnit() {
        return this.dbType == DB_TYPE.DOCUMENT ? "documents" : "vertices";
    }

    @Override
    public void rollback(ODatabaseDocument db) {
        if (this.tx && db.getTransaction().isActive()) {
            db.rollback();
        }
    }

    protected OClass getOrCreateClass(ODatabaseDocument db, String iClassName, String iSuperClass) {
        int clusterIdByName;
        OClass cls = this.dbType == DB_TYPE.DOCUMENT ? this.getOrCreateClassOnDocument(db, iClassName, iSuperClass) : this.getOrCreateClassOnGraph(db, iClassName, iSuperClass);
        db.activateOnCurrentThread();
        if (this.clusterName != null && (clusterIdByName = db.getClusterIdByName(this.clusterName)) == -1) {
            this.log(Level.FINE, "add cluster :: " + this.clusterName, new Object[0]);
            cls.addCluster(this.clusterName);
        }
        return cls;
    }

    private OClass getOrCreateClassOnGraph(ODatabaseDocument db, String iClassName, String iSuperClass) {
        OSchema schema = db.getMetadata().getSchema();
        OClass cls = schema.getClass(iClassName);
        if (cls == null) {
            if (iSuperClass != null) {
                OClass superClass = schema.getClass(iSuperClass);
                if (superClass == null) {
                    throw new OETLLoaderException("Cannot find super class '" + iSuperClass + "'");
                }
                OSchema schema1 = db.getMetadata().getSchema();
                if (schema1.getClass("V").isSuperClassOf(superClass)) {
                    cls = db.createVertexClass(iClassName).setSuperClasses(Arrays.asList(superClass));
                    this.log(Level.FINE, "- OrientDBLoader: created vertex class '%s' extends '%s'", iClassName, iSuperClass);
                } else {
                    cls = db.createEdgeClass(iClassName).setSuperClasses(Arrays.asList(superClass));
                    this.log(Level.FINE, "- OrientDBLoader: created edge class '%s' extends '%s'", iClassName, iSuperClass);
                }
            } else {
                cls = db.createVertexClass(iClassName);
                this.log(Level.FINE, "- OrientDBLoader: created vertex class '%s'", iClassName);
            }
        }
        return cls;
    }

    private OClass getOrCreateClassOnDocument(ODatabaseDocument documentDatabase, String iClassName, String iSuperClass) {
        OClass cls;
        if (documentDatabase.getMetadata().getSchema().existsClass(iClassName)) {
            cls = documentDatabase.getMetadata().getSchema().getClass(iClassName);
        } else if (iSuperClass != null) {
            OClass superClass = documentDatabase.getMetadata().getSchema().getClass(iSuperClass);
            if (superClass == null) {
                throw new OETLLoaderException("Cannot find super class '" + iSuperClass + "'");
            }
            cls = documentDatabase.getMetadata().getSchema().createClass(iClassName, superClass);
            this.log(Level.FINE, "- OrientDBLoader: created class '%s' extends '%s'", iClassName, iSuperClass);
        } else {
            cls = documentDatabase.getMetadata().getSchema().createClass(iClassName);
            this.log(Level.FINE, "- OrientDBLoader: created class '%s'", iClassName);
        }
        return cls;
    }

    private String transformFieldName(String f) {
        char first = f.charAt(0);
        if (Character.isDigit(first)) {
            return "field" + Character.toUpperCase(first) + (f.length() > 1 ? f.substring(1) : "");
        }
        return null;
    }

    protected void createProperty(OClass cls, String f, Object fValue) {
        if (fValue != null) {
            OType fType = OType.getTypeByClass(fValue.getClass());
            try {
                cls.createProperty(f, fType);
            }
            catch (OSchemaException oSchemaException) {
                // empty catch block
            }
            this.log(Level.FINE, "created property [%s.%s] of type [%s]", cls.getName(), f, fType);
        }
    }

    @Override
    public ODocument getConfiguration() {
        return new ODocument().fromJSON("{parameters:[{dbUrl:{optional:false,description:'Database URL'}},{dbUser:{optional:true,description:'Database user, default is admin'}},{dbPassword:{optional:true,description:'Database password, default is admin'}},{dbType:{optional:true,description:'Database type, default is document',values:" + this.stringArray2Json((Object[])DB_TYPE.values()) + "}},{class:{optional:true,description:'Record class name'}},{tx:{optional:true,description:'Transaction mode: true executes in transaction, false for atomic operations'}},{dbAutoCreate:{optional:true,description:'Auto create the database if not exists. Default is true'}},{dbAutoCreateProperties:{optional:true,description:'Auto create properties in schema'}},{dbAutoDropIfExists:{optional:true,description:'Auto drop the database if already exists. Default is false.'}},{batchCommit:{optional:true,description:'Auto commit every X items. This speed up creation of edges.'}},{wal:{optional:true,description:'Use the WAL (Write Ahead Log)'}},{useLightweightEdges:{optional:true,description:'Enable/Disable LightweightEdges in Graphs. Default is false'}},{standardElementConstraints:{optional:true,description:'Enable/Disable Standard Blueprints constraints on names. Default is true'}},{cluster:{optional:true,description:'Cluster name where to store the new record'}},{settings:{optional:true,description:'OrientDB settings as a map'}},{classes:{optional:true,description:'Classes used. It assure the classes exist or in case create them'}},{indexes:{optional:true,description:'Indexes used. It assure the indexes exist or in case create them'}}],input:['OrientVertex','ODocument']}");
    }

    @Override
    public void configure(ODocument conf, OCommandContext iContext) {
        super.configure(conf, iContext);
        if (conf.containsField("dbURL")) {
            this.dbURL = (String)this.resolve(conf.field("dbURL"));
        }
        if (conf.containsField("dbUser")) {
            this.dbUser = (String)this.resolve(conf.field("dbUser"));
        }
        if (conf.containsField("dbPassword")) {
            this.dbPassword = (String)this.resolve(conf.field("dbPassword"));
        }
        if (conf.containsField("serverUser")) {
            this.serverUser = (String)this.resolve(conf.field("serverUser"));
        }
        if (conf.containsField("serverPassword")) {
            this.serverPassword = (String)this.resolve(conf.field("serverPassword"));
        }
        if (conf.containsField("dbType")) {
            this.dbType = DB_TYPE.valueOf(conf.field("dbType").toString().toUpperCase(Locale.ENGLISH));
        }
        if (conf.containsField("tx")) {
            this.tx = (Boolean)conf.field("tx");
        }
        if (conf.containsField("wal")) {
            this.wal = (Boolean)conf.field("wal");
        }
        if (conf.containsField("txUseLog")) {
            this.txUseLog = (Boolean)conf.field("txUseLog");
        }
        if (conf.containsField("batchCommit")) {
            this.batchCommitSize = (Integer)conf.field("batchCommit");
        }
        if (conf.containsField("dbAutoCreate")) {
            this.dbAutoCreate = (Boolean)conf.field("dbAutoCreate");
        }
        if (conf.containsField("dbAutoDropIfExists")) {
            this.dbAutoDropIfExists = (Boolean)conf.field("dbAutoDropIfExists");
        }
        if (conf.containsField("dbAutoCreateProperties")) {
            this.dbAutoCreateProperties = (Boolean)conf.field("dbAutoCreateProperties");
        }
        if (conf.containsField("useLightweightEdges")) {
            this.useLightweightEdges = (Boolean)conf.field("useLightweightEdges");
        }
        if (conf.containsField("standardElementConstraints")) {
            this.standardElementConstraints = (Boolean)conf.field("standardElementConstraints");
        }
        if (conf.containsField("skipDuplicates")) {
            this.skipDuplicates = (Boolean)conf.field("skipDuplicates");
        }
        this.clusterName = (String)conf.field("cluster");
        this.className = (String)conf.field("class");
        this.indexes = (List)conf.field("indexes");
        this.classes = (List)conf.field("classes");
        if (conf.containsField("settings")) {
            ODocument settings = (ODocument)conf.field("settings");
            settings.setAllowChainedAccess(false);
            for (String s : settings.fieldNames()) {
                OGlobalConfiguration v = OGlobalConfiguration.findByKey((String)s);
                if (v == null) continue;
                v.setValue(settings.field(s));
            }
        }
        OGlobalConfiguration.USE_WAL.setValue((Object)this.wal);
        this.createDatabasePool();
    }

    @Override
    public void begin(ODatabaseDocument db) {
    }

    @Override
    public synchronized void beginLoader(OETLPipeline pipeline) {
        ODatabaseSession db = this.pool.acquire();
        db.activateOnCurrentThread();
        this.createSchema((ODatabaseDocument)db);
        db.close();
        pipeline.setPool(this.pool);
    }

    private void createDatabasePool() {
        if (this.pool != null) {
            return;
        }
        String kind = this.dbURL.substring(0, this.dbURL.indexOf(":"));
        String dbCtx = this.dbURL.substring(this.dbURL.indexOf(":") + 1);
        if ("memory".equalsIgnoreCase(kind)) {
            this.orient = new OrientDB("embedded:" + dbCtx, this.dbUser, this.dbPassword, null);
            if (this.orient.exists(dbCtx) && this.dbAutoDropIfExists) {
                this.orient.drop(dbCtx);
            }
            if (!this.orient.exists(dbCtx)) {
                this.orient.create(dbCtx, ODatabaseType.MEMORY);
            }
            this.pool = new ODatabasePool(this.orient, dbCtx, this.dbUser, this.dbPassword);
        } else if ("plocal".equalsIgnoreCase(kind)) {
            String dbName = dbCtx.substring(dbCtx.lastIndexOf("/"));
            dbCtx = dbCtx.substring(0, dbCtx.lastIndexOf("/"));
            this.orient = new OrientDB("embedded:" + dbCtx, this.dbUser, this.dbPassword, null);
            if (this.orient.exists(dbName) && this.dbAutoDropIfExists) {
                this.orient.drop(dbName);
            }
            if (!this.orient.exists(dbName) && this.dbAutoCreate) {
                this.orient.create(dbName, ODatabaseType.PLOCAL);
            }
            this.pool = new ODatabasePool(this.orient, dbName, this.dbUser, this.dbPassword);
        } else {
            this.orient = new OrientDB("remote:" + dbCtx, this.serverUser, this.serverPassword, null);
            String dbName = dbCtx.substring(dbCtx.lastIndexOf("/"));
            dbName = dbName.replace("/", "").trim();
            System.out.println("dbName = " + dbName);
            if (this.orient.exists(dbName) && this.dbAutoDropIfExists) {
                this.orient.drop(dbName);
            }
            if (!this.orient.exists(dbName) && this.dbAutoCreate) {
                this.orient.create(dbName, ODatabaseType.PLOCAL);
            }
            this.pool = new ODatabasePool(this.orient, dbName, this.dbUser, this.dbPassword);
        }
    }

    private void createSchema(ODatabaseDocument db) {
        if (this.classes != null) {
            for (ODocument cls : this.classes) {
                this.schemaClass = this.getOrCreateClass(db, (String)cls.field("name"), (String)cls.field("extends"));
                Integer clusters = (Integer)cls.field("clusters");
                if (clusters != null) {
                    OClassImpl.addClusters((OClass)this.schemaClass, (int)clusters);
                }
                this.log(Level.FINE, "%s: found %d %s in class '%s'", this.getName(), this.schemaClass.count(), this.getUnit(), this.className);
            }
        }
        if (this.className != null) {
            this.schemaClass = this.getOrCreateClass(db, this.className, null);
            this.log(Level.FINE, "%s: found %d %s in class '%s'", this.getName(), this.schemaClass.count(), this.getUnit(), this.className);
        }
        if (this.indexes != null) {
            for (ODocument idx : this.indexes) {
                OIndex index;
                ODocument metadata = (ODocument)this.resolve(idx.field("metadata"));
                this.log(Level.FINE, "%s: found metadata field '%s'", this.getName(), metadata);
                String idxName = (String)this.resolve(idx.field("name"));
                if (idxName != null && (index = db.getMetadata().getIndexManager().getIndex(idxName)) != null) continue;
                String idxClass = (String)this.resolve(idx.field("class"));
                if (idxClass == null) {
                    throw new OConfigurationException("Index 'class' missed in OrientDB Loader");
                }
                OClass cls = this.getOrCreateClass(db, idxClass, null);
                String idxType = (String)idx.field("type");
                if (idxType == null) {
                    throw new OConfigurationException("Index 'type' missed in OrientDB Loader for index '" + idxName + "'");
                }
                String algorithm = (String)idx.field("algorithm");
                List idxFields = (List)idx.field("fields");
                if (idxFields == null) {
                    throw new OConfigurationException("Index 'fields' missed in OrientDB Loader");
                }
                String[] fields = new String[idxFields.size()];
                for (int f = 0; f < fields.length; ++f) {
                    String fieldName = (String)idxFields.get(f);
                    String[] fieldNameParts = fieldName.split(":");
                    if (!cls.existsProperty(fieldNameParts[0])) {
                        if (fieldNameParts.length < 2) {
                            throw new OConfigurationException("Index field type missed in OrientDB Loader for field '" + fieldName + "'");
                        }
                        String fieldType = fieldNameParts[1].toUpperCase(Locale.ENGLISH);
                        OType type = OType.valueOf((String)fieldType);
                        cls.createProperty(fieldNameParts[0], type);
                        this.log(Level.FINE, "- OrientDBLoader: created property '%s.%s' of type: %s", idxClass, fieldNameParts[0], fieldNameParts[1]);
                    }
                    fields[f] = fieldNameParts[0];
                }
                if (idxName == null) {
                    idxName = idxClass + ".";
                    for (int i = 0; i < fields.length; ++i) {
                        if (i > 0) {
                            idxName = idxName + '_';
                        }
                        idxName = idxName + fields[i];
                    }
                }
                if ((index = db.getMetadata().getIndexManager().getIndex(idxName)) != null) continue;
                index = cls.createIndex(idxName, idxType, null, metadata, algorithm, fields);
                this.log(Level.FINE, "- OrientDocumentLoader: created index '%s' type '%s' against Class '%s', fields %s", idxName, idxType, idxClass, idxFields);
            }
        }
    }

    @Override
    public void end() {
    }

    @Override
    public void close() {
        this.orient.close();
    }

    @Override
    public String getName() {
        return "orientdb";
    }

    protected static enum DB_TYPE {
        DOCUMENT,
        GRAPH;

    }
}

