/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl.http;

import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.etl.http.OETLHandler;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedServerAbstract;
import java.io.IOException;

public class OServerCommandETL
extends OServerCommandAuthenticatedServerAbstract {
    OETLHandler handler = new OETLHandler();
    private static final String[] NAMES = new String[]{"GET|etl/*", "POST|etl/*"};

    public OServerCommandETL() {
        super("server.profiler");
    }

    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        String[] parts = this.checkSyntax(iRequest.getUrl(), 2, "Syntax error: auditing/<db>/<action>");
        if ("POST".equalsIgnoreCase(iRequest.httpMethod)) {
            this.doPost(iRequest, iResponse, parts);
        }
        if ("GET".equalsIgnoreCase(iRequest.httpMethod)) {
            this.doGet(iRequest, iResponse, parts);
        }
        return false;
    }

    private void doGet(OHttpRequest iRequest, OHttpResponse iResponse, String[] parts) throws IOException {
        if (!"status".equalsIgnoreCase(parts[1])) {
            throw new IllegalArgumentException("");
        }
        ODocument status = this.handler.status();
        iResponse.send(200, "OK", "application/json", (Object)status.toJSON("prettyPrint"), null);
    }

    private void doPost(OHttpRequest iRequest, OHttpResponse iResponse, String[] parts) throws IOException {
        if ("job".equalsIgnoreCase(parts[1])) {
            ODocument cfg = new ODocument().fromJSON(iRequest.content);
            this.handler.executeImport(cfg, this.server);
            iResponse.send(200, "OK", "application/json", null, null);
        } else if ("save-config".equalsIgnoreCase(parts[1])) {
            ODocument args = new ODocument().fromJSON(iRequest.content);
            try {
                this.handler.saveConfiguration(args, this.server);
            }
            catch (IOException e) {
                throw new IOException(e);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
            iResponse.send(200, "OK", "application/json", null, null);
        } else if ("list-configs".equalsIgnoreCase(parts[1])) {
            try {
                ODocument configsInfo = this.handler.listConfigurations(this.server);
                iResponse.send(200, "OK", "application/json", (Object)configsInfo.toJSON("prettyPrint"), null);
            }
            catch (IOException e) {
                throw new IOException(e);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            throw new IllegalArgumentException("");
        }
    }

    public String[] getNames() {
        return NAMES;
    }
}

