/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl.block;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.script.OCommandExecutorScript;
import com.orientechnologies.orient.core.command.script.OCommandScript;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.etl.block.OETLAbstractBlock;
import java.util.HashMap;
import java.util.Map;

public class OETLCodeBlock
extends OETLAbstractBlock {
    protected String language = "javascript";
    protected String code;
    protected OCommandExecutorScript cmd;
    protected Map<Object, Object> params = new HashMap<Object, Object>();

    @Override
    public ODocument getConfiguration() {
        return new ODocument().fromJSON("{parameters:[{language:{optional:true,description:'Code language, default is Javascript'}},{code:{optional:false,description:'Code to execute'}}],input:['Object'],output:'Object'}");
    }

    @Override
    public void configure(ODocument iConfiguration, OCommandContext iContext) {
        super.configure(iConfiguration, iContext);
        if (iConfiguration.containsField("language")) {
            this.language = (String)iConfiguration.field("language");
        }
        if (!iConfiguration.containsField("code")) {
            throw new IllegalArgumentException("'code' parameter is mandatory in Code Transformer");
        }
        this.code = (String)iConfiguration.field("code");
        this.cmd = new OCommandExecutorScript().parse((OCommandRequest)new OCommandScript(this.language, this.code));
    }

    @Override
    public String getName() {
        return "code";
    }

    @Override
    public Object executeBlock() {
        return this.cmd.executeInContext(this.context, this.params);
    }
}

