/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.thread.OThreadPoolExecutorWithLogging;
import com.orientechnologies.orient.core.OConstants;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.record.OEdge;
import com.orientechnologies.orient.core.record.OVertex;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.etl.OETLComponent;
import com.orientechnologies.orient.etl.OETLComponentFactory;
import com.orientechnologies.orient.etl.OETLExtractedItem;
import com.orientechnologies.orient.etl.OETLExtractorWorker;
import com.orientechnologies.orient.etl.OETLPipeline;
import com.orientechnologies.orient.etl.OETLPipelineWorker;
import com.orientechnologies.orient.etl.OETLProcessHaltedException;
import com.orientechnologies.orient.etl.OETLProcessorConfigurator;
import com.orientechnologies.orient.etl.block.OETLBlock;
import com.orientechnologies.orient.etl.context.OETLContextWrapper;
import com.orientechnologies.orient.etl.extractor.OETLExtractor;
import com.orientechnologies.orient.etl.loader.OETLLoader;
import com.orientechnologies.orient.etl.source.OETLSource;
import com.orientechnologies.orient.etl.transformer.OETLTransformer;
import java.util.List;
import java.util.Locale;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class OETLProcessor {
    protected final OETLComponentFactory factory;
    protected final OETLProcessorStats stats;
    private final ExecutorService executor;
    protected List<OETLBlock> endBlocks;
    protected List<OETLTransformer> transformers;
    protected List<OETLBlock> beginBlocks;
    protected OETLSource source;
    protected OETLExtractor extractor;
    protected OETLLoader loader;
    protected OCommandContext context;
    protected long startTime;
    protected long elapsed;
    protected TimerTask dumpTask;
    protected Level logLevel = Level.INFO;
    protected boolean haltOnError = true;
    protected int maxRetries = 10;
    protected int workers = 1;
    private boolean parallel = false;

    public OETLProcessor(List<OETLBlock> iBeginBlocks, OETLSource iSource, OETLExtractor iExtractor, List<OETLTransformer> iTransformers, OETLLoader iLoader, List<OETLBlock> iEndBlocks, OCommandContext iContext) {
        this.beginBlocks = iBeginBlocks;
        this.source = iSource;
        this.extractor = iExtractor;
        this.transformers = iTransformers;
        this.loader = iLoader;
        this.endBlocks = iEndBlocks;
        this.context = iContext;
        this.factory = new OETLComponentFactory();
        this.stats = new OETLProcessorStats();
        this.executor = new OThreadPoolExecutorWithLogging(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue());
        this.configRunBehaviour(this.context);
        OETLContextWrapper.newInstance().setContext(this.context);
    }

    public static void main(String[] args) {
        System.out.println("OrientDB etl v." + OConstants.getVersion() + " " + "https://www.orientdb.com");
        if (args.length == 0) {
            System.out.println("Syntax error, missing configuration file.");
            System.out.println("Use: oetl.sh <json-file>");
            System.exit(1);
        }
        OETLProcessor processor = new OETLProcessorConfigurator().parseConfigAndParameters(args);
        processor.execute();
    }

    protected void configRunBehaviour(OCommandContext context) {
        int cores;
        Object parallelSetting;
        Boolean cfgHaltOnError;
        String cfgLog = (String)context.getVariable("log");
        if (cfgLog != null) {
            this.logLevel = LOG_LEVELS.valueOf(cfgLog.toUpperCase(Locale.ENGLISH)).toJulLevel();
        }
        if ((cfgHaltOnError = (Boolean)context.getVariable("haltOnError")) != null) {
            this.haltOnError = cfgHaltOnError;
        }
        if ((parallelSetting = context.getVariable("parallel")) != null) {
            this.parallel = (Boolean)parallelSetting;
        }
        if (this.parallel && (cores = Runtime.getRuntime().availableProcessors()) >= 2) {
            this.workers = cores - 1;
        }
    }

    public OETLProcessorStats getStats() {
        return this.stats;
    }

    public OETLExtractor getExtractor() {
        return this.extractor;
    }

    public OETLSource getSource() {
        return this.source;
    }

    public OETLLoader getLoader() {
        return this.loader;
    }

    public List<OETLTransformer> getTransformers() {
        return this.transformers;
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    public OCommandContext getContext() {
        return this.context;
    }

    public void execute() {
        this.configure();
        this.begin();
        this.runExtractorAndPipeline();
        this.end();
    }

    private void configure() {
    }

    public void close() {
        this.loader.getPool().close();
        this.loader.close();
    }

    private void runExtractorAndPipeline() {
        try {
            OETLContextWrapper.getInstance().getMessageHandler().info((Object)this, "Started execution with %d worker threads", new Object[]{this.workers});
            this.extractor.extract(this.source.read());
            LinkedBlockingQueue<OETLExtractedItem> queue = new LinkedBlockingQueue<OETLExtractedItem>(this.workers * 500);
            List<CompletableFuture> futures = IntStream.range(0, this.workers).boxed().map(i -> CompletableFuture.runAsync(new OETLPipelineWorker(queue, new OETLPipeline(this, this.transformers, this.loader, this.logLevel, this.maxRetries, this.haltOnError)), this.executor)).collect(Collectors.toList());
            futures.add(CompletableFuture.runAsync(new OETLExtractorWorker(this.extractor, queue, this.haltOnError), this.executor));
            futures.forEach(cf -> {
                Void cfr_ignored_0 = (Void)cf.join();
            });
            OETLContextWrapper.getInstance().getMessageHandler().debug((Object)this, "all items extracted");
            this.executor.shutdown();
        }
        catch (OETLProcessHaltedException e) {
            OETLContextWrapper.getInstance().getMessageHandler().error((Object)this, "ETL process halted: ", new Object[]{e});
            this.executor.shutdownNow();
        }
        catch (Exception e) {
            OETLContextWrapper.getInstance().getMessageHandler().error((Object)this, "ETL process has problem: ", new Object[]{e});
            this.executor.shutdownNow();
        }
        this.executor.shutdown();
    }

    protected void begin() {
        Integer dumpEveryMs;
        OETLContextWrapper.getInstance().getMessageHandler().info((Object)this, "BEGIN ETL PROCESSOR");
        Integer cfgMaxRetries = (Integer)this.context.getVariable("maxRetries");
        if (cfgMaxRetries != null) {
            this.maxRetries = cfgMaxRetries;
        }
        if ((dumpEveryMs = (Integer)this.context.getVariable("dumpEveryMs")) != null && dumpEveryMs > 0) {
            this.dumpTask = new TimerTask(){

                @Override
                public void run() {
                    OETLProcessor.this.dumpProgress();
                }
            };
            Orient.instance().scheduleTask(this.dumpTask, (long)dumpEveryMs.intValue(), (long)dumpEveryMs.intValue());
            this.startTime = System.currentTimeMillis();
        }
        for (OETLBlock block : this.beginBlocks) {
            block.begin(null);
            block.execute();
            block.end();
        }
        if (this.source != null) {
            this.source.begin(null);
        }
        this.extractor.begin(null);
    }

    protected void end() {
        for (OETLTransformer transformer : this.transformers) {
            transformer.end();
        }
        if (this.source != null) {
            this.source.end();
        }
        this.extractor.end();
        this.loader.end();
        for (OETLBlock block : this.endBlocks) {
            block.begin(null);
            block.execute();
            block.end();
        }
        this.elapsed = System.currentTimeMillis() - this.startTime;
        if (this.dumpTask != null) {
            this.dumpTask.cancel();
        }
        OETLContextWrapper.getInstance().getMessageHandler().info((Object)this, "END ETL PROCESSOR");
        this.dumpProgress();
    }

    protected void dumpProgress() {
        String extractorTotalFormatted;
        long now = System.currentTimeMillis();
        long extractorProgress = this.extractor.getProgress();
        long extractorTotal = this.extractor.getTotal();
        long extractorItemsSec = (long)((float)(extractorProgress - this.stats.lastExtractorProgress) * 1000.0f / (float)(now - this.stats.lastLap));
        String extractorUnit = this.extractor.getUnit();
        long loaderProgress = this.loader.getProgress();
        long loaderItemsSec = (long)((float)(loaderProgress - this.stats.lastLoaderProgress) * 1000.0f / (float)(now - this.stats.lastLap));
        String loaderUnit = this.loader.getUnit();
        String string = extractorTotalFormatted = extractorTotal > -1L ? String.format("%,d", extractorTotal) : "?";
        if (extractorTotal == -1L) {
            OETLContextWrapper.getInstance().getMessageHandler().info((Object)this, "+ extracted %,d %s (%,d %s/sec) - %,d %s -> loaded %,d %s (%,d %s/sec) Total time: %s [%d warnings, %d errors]", new Object[]{extractorProgress, extractorUnit, extractorItemsSec, extractorUnit, this.extractor.getProgress(), this.extractor.getUnit(), loaderProgress, loaderUnit, loaderItemsSec, loaderUnit, OIOUtils.getTimeAsString((long)(now - this.startTime)), this.stats.warnings.get(), this.stats.errors.get()});
        } else {
            float extractorPercentage = (float)extractorProgress * 100.0f / (float)extractorTotal;
            OETLContextWrapper.getInstance().getMessageHandler().info((Object)this, "+ %3.2f%% -> extracted %,d/%,d %s (%,d %s/sec) - %,d %s -> loaded %,d %s (%,d %s/sec) Total time: %s [%d warnings, %d errors]", new Object[]{Float.valueOf(extractorPercentage), extractorProgress, extractorTotal, extractorUnit, extractorItemsSec, extractorUnit, this.extractor.getProgress(), this.extractor.getUnit(), loaderProgress, loaderUnit, loaderItemsSec, loaderUnit, OIOUtils.getTimeAsString((long)(now - this.startTime)), this.stats.warnings.get(), this.stats.errors.get()});
        }
        this.stats.lastExtractorProgress = extractorProgress;
        this.stats.lastLoaderProgress = loaderProgress;
        this.stats.lastLap = now;
    }

    protected void analyzeFlow() {
        if (this.extractor == null) {
            throw new OConfigurationException("extractor is null");
        }
        if (this.loader == null) {
            throw new OConfigurationException("loader is null");
        }
        OETLComponent lastComponent = this.extractor;
        for (OETLTransformer t : this.transformers) {
            this.checkTypeCompatibility(t, lastComponent);
            lastComponent = t;
        }
        this.checkTypeCompatibility(this.loader, lastComponent);
    }

    protected void checkTypeCompatibility(OETLComponent iCurrentComponent, OETLComponent iLastComponent) {
        List ins;
        String out;
        try {
            out = (String)iLastComponent.getConfiguration().field("output");
            if (out == null) {
                return;
            }
            ins = (List)iCurrentComponent.getConfiguration().field("input");
            if (ins == null) {
                return;
            }
            Class outClass = this.getClassByName(iLastComponent, out);
            for (String in : ins) {
                Class inClass = this.getClassByName(iCurrentComponent, in);
                if (!inClass.isAssignableFrom(outClass)) continue;
                return;
            }
        }
        catch (Exception e) {
            throw OException.wrapException((OException)new OConfigurationException("Error on checking compatibility between components '" + iLastComponent.getName() + "' and '" + iCurrentComponent.getName() + "'"), (Throwable)e);
        }
        throw new OConfigurationException("Component '" + iCurrentComponent.getName() + "' expects one of the following inputs " + ins + " but the 'output' for component '" + iLastComponent.getName() + "' is: " + out);
    }

    protected Class getClassByName(OETLComponent iComponent, String iClassName) {
        Class inClass;
        if (iClassName.equals("ODocument")) {
            inClass = ODocument.class;
        } else if (iClassName.equals("String")) {
            inClass = String.class;
        } else if (iClassName.equals("Object")) {
            inClass = Object.class;
        } else if (iClassName.equals("OrientVertex")) {
            inClass = OVertex.class;
        } else if (iClassName.equals("OrientEdge")) {
            inClass = OEdge.class;
        } else {
            try {
                inClass = Class.forName(iClassName);
            }
            catch (ClassNotFoundException e) {
                throw OException.wrapException((OException)new OConfigurationException("Class '" + iClassName + "' declared as 'input' of ETL Component '" + iComponent.getName() + "' was not found."), (Throwable)e);
            }
        }
        return inClass;
    }

    public OETLComponentFactory getFactory() {
        return this.factory;
    }

    public class OETLProcessorStats {
        public long lastExtractorProgress = 0L;
        public long lastLoaderProgress = 0L;
        public long lastLap = 0L;
        public AtomicLong warnings = new AtomicLong();
        public AtomicLong errors = new AtomicLong();

        public long incrementWarnings() {
            return this.warnings.incrementAndGet();
        }

        public long incrementErrors() {
            return this.errors.incrementAndGet();
        }
    }

    public static enum LOG_LEVELS {
        NONE(Level.OFF),
        ERROR(Level.SEVERE),
        INFO(Level.INFO),
        DEBUG(Level.FINE);

        private final Level julLevel;

        private LOG_LEVELS(Level julLevel) {
            this.julLevel = julLevel;
        }

        public Level toJulLevel() {
            return this.julLevel;
        }
    }
}

