/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl;

import com.orientechnologies.orient.etl.OETLExtractedItem;
import com.orientechnologies.orient.etl.context.OETLContextWrapper;
import com.orientechnologies.orient.etl.extractor.OETLExtractor;
import java.util.concurrent.BlockingQueue;

class OETLExtractorWorker
implements Runnable {
    private final BlockingQueue<OETLExtractedItem> queue;
    private final boolean haltOnError;
    private final OETLExtractor extractor;

    public OETLExtractorWorker(OETLExtractor extractor, BlockingQueue<OETLExtractedItem> queue, boolean haltOnError) {
        this.queue = queue;
        this.haltOnError = haltOnError;
        this.extractor = extractor;
    }

    @Override
    public void run() {
        OETLContextWrapper.getInstance().getMessageHandler().debug((Object)this, "Start extracting");
        boolean fetch = true;
        while (fetch) {
            try {
                if (this.extractor.hasNext()) {
                    OETLExtractedItem current = (OETLExtractedItem)this.extractor.next();
                    this.queue.put(current);
                    continue;
                }
                this.queue.put(new OETLExtractedItem(true));
                fetch = false;
            }
            catch (InterruptedException current) {
            }
            catch (Exception e) {
                if (!this.haltOnError) continue;
                try {
                    this.queue.put(new OETLExtractedItem(true));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                fetch = false;
                throw e;
            }
        }
    }
}

