/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.etl;

import com.orientechnologies.orient.etl.block.OETLBlock;
import com.orientechnologies.orient.etl.block.OETLCodeBlock;
import com.orientechnologies.orient.etl.block.OETLConsoleBlock;
import com.orientechnologies.orient.etl.block.OETLLetBlock;
import com.orientechnologies.orient.etl.context.OETLContextWrapper;
import com.orientechnologies.orient.etl.extractor.OETLCSVExtractor;
import com.orientechnologies.orient.etl.extractor.OETLExtractor;
import com.orientechnologies.orient.etl.extractor.OETLJDBCExtractor;
import com.orientechnologies.orient.etl.extractor.OETLJsonExtractor;
import com.orientechnologies.orient.etl.extractor.OETLRowExtractor;
import com.orientechnologies.orient.etl.extractor.OETLXmlExtractor;
import com.orientechnologies.orient.etl.loader.OETLLoader;
import com.orientechnologies.orient.etl.loader.OETLOrientDBLoader;
import com.orientechnologies.orient.etl.loader.OETLOutputLoader;
import com.orientechnologies.orient.etl.source.OETLContentSource;
import com.orientechnologies.orient.etl.source.OETLFileSource;
import com.orientechnologies.orient.etl.source.OETLHttpSource;
import com.orientechnologies.orient.etl.source.OETLInputSource;
import com.orientechnologies.orient.etl.source.OETLSource;
import com.orientechnologies.orient.etl.transformer.OETLBlockTransformer;
import com.orientechnologies.orient.etl.transformer.OETLCodeTransformer;
import com.orientechnologies.orient.etl.transformer.OETLCommandTransformer;
import com.orientechnologies.orient.etl.transformer.OETLEdgeTransformer;
import com.orientechnologies.orient.etl.transformer.OETLFieldTransformer;
import com.orientechnologies.orient.etl.transformer.OETLFlowTransformer;
import com.orientechnologies.orient.etl.transformer.OETLJSONTransformer;
import com.orientechnologies.orient.etl.transformer.OETLLinkTransformer;
import com.orientechnologies.orient.etl.transformer.OETLLogTransformer;
import com.orientechnologies.orient.etl.transformer.OETLMergeTransformer;
import com.orientechnologies.orient.etl.transformer.OETLTransformer;
import com.orientechnologies.orient.etl.transformer.OETLVertexTransformer;
import java.util.HashMap;
import java.util.Map;

public class OETLComponentFactory {
    protected final Map<String, Class<? extends OETLSource>> sources = new HashMap<String, Class<? extends OETLSource>>();
    protected final Map<String, Class<? extends OETLBlock>> blocks = new HashMap<String, Class<? extends OETLBlock>>();
    protected final Map<String, Class<? extends OETLExtractor>> extractors = new HashMap<String, Class<? extends OETLExtractor>>();
    protected final Map<String, Class<? extends OETLTransformer>> transformers = new HashMap<String, Class<? extends OETLTransformer>>();
    protected final Map<String, Class<? extends OETLLoader>> loaders = new HashMap<String, Class<? extends OETLLoader>>();

    public OETLComponentFactory() {
        this.registerSource(OETLFileSource.class);
        this.registerSource(OETLHttpSource.class);
        this.registerSource(OETLInputSource.class);
        this.registerSource(OETLContentSource.class);
        this.registerBlock(OETLCodeBlock.class);
        this.registerBlock(OETLLetBlock.class);
        this.registerBlock(OETLConsoleBlock.class);
        this.registerExtractor(OETLJDBCExtractor.class);
        this.registerExtractor(OETLRowExtractor.class);
        this.registerExtractor(OETLJsonExtractor.class);
        this.registerExtractor(OETLXmlExtractor.class);
        this.registerExtractor(OETLCSVExtractor.class);
        this.registerTransformer(OETLBlockTransformer.class);
        this.registerTransformer(OETLCodeTransformer.class);
        this.registerTransformer(OETLCommandTransformer.class);
        this.registerTransformer(OETLEdgeTransformer.class);
        this.registerTransformer(OETLFieldTransformer.class);
        this.registerTransformer(OETLJSONTransformer.class);
        this.registerTransformer(OETLLinkTransformer.class);
        this.registerTransformer(OETLLogTransformer.class);
        this.registerTransformer(OETLMergeTransformer.class);
        this.registerTransformer(OETLFlowTransformer.class);
        this.registerTransformer(OETLVertexTransformer.class);
        this.registerLoader(OETLOrientDBLoader.class);
        this.registerLoader(OETLOutputLoader.class);
    }

    public OETLComponentFactory registerSource(Class<? extends OETLSource> iComponent) {
        try {
            this.sources.put(iComponent.newInstance().getName(), iComponent);
        }
        catch (Exception e) {
            OETLContextWrapper.getInstance().getMessageHandler().error((Object)this, "Error on registering source: %s", new Object[]{iComponent.getName()});
        }
        return this;
    }

    public OETLComponentFactory registerBlock(Class<? extends OETLBlock> iComponent) {
        try {
            this.blocks.put(iComponent.newInstance().getName(), iComponent);
        }
        catch (Exception e) {
            OETLContextWrapper.getInstance().getMessageHandler().error((Object)this, "Error on registering block: %s", new Object[]{iComponent.getName()});
        }
        return this;
    }

    public OETLComponentFactory registerExtractor(Class<? extends OETLExtractor> iComponent) {
        try {
            this.extractors.put(iComponent.newInstance().getName(), iComponent);
        }
        catch (Exception e) {
            OETLContextWrapper.getInstance().getMessageHandler().error((Object)this, "Error on registering extractor: %s", new Object[]{iComponent.getName()});
        }
        return this;
    }

    public OETLComponentFactory registerTransformer(Class<? extends OETLTransformer> iComponent) {
        try {
            this.transformers.put(iComponent.newInstance().getName(), iComponent);
        }
        catch (Exception e) {
            OETLContextWrapper.getInstance().getMessageHandler().error((Object)this, "Error on registering transformer: %s", new Object[]{iComponent.getName()});
        }
        return this;
    }

    public OETLComponentFactory registerLoader(Class<? extends OETLLoader> iComponent) {
        try {
            this.loaders.put(iComponent.newInstance().getName(), iComponent);
        }
        catch (Exception e) {
            OETLContextWrapper.getInstance().getMessageHandler().error((Object)this, "Error on registering loader: %s", new Object[]{iComponent.getName()});
        }
        return this;
    }

    public OETLExtractor getExtractor(String iName) throws IllegalAccessException, InstantiationException {
        Class<? extends OETLExtractor> cls = this.extractors.get(iName);
        if (cls == null) {
            throw new IllegalArgumentException("Extractor '" + iName + "' not found");
        }
        return cls.newInstance();
    }

    public OETLTransformer getTransformer(String iName) throws IllegalAccessException, InstantiationException {
        Class<? extends OETLTransformer> cls = this.transformers.get(iName);
        if (cls == null) {
            throw new IllegalArgumentException("Transformer '" + iName + "' not found");
        }
        return cls.newInstance();
    }

    public OETLBlock getBlock(String iName) throws IllegalAccessException, InstantiationException {
        Class<? extends OETLBlock> cls = this.blocks.get(iName);
        if (cls == null) {
            throw new IllegalArgumentException("Block '" + iName + "' not found");
        }
        return cls.newInstance();
    }

    public OETLLoader getLoader(String iName) throws IllegalAccessException, InstantiationException {
        Class<? extends OETLLoader> cls = this.loaders.get(iName);
        if (cls == null) {
            throw new IllegalArgumentException("Loader '" + iName + "' not found");
        }
        return cls.newInstance();
    }

    public OETLSource getSource(String iName) throws IllegalAccessException, InstantiationException {
        Class<? extends OETLSource> cls = this.sources.get(iName);
        if (cls == null) {
            throw new IllegalArgumentException("Source '" + iName + "' not found");
        }
        return cls.newInstance();
    }
}

