/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial.shape;

import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.spatial.shape.OComplexShapeBuilder;
import com.orientechnologies.spatial.shape.OShapeType;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.spatial4j.shape.jts.JtsGeometry;

public class OMultiLineStringShapeBuilder
extends OComplexShapeBuilder<JtsGeometry> {
    @Override
    public String getName() {
        return "OMultiLineString";
    }

    @Override
    public OShapeType getType() {
        return OShapeType.MULTILINESTRING;
    }

    @Override
    public JtsGeometry fromDoc(ODocument document) {
        this.validate(document);
        List coordinates = (List)document.field("coordinates");
        LineString[] multiLine = new LineString[coordinates.size()];
        int j = 0;
        for (List coordinate : coordinates) {
            multiLine[j] = this.createLineString(coordinate);
            ++j;
        }
        return this.toShape((Geometry)GEOMETRY_FACTORY.createMultiLineString(multiLine));
    }

    @Override
    public void initClazz(ODatabaseInternal db) {
        OSchema schema = db.getMetadata().getSchema();
        OClass lineString = schema.createAbstractClass(this.getName(), this.superClass(db));
        lineString.createProperty("coordinates", OType.EMBEDDEDLIST, OType.EMBEDDEDLIST);
    }

    @Override
    public ODocument toDoc(JtsGeometry shape) {
        MultiLineString geom = (MultiLineString)shape.getGeom();
        ArrayList<List<List<Double>>> coordinates = new ArrayList<List<List<Double>>>();
        ODocument doc = new ODocument(this.getName());
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            LineString lineString = (LineString)geom.getGeometryN(i);
            coordinates.add(this.coordinatesFromLineString(lineString));
        }
        doc.field("coordinates", coordinates);
        return doc;
    }
}

