/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial.functions;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.parser.OBinaryCompareOperator;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OFromClause;
import com.orientechnologies.orient.core.sql.parser.OLeOperator;
import com.orientechnologies.orient.core.sql.parser.OLtOperator;
import com.orientechnologies.spatial.functions.OSpatialFunctionAbstractIndexable;
import com.orientechnologies.spatial.shape.OShapeFactory;
import java.util.Map;
import org.locationtech.spatial4j.distance.DistanceUtils;
import org.locationtech.spatial4j.shape.Shape;

public class OSTDistanceSphereFunction
extends OSpatialFunctionAbstractIndexable {
    public static final String NAME = "st_distance_sphere";
    OShapeFactory factory = OShapeFactory.INSTANCE;

    public OSTDistanceSphereFunction() {
        super(NAME, 2, 2);
    }

    public Object execute(Object iThis, OIdentifiable iCurrentRecord, Object iCurrentResult, Object[] iParams, OCommandContext iContext) {
        if (this.containsNull(iParams)) {
            return null;
        }
        Shape shape = this.factory.fromObject(iParams[0]);
        Shape shape1 = this.factory.fromObject(iParams[1]);
        double distance = this.factory.context().getDistCalc().distance(shape.getCenter(), shape1.getCenter());
        double docDistInKM = DistanceUtils.degrees2Dist((double)distance, (double)6378.137);
        return docDistInKM * 1000.0;
    }

    public String getSyntax() {
        return null;
    }

    @Override
    protected String operator() {
        return "distance_sphere";
    }

    public Iterable<OIdentifiable> searchFromTarget(OFromClause target, OBinaryCompareOperator operator, Object rightValue, OCommandContext ctx, OExpression ... args) {
        return this.results(target, args, ctx, rightValue);
    }

    @Override
    public long estimate(OFromClause target, OBinaryCompareOperator operator, Object rightValue, OCommandContext ctx, OExpression ... args) {
        if (rightValue == null || !this.isValidBinaryOperator(operator)) {
            return -1L;
        }
        return super.estimate(target, operator, rightValue, ctx, args);
    }

    private boolean isValidBinaryOperator(OBinaryCompareOperator operator) {
        return operator instanceof OLtOperator || operator instanceof OLeOperator;
    }

    @Override
    protected void onAfterParsing(Map<String, Object> params, OExpression[] args, OCommandContext ctx, Object rightValue) {
        Number parsedNumber = (Number)rightValue;
        params.put("distance", parsedNumber.doubleValue());
    }
}

