/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.sql;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.compression.impl.OZIPCompressionUtil;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.parser.OHaSyncClusterStatement;
import com.orientechnologies.orient.core.sql.parser.OStatementCache;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OPaginatedCluster;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.impl.ODistributedAbstractPlugin;
import com.orientechnologies.orient.server.distributed.impl.ODistributedDatabaseChunk;
import com.orientechnologies.orient.server.distributed.impl.task.OCopyDatabaseChunkTask;
import com.orientechnologies.orient.server.distributed.impl.task.OSyncClusterTask;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import com.orientechnologies.orient.server.hazelcast.OHazelcastPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

public class OCommandExecutorSQLHASyncCluster
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest {
    public static final String NAME = "HA SYNC CLUSTER";
    private OHaSyncClusterStatement parsedStatement;

    public OCommandExecutorSQLHASyncCluster parse(OCommandRequest iRequest) {
        this.init((OCommandRequestText)iRequest);
        try {
            this.parsedStatement = (OHaSyncClusterStatement)OStatementCache.get((String)this.parserText, (ODatabaseDocumentInternal)OCommandExecutorSQLHASyncCluster.getDatabase());
            this.preParsedStatement = this.parsedStatement;
        }
        catch (OCommandSQLParsingException sqlx) {
            throw sqlx;
        }
        catch (Exception e) {
            this.throwParsingException("Error parsing query: \n" + this.parserText + "\n" + e.getMessage(), e);
        }
        return this;
    }

    public Object execute(Map<Object, Object> iArgs) {
        ODatabaseDocumentInternal database = OCommandExecutorSQLHASyncCluster.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.CLUSTER, "sync", ORole.PERMISSION_UPDATE);
        String dbUrl = database.getURL();
        String path = dbUrl.substring(dbUrl.indexOf(":") + 1);
        OServer serverInstance = OServer.getInstanceByPath((String)path);
        OHazelcastPlugin dManager = (OHazelcastPlugin)serverInstance.getDistributedManager();
        if (dManager == null || !dManager.isEnabled()) {
            throw new OCommandExecutionException("OrientDB is not started in distributed mode");
        }
        String databaseName = database.getName();
        try {
            if (this.parsedStatement.modeFull) {
                return OCommandExecutorSQLHASyncCluster.replaceCluster(dManager, database, serverInstance, databaseName, this.parsedStatement.clusterName.getStringValue());
            }
        }
        catch (Exception e) {
            throw OException.wrapException((OException)new OCommandExecutionException("Cannot execute synchronization of cluster"), (Throwable)e);
        }
        return "Mode not supported";
    }

    public static Object replaceCluster(OHazelcastPlugin dManager, ODatabaseDocumentInternal database, OServer serverInstance, String databaseName, String clusterName) throws IOException {
        return OCommandExecutorSQLHASyncCluster.replaceCluster(dManager, serverInstance, databaseName, clusterName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object replaceCluster(ODistributedAbstractPlugin dManager, OServer serverInstance, String databaseName, String clusterName) {
        ODistributedConfiguration cfg = dManager.getDatabaseConfiguration(databaseName);
        String dbPath = serverInstance.getDatabaseDirectory() + databaseName;
        String nodeName = dManager.getLocalNodeName();
        List nodesWhereClusterIsCfg = cfg.getServers(clusterName, null);
        nodesWhereClusterIsCfg.remove(nodeName);
        if (nodesWhereClusterIsCfg.isEmpty()) {
            throw new OCommandExecutionException("Cannot synchronize cluster '" + clusterName + "' because is not configured on any running nodes");
        }
        OSyncClusterTask task = new OSyncClusterTask(clusterName);
        ODistributedResponse response = dManager.sendRequest(databaseName, null, nodesWhereClusterIsCfg, (ORemoteTask)task, dManager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null, null);
        Map results = (Map)response.getPayload();
        File tempFile = null;
        OutputStream out = null;
        try {
            boolean openDatabaseHere;
            tempFile = new File(Orient.getTempPath() + "/backup_" + databaseName + "_" + clusterName + "_toInstall.zip");
            if (tempFile.exists()) {
                tempFile.delete();
            } else {
                tempFile.getParentFile().mkdirs();
            }
            tempFile.createNewFile();
            long fileSize = 0L;
            out = new FileOutputStream(tempFile, false);
            for (Map.Entry r : results.entrySet()) {
                Object value = r.getValue();
                if (value instanceof Boolean) continue;
                if (value instanceof Throwable) {
                    ODistributedServerLog.error(null, (String)nodeName, (String)((String)r.getKey()), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"error on installing cluster %s in %s", (Throwable)((Exception)value), (Object[])new Object[]{databaseName, dbPath});
                    continue;
                }
                if (!(value instanceof ODistributedDatabaseChunk)) continue;
                ODistributedDatabaseChunk chunk = (ODistributedDatabaseChunk)value;
                File completedFile = new File(tempFile.getAbsolutePath() + ".completed");
                if (completedFile.exists()) {
                    completedFile.delete();
                }
                fileSize = OCommandExecutorSQLHASyncCluster.writeDatabaseChunk(nodeName, 1, chunk, (FileOutputStream)out);
                int chunkNum = 2;
                while (!chunk.last) {
                    ODistributedResponse result = dManager.sendRequest(databaseName, null, OMultiValue.getSingletonList(r.getKey()), (ORemoteTask)new OCopyDatabaseChunkTask(chunk.filePath, chunkNum, chunk.offset + (long)chunk.buffer.length, false), dManager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null, null);
                    if (!(result instanceof Boolean)) {
                        if (result instanceof Exception) {
                            ODistributedServerLog.error(null, (String)nodeName, (String)((String)r.getKey()), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"error on installing database %s in %s (chunk #%d)", (Throwable)((Exception)result), (Object[])new Object[]{databaseName, dbPath, chunkNum});
                        } else if (result instanceof ODistributedDatabaseChunk) {
                            chunk = (ODistributedDatabaseChunk)result;
                            fileSize += OCommandExecutorSQLHASyncCluster.writeDatabaseChunk(nodeName, chunkNum, chunk, (FileOutputStream)out);
                        }
                    }
                    ++chunkNum;
                }
                out.flush();
                new File(tempFile.getAbsolutePath() + ".completed").createNewFile();
            }
            String tempDirectoryPath = Orient.getTempPath() + "/backup_" + databaseName + "_" + clusterName + "_toInstall";
            File tempDirectory = new File(tempDirectoryPath);
            tempDirectory.mkdirs();
            OZIPCompressionUtil.uncompressDirectory((InputStream)new FileInputStream(tempFile), (String)tempDirectory.getAbsolutePath(), null);
            ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().getIfDefined();
            boolean bl = openDatabaseHere = db == null;
            if (db == null) {
                db = serverInstance.openDatabase("plocal:" + dbPath, "", "", null, true);
            }
            try {
                OAbstractPaginatedStorage stg = (OAbstractPaginatedStorage)db.getStorage().getUnderlying();
                stg.freeze(false);
                try {
                    OPaginatedCluster cluster = (OPaginatedCluster)stg.getClusterByName(clusterName);
                    File tempClusterFile = new File(tempDirectoryPath + "/" + clusterName + ".pcl");
                    cluster.replaceFile(tempClusterFile);
                    File tempCmpFile = new File(tempDirectoryPath + "/" + clusterName + ".cpm");
                    cluster.replaceClusterMapFile(tempCmpFile);
                }
                finally {
                    stg.release();
                }
                db.getLocalCache().invalidate();
                int clusterId = db.getClusterIdByName(clusterName);
                OClass klass = db.getMetadata().getSchema().getClassByClusterId(clusterId);
                for (OIndex index : klass.getIndexes()) {
                    index.rebuild();
                }
            }
            finally {
                if (openDatabaseHere) {
                    db.close();
                }
            }
            String string = String.format("Cluster correctly replaced, transferred %d bytes", fileSize);
            return string;
        }
        catch (Exception e) {
            ODistributedServerLog.error(null, (String)nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"error on transferring database '%s' to '%s'", (Throwable)e, (Object[])new Object[]{databaseName, tempFile});
            throw OException.wrapException((OException)new ODistributedException("Error on transferring database"), (Throwable)e);
        }
        finally {
            try {
                if (out != null) {
                    out.flush();
                    ((FileOutputStream)out).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE.LOCAL;
    }

    public long getDistributedTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_DEPLOYDB_TASK_SYNCH_TIMEOUT.getValueAsLong();
    }

    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.ALL;
    }

    public String getSyntax() {
        return "HA SYNC CLUSTER <cluster-name> [-full_replace|-merge]";
    }

    protected static long writeDatabaseChunk(String iNodeName, int iChunkId, ODistributedDatabaseChunk chunk, FileOutputStream out) throws IOException {
        ODistributedServerLog.warn(null, (String)iNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"- writing chunk #%d offset=%d size=%s", (Object[])new Object[]{iChunkId, chunk.offset, OFileUtils.getSizeAsString((long)chunk.buffer.length)});
        out.write(chunk.buffer);
        return chunk.buffer.length;
    }
}

