/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ODistributedTxContext;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.impl.ODistributedTxContextImpl;
import com.orientechnologies.orient.server.distributed.task.OAbstractReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OCompleted2pcTask
extends OAbstractReplicatedTask {
    public static final int FACTORYID = 8;
    protected ODistributedRequestId requestId;
    protected boolean success;
    protected List<ORemoteTask> fixTasks = new ArrayList<ORemoteTask>();

    public OCompleted2pcTask init(ODistributedRequestId iRequestId, boolean iSuccess, int[] partitionKey) {
        this.requestId = iRequestId;
        this.success = iSuccess;
        return this;
    }

    public int[] getPartitionKey() {
        return this.success || this.fixTasks.isEmpty() ? FAST_NOLOCK : ALL;
    }

    public void addFixTask(ORemoteTask fixTask) {
        this.fixTasks.add(fixTask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object execute(ODistributedRequestId msgId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        ODistributedServerLog.debug((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"%s transaction db=%s originalReqId=%s...", (Object[])new Object[]{this.success ? "Committing" : (this.fixTasks.isEmpty() ? "Rolling back" : "Fixing"), database.getName(), this.requestId, this.requestId});
        ODatabaseRecordThreadLocal.instance().set(database);
        ODistributedDatabase ddb = iManager.getMessageService().getDatabase(database.getName());
        if (ddb == null) {
            throw new ODatabaseException("Database '" + database.getName() + " is not available on server '" + iManager.getLocalNodeName() + "'");
        }
        ODistributedTxContext ctx = ddb.popTxContext(this.requestId);
        try {
            if (this.success) {
                if (ctx != null) {
                    ctx.commit(database);
                    return Boolean.TRUE;
                }
                ODistributedServerLog.debug((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Error on committing distributed transaction %s db=%s because the context was not found", (Object[])new Object[]{this.requestId, database.getName()});
                Boolean bl = Boolean.FALSE;
                return bl;
            }
            if (this.fixTasks.isEmpty()) {
                if (ctx != null) {
                    ctx.rollback(database);
                    return Boolean.TRUE;
                }
                ODistributedServerLog.debug((Object)((Object)this), (String)iManager.getLocalNodeName(), (String)this.getNodeSource(), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"Error on rolling back distributed transaction %s db=%s because the context was not found", (Object[])new Object[]{this.requestId, database.getName()});
                Boolean bl = Boolean.FALSE;
                return bl;
            }
            if (ctx != null) {
                ctx.fix(database, this.fixTasks);
                return Boolean.TRUE;
            }
            ODistributedTxContextImpl.executeFix((Object)this, null, database, this.fixTasks, this.requestId, ddb);
            return Boolean.TRUE;
        }
        finally {
            if (ctx != null) {
                ctx.destroy();
            }
        }
    }

    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.NONE;
    }

    public void toStream(DataOutput out) throws IOException {
        this.requestId.toStream(out);
        out.writeBoolean(this.success);
        out.writeInt(this.fixTasks.size());
        for (ORemoteTask task : this.fixTasks) {
            out.writeByte(task.getFactoryId());
            task.toStream(out);
        }
    }

    public void fromStream(DataInput in, ORemoteTaskFactory taskFactory) throws IOException {
        this.requestId = new ODistributedRequestId();
        this.requestId.fromStream(in);
        this.success = in.readBoolean();
        int tasksSize = in.readInt();
        for (int i = 0; i < tasksSize; ++i) {
            ORemoteTask task = taskFactory.createTask((int)in.readByte());
            task.fromStream(in, taskFactory);
            this.fixTasks.add(task);
        }
    }

    public long getDistributedTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_CRUD_TASK_SYNCH_TIMEOUT.getValueAsLong();
    }

    public String getName() {
        return "tx-completed";
    }

    public int getFactoryId() {
        return 8;
    }

    public String toString() {
        return this.getName() + " origReqId: " + this.requestId + " type: " + (this.success ? "commit" : (this.fixTasks.isEmpty() ? "rollback" : "fix (" + this.fixTasks.size() + " ops) " + this.fixTasks));
    }

    public List<ORemoteTask> getFixTasks() {
        return this.fixTasks;
    }

    public boolean getSuccess() {
        return this.success;
    }

    public ODistributedRequestId getRequestId() {
        return this.requestId;
    }

    public boolean isIdempotent() {
        return false;
    }
}

