/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.db.DistributedQueryContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.OSharedContextEmbedded;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class OCloseQueryTask
extends OAbstractRemoteTask {
    public static final int FACTORYID = 42;
    private String queryId;

    public OCloseQueryTask(String queryId) {
        this.queryId = queryId;
    }

    public OCloseQueryTask() {
    }

    public String getName() {
        return "OCloseQueryTask";
    }

    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.NONE;
    }

    public Object execute(ODistributedRequestId requestId, OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentInternal database) throws Exception {
        DistributedQueryContext ctx = (DistributedQueryContext)((OSharedContextEmbedded)database.getSharedContext()).getActiveDistributedQueries().get(this.queryId);
        if (ctx == null) {
            throw new ODistributedException("Invalid query ID: " + this.queryId);
        }
        ctx.close();
        return "OK";
    }

    public void toStream(DataOutput out) throws IOException {
        char[] chars = this.queryId.toCharArray();
        int length = chars.length;
        out.write(length);
        for (char aChar : chars) {
            out.writeChar(aChar);
        }
    }

    public void fromStream(DataInput in, ORemoteTaskFactory factory) throws IOException {
        int length = in.readInt();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            builder.append(in.readChar());
        }
        this.queryId = builder.toString();
    }

    public int getFactoryId() {
        return 42;
    }
}

