/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl.task;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ORemoteTaskFactory;
import com.orientechnologies.orient.server.distributed.impl.task.OCompleted2pcTask;
import com.orientechnologies.orient.server.distributed.impl.task.OTxTaskResult;
import com.orientechnologies.orient.server.distributed.task.OAbstractRecordReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import com.orientechnologies.orient.server.distributed.task.OAbstractReplicatedTask;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class OAbstract2pcTask
extends OAbstractReplicatedTask {
    protected static final long serialVersionUID = 1L;
    public static final String NON_LOCAL_CLUSTER = "_non_local_cluster";
    protected List<OAbstractRecordReplicatedTask> tasks = new ArrayList<OAbstractRecordReplicatedTask>();
    protected transient List<OAbstractRemoteTask> localUndoTasks = new ArrayList<OAbstractRemoteTask>();
    protected transient OTxTaskResult result;

    public void add(OAbstractRecordReplicatedTask iTask) {
        this.tasks.add(iTask);
    }

    public boolean isIdempotent() {
        for (OAbstractRecordReplicatedTask t : this.tasks) {
            if (t == null || t.isIdempotent()) continue;
            return false;
        }
        return true;
    }

    public int[] getPartitionKey() {
        if (this.tasks.size() == 1) {
            return this.tasks.get(0).getPartitionKey();
        }
        int[] partitions = new int[this.tasks.size()];
        for (int i = 0; i < this.tasks.size(); ++i) {
            OAbstractRecordReplicatedTask task = this.tasks.get(i);
            partitions[i] = task.getPartitionKey()[0];
        }
        return partitions;
    }

    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.WRITE;
    }

    public ORemoteTask getFixTask(ODistributedRequest iRequest, ORemoteTask iOriginalTask, Object iBadResponse, Object iGoodResponse, String executorNodeName, ODistributedServerManager dManager) {
        if (!(iGoodResponse instanceof OTxTaskResult)) {
            ODistributedServerLog.debug((Object)((Object)this), (String)this.getNodeSource(), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on creating fix-task for request: '%s' because good response is not expected type: %s", (Object[])new Object[]{iRequest, iBadResponse});
            return null;
        }
        OCompleted2pcTask fixTask = (OCompleted2pcTask)dManager.getTaskFactoryManager().getFactoryByServerName(executorNodeName).createTask(8);
        fixTask.init(iRequest.getId(), false, this.getPartitionKey());
        for (int i = 0; i < this.tasks.size(); ++i) {
            Object goodResult;
            Object badResult;
            OAbstractRecordReplicatedTask t = this.tasks.get(i);
            ORemoteTask undoTask = t.getFixTask(iRequest, (ORemoteTask)t, badResult = iBadResponse == null ? null : (iBadResponse instanceof Throwable ? iBadResponse : ((OTxTaskResult)iBadResponse).results.get(i)), goodResult = ((OTxTaskResult)iGoodResponse).results.get(i), executorNodeName, dManager);
            if (undoTask == null) {
                return null;
            }
            fixTask.addFixTask(undoTask);
        }
        return fixTask;
    }

    public ORemoteTask getUndoTask(ODistributedServerManager dManager, ODistributedRequestId reqId, List<String> servers) {
        OCompleted2pcTask fixTask = (OCompleted2pcTask)dManager.getTaskFactoryManager().getFactoryByServerNames(servers).createTask(8);
        fixTask.init(reqId, false, this.getPartitionKey());
        for (ORemoteTask oRemoteTask : this.localUndoTasks) {
            fixTask.addFixTask(oRemoteTask);
        }
        return fixTask;
    }

    public void toStream(DataOutput out) throws IOException {
        out.writeInt(this.tasks.size());
        for (OAbstractRecordReplicatedTask task : this.tasks) {
            out.writeByte(task.getFactoryId());
            task.toStream(out);
        }
        if (this.lastLSN != null) {
            out.writeBoolean(true);
            this.lastLSN.toStream(out);
        } else {
            out.writeBoolean(false);
        }
    }

    public void fromStream(DataInput in, ORemoteTaskFactory factory) throws IOException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            ORemoteTask task = factory.createTask((int)in.readByte());
            task.fromStream(in, factory);
            this.tasks.add((OAbstractRecordReplicatedTask)task);
        }
        boolean hasLastLSN = in.readBoolean();
        if (hasLastLSN) {
            this.lastLSN = new OLogSequenceNumber(in);
        }
    }

    public long getDistributedTimeout() {
        long to = OGlobalConfiguration.DISTRIBUTED_CRUD_TASK_SYNCH_TIMEOUT.getValueAsLong();
        return to + to / 2L * (long)this.tasks.size();
    }

    public List<OAbstractRecordReplicatedTask> getTasks() {
        return this.tasks;
    }

    public void setNodeSource(String nodeSource) {
        super.setNodeSource(nodeSource);
        for (OAbstractRecordReplicatedTask t : this.tasks) {
            t.setNodeSource(nodeSource);
        }
    }

    public void setLocalUndoTasks(List<OAbstractRemoteTask> undoTasks) {
        this.localUndoTasks = undoTasks;
    }

    public void setLastLSN(OLogSequenceNumber lastLSN) {
        this.lastLSN = lastLSN;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("tx[");
        buffer.append(this.tasks.size());
        buffer.append("]{");
        for (int i = 0; i < this.tasks.size(); ++i) {
            OAbstractRecordReplicatedTask task = this.tasks.get(i);
            if (i > 0) {
                buffer.append(',');
            }
            buffer.append(task);
        }
        buffer.append("}");
        return buffer.toString();
    }
}

