/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionInternal;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.impl.ODatabaseDocumentDistributed;
import com.orientechnologies.orient.server.distributed.impl.ODistributedAbstractPlugin;
import com.orientechnologies.orient.server.distributed.impl.ODistributedStorage;
import com.orientechnologies.orient.server.distributed.impl.ODistributedStorageEventListener;
import com.orientechnologies.orient.server.distributed.impl.ONewDistributedResponseManager;
import com.orientechnologies.orient.server.distributed.impl.task.OTransactionPhase1Task;
import com.orientechnologies.orient.server.distributed.impl.task.OTransactionPhase2Task;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTransactionResultPayload;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxConcurrentModification;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxException;
import com.orientechnologies.orient.server.distributed.impl.task.transaction.OTxUniqueIndex;
import com.orientechnologies.orient.server.distributed.task.ODistributedOperationException;
import com.orientechnologies.orient.server.distributed.task.ODistributedRecordLockedException;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ONewDistributedTransactionManager {
    private final ODistributedServerManager dManager;
    private final ODistributedStorage storage;
    private final ODistributedDatabase localDistributedDatabase;
    private static final boolean SYNC_TX_COMPLETED = false;
    private ONewDistributedResponseManager responseManager;

    public ONewDistributedTransactionManager(ODistributedStorage storage, ODistributedServerManager manager, ODistributedDatabase iDDatabase) {
        this.dManager = manager;
        this.storage = storage;
        this.localDistributedDatabase = iDDatabase;
    }

    public List<ORecordOperation> commit(ODatabaseDocumentDistributed database, OTransactionInternal iTx, ODistributedStorageEventListener eventListener) {
        String localNodeName = this.dManager.getLocalNodeName();
        iTx.setStatus(OTransaction.TXSTATUS.BEGUN);
        ODistributedConfiguration dbCfg = this.dManager.getDatabaseConfiguration(this.storage.getName());
        this.checkForClusterIds(iTx);
        ODistributedRequestId requestId = new ODistributedRequestId(this.dManager.getLocalNodeId(), this.dManager.getNextMessageIdCounter());
        Set<String> involvedClusters = this.getInvolvedClusters(iTx.getRecordOperations());
        Set<String> nodes = this.getAvailableNodesButLocal(dbCfg, involvedClusters, localNodeName);
        OTransactionPhase1Task txTask = !nodes.isEmpty() ? this.createTxTask(iTx, nodes) : null;
        OTransactionResultPayload localResult = OTransactionPhase1Task.executeTransaction(requestId, database, iTx, true, -1);
        try {
            this.localDistributedDatabase.getSyncConfiguration().setLastLSN(localNodeName, ((OLocalPaginatedStorage)this.storage.getUnderlying()).getLSN(), true);
        }
        catch (IOException e) {
            ODistributedServerLog.debug((Object)this, (String)(this.dManager != null ? this.dManager.getLocalNodeName() : "?"), null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"Error on updating local LSN configuration for database '%s'", (Object[])new Object[]{this.storage.getName()});
        }
        if (nodes.isEmpty()) {
            this.localOk(requestId, database);
            return null;
        }
        txTask.setLastLSN(this.getLsn());
        iTx.setStatus(OTransaction.TXSTATUS.COMMITTING);
        ((ODistributedAbstractPlugin)this.dManager).sendRequest(this.storage.getName(), involvedClusters, nodes, (ORemoteTask)txTask, requestId.getMessageId(), ODistributedRequest.EXECUTION_MODE.RESPONSE, localResult, null, null, (iRequest, iNodes, endCallback, task, nodesConcurToTheQuorum, availableNodes, expectedResponses, quorum, groupByResponse, waitLocalNode) -> {
            this.responseManager = new ONewDistributedResponseManager(txTask, iNodes, nodesConcurToTheQuorum, availableNodes, expectedResponses, quorum);
            return this.responseManager;
        });
        this.handleResponse(requestId, this.responseManager, involvedClusters, nodes, database);
        return null;
    }

    public OLogSequenceNumber getLsn() {
        return ((OAbstractPaginatedStorage)this.storage.getUnderlying()).getLSN();
    }

    private void handleResponse(ODistributedRequestId requestId, ONewDistributedResponseManager responseManager, Set<String> involvedClusters, Set<String> nodes, ODatabaseDocumentDistributed database) {
        List results;
        int[] involvedClustersIds = new int[involvedClusters.size()];
        int i = 0;
        for (String involvedCluster : involvedClusters) {
            involvedClustersIds[i++] = database.getClusterIdByName(involvedCluster);
        }
        if (responseManager.isQuorumReached()) {
            results = (List)responseManager.getGenericFinalResponse();
            assert (results.size() > 0);
            OTransactionResultPayload resultPayload = (OTransactionResultPayload)results.get(0);
            switch (resultPayload.getResponseType()) {
                case 1: {
                    this.localOk(requestId, database);
                    this.sendPhase2Task(involvedClusters, nodes, new OTransactionPhase2Task(requestId, true, involvedClustersIds, this.getLsn()));
                    break;
                }
                case 5: {
                    this.localKo(requestId, database);
                    this.sendPhase2Task(involvedClusters, nodes, new OTransactionPhase2Task(requestId, false, involvedClustersIds, this.getLsn()));
                    throw ((OTxException)resultPayload).getException();
                }
                case 3: {
                    this.localKo(requestId, database);
                    this.sendPhase2Task(involvedClusters, nodes, new OTransactionPhase2Task(requestId, false, involvedClustersIds, this.getLsn()));
                    ORecordId id = ((OTxUniqueIndex)resultPayload).getRecordId();
                    String index = ((OTxUniqueIndex)resultPayload).getIndex();
                    Object key = ((OTxUniqueIndex)resultPayload).getKey();
                    throw new ORecordDuplicatedException(String.format("Cannot index record %s: found duplicated key '%s' in index '%s' ", id, key, index), index, (ORID)id, key);
                }
                case 4: {
                    this.localKo(requestId, database);
                    this.sendPhase2Task(involvedClusters, nodes, new OTransactionPhase2Task(requestId, false, involvedClustersIds, this.getLsn()));
                    ORecordId id = ((OTxConcurrentModification)resultPayload).getRecordId();
                    int version = ((OTxConcurrentModification)resultPayload).getVersion();
                    throw new OConcurrentModificationException((ORID)id, version, 0, 0);
                }
                case 2: {
                    this.sendPhase2Task(involvedClusters, nodes, new OTransactionPhase2Task(requestId, false, involvedClustersIds, this.getLsn()));
                    throw new ODistributedRecordLockedException("DeadLock", (ORID)new ORecordId(-1, -1L), requestId, 0L);
                }
            }
        } else {
            results = responseManager.getAllResponses();
            for (OTransactionResultPayload result : results) {
                switch (result.getResponseType()) {
                    case 2: {
                        this.sendPhase2Task(involvedClusters, nodes, new OTransactionPhase2Task(requestId, false, involvedClustersIds, this.getLsn()));
                        throw new ODistributedRecordLockedException("DeadLock", (ORID)new ORecordId(-1, -1L), requestId, 0L);
                    }
                }
            }
            this.localKo(requestId, database);
            this.sendPhase2Task(involvedClusters, nodes, new OTransactionPhase2Task(requestId, false, involvedClustersIds, this.getLsn()));
            throw new ODistributedOperationException("quorum not reached");
        }
    }

    private void localKo(ODistributedRequestId requestId, ODatabaseDocumentDistributed database) {
        database.rollback2pc(requestId);
    }

    private void localOk(ODistributedRequestId requestId, ODatabaseDocumentDistributed database) {
        database.commit2pcLocal(requestId);
    }

    private void sendPhase2Task(Set<String> involvedClusters, Set<String> nodes, OTransactionPhase2Task task) {
        this.dManager.sendRequest(this.storage.getName(), involvedClusters, nodes, (ORemoteTask)task, this.dManager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, (Object)"OK", null, null);
    }

    protected void checkForClusterIds(OTransactionInternal iTx) {
        for (ORecordOperation op : iTx.getRecordOperations()) {
            ORecordId rid = (ORecordId)op.getRecord().getIdentity();
            switch (op.type) {
                case 3: {
                    assert (rid.isPersistent());
                    break;
                }
            }
        }
    }

    protected Set<String> getAvailableNodesButLocal(ODistributedConfiguration dbCfg, Set<String> involvedClusters, String localNodeName) {
        Set nodes = dbCfg.getServers(involvedClusters);
        nodes.remove(localNodeName);
        return nodes;
    }

    protected Set<String> getInvolvedClusters(Iterable<ORecordOperation> uResult) {
        HashSet<String> involvedClusters = new HashSet<String>();
        for (ORecordOperation op : uResult) {
            ORecord record = op.getRecord();
            involvedClusters.add(this.storage.getClusterNameByRID((ORecordId)record.getIdentity()));
        }
        return involvedClusters;
    }

    protected OTransactionPhase1Task createTxTask(OTransactionInternal transaction, Set<String> nodes) {
        OTransactionPhase1Task txTask = (OTransactionPhase1Task)this.dManager.getTaskFactoryManager().getFactoryByServerNames(nodes).createTask(43);
        txTask.init(transaction);
        return txTask;
    }
}

