/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.impl;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.concur.OOfflineNodeException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.compression.impl.OZIPCompressionUtil;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OScenarioThreadLocal;
import com.orientechnologies.orient.core.db.OSharedContext;
import com.orientechnologies.orient.core.db.OrientDBConfig;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentEmbedded;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.OConcurrentCreateException;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.exception.OValidationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.OMetadataDefault;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.query.live.OLiveQueryHook;
import com.orientechnologies.orient.core.query.live.OLiveQueryHookV2;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OExecutionPlan;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.storage.ORecordDuplicatedException;
import com.orientechnologies.orient.core.storage.ORecordMetadata;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OPaginatedCluster;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;
import com.orientechnologies.orient.core.tx.OTransactionInternal;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedDatabase;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.ODistributedRequest;
import com.orientechnologies.orient.server.distributed.ODistributedRequestId;
import com.orientechnologies.orient.server.distributed.ODistributedResponse;
import com.orientechnologies.orient.server.distributed.ODistributedServerLog;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.ODistributedTxContext;
import com.orientechnologies.orient.server.distributed.impl.ODistributedDatabaseChunk;
import com.orientechnologies.orient.server.distributed.impl.ODistributedDatabaseImpl;
import com.orientechnologies.orient.server.distributed.impl.ODistributedOutput;
import com.orientechnologies.orient.server.distributed.impl.ODistributedStorage;
import com.orientechnologies.orient.server.distributed.impl.ONewDistributedTransactionManager;
import com.orientechnologies.orient.server.distributed.impl.ONewDistributedTxContextImpl;
import com.orientechnologies.orient.server.distributed.impl.metadata.OSharedContextDistributed;
import com.orientechnologies.orient.server.distributed.impl.task.OCopyDatabaseChunkTask;
import com.orientechnologies.orient.server.distributed.impl.task.ORunQueryExecutionPlanTask;
import com.orientechnologies.orient.server.distributed.impl.task.OSyncClusterTask;
import com.orientechnologies.orient.server.distributed.task.ORemoteTask;
import com.orientechnologies.orient.server.hazelcast.OHazelcastPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;

public class ODatabaseDocumentDistributed
extends ODatabaseDocumentEmbedded {
    private final OHazelcastPlugin hazelcastPlugin;

    public ODatabaseDocumentDistributed(OStorage storage, OHazelcastPlugin hazelcastPlugin) {
        super(storage);
        this.hazelcastPlugin = hazelcastPlugin;
    }

    public ODistributedStorage getStorageDistributed() {
        return (ODistributedStorage)super.getStorage();
    }

    public String getLocalNodeName() {
        return this.getStorageDistributed().getNodeId();
    }

    public Map<String, Set<String>> getActiveClusterMap() {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        ODistributedConfiguration cfg = this.getStorageDistributed().getDistributedConfiguration();
        for (String server : this.getStorageDistributed().getDistributedManager().getActiveServers()) {
            if (this.getClustersOnServer(cfg, server).contains("*")) {
                result.put(server, this.getStorage().getClusterNames());
                continue;
            }
            result.put(server, this.getClustersOnServer(cfg, server));
        }
        return result;
    }

    public Set<String> getClustersOnServer(ODistributedConfiguration cfg, String server) {
        Set result = cfg.getClustersOnServer(server);
        if (result.contains("*")) {
            result.remove("*");
            HashSet more = new HashSet();
            more.addAll(this.getStorage().getClusterNames());
            for (String s : cfg.getClusterNames()) {
                if (cfg.getServers(s, null).contains(s)) continue;
                more.remove(s);
            }
            result.addAll(more);
        }
        return result;
    }

    protected void loadMetadata() {
        this.metadata = new OMetadataDefault((ODatabaseDocumentInternal)this);
        this.sharedContext = (OSharedContext)this.getStorage().getResource(OSharedContext.class.getName(), (Callable)new Callable<OSharedContext>(){

            @Override
            public OSharedContext call() throws Exception {
                OSharedContextDistributed shared = new OSharedContextDistributed(ODatabaseDocumentDistributed.this.getStorage());
                return shared;
            }
        });
        this.metadata.init(this.sharedContext);
        this.sharedContext.load((ODatabaseDocumentInternal)this);
    }

    public Map<String, Set<String>> getActiveDataCenterMap() {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        ODistributedConfiguration cfg = this.getStorageDistributed().getDistributedConfiguration();
        Set servers = cfg.getRegisteredServers();
        for (String server : servers) {
            String dc = cfg.getDataCenterOfServer(server);
            HashSet<String> dcConfig = (HashSet<String>)result.get(dc);
            if (dcConfig == null) {
                dcConfig = new HashSet<String>();
                result.put(dc, dcConfig);
            }
            dcConfig.add(server);
        }
        return result;
    }

    public boolean isSharded() {
        Map<String, Set<String>> clusterMap = this.getActiveClusterMap();
        Iterator<Set<String>> iter = clusterMap.values().iterator();
        Set<String> firstClusterSet = null;
        if (iter.hasNext()) {
            firstClusterSet = iter.next();
        }
        while (iter.hasNext()) {
            if (firstClusterSet.equals(iter.next())) continue;
            return true;
        }
        return false;
    }

    public ODatabaseDocumentInternal copy() {
        ODatabaseDocumentDistributed database = new ODatabaseDocumentDistributed(this.getStorage(), this.hazelcastPlugin);
        database.init(this.getConfig());
        database.internalOpen(this.getUser().getName(), null, false);
        database.callOnOpenListeners();
        this.activateOnCurrentThread();
        return database;
    }

    public boolean sync(boolean forceDeployment, boolean tryWithDelta) {
        this.checkSecurity(ORule.ResourceGeneric.DATABASE, "sync", ORole.PERMISSION_UPDATE);
        OStorage stg = this.getStorage();
        if (!(stg instanceof ODistributedStorage)) {
            throw new ODistributedException("SYNC DATABASE command cannot be executed against a non distributed server");
        }
        ODistributedStorage dStg = (ODistributedStorage)stg;
        OHazelcastPlugin dManager = (OHazelcastPlugin)dStg.getDistributedManager();
        if (dManager == null || !dManager.isEnabled()) {
            throw new OCommandExecutionException("OrientDB is not started in distributed mode");
        }
        String databaseName = this.getName();
        return dManager.installDatabase(true, databaseName, forceDeployment, tryWithDelta);
    }

    public Map<String, Object> getHaStatus(boolean servers, boolean db, boolean latency, boolean messages) {
        this.checkSecurity(ORule.ResourceGeneric.SERVER, "status", ORole.PERMISSION_READ);
        String dbUrl = this.getURL();
        String path = dbUrl.substring(dbUrl.indexOf(":") + 1);
        OServer serverInstance = OServer.getInstanceByPath((String)path);
        OHazelcastPlugin dManager = (OHazelcastPlugin)serverInstance.getDistributedManager();
        if (dManager == null || !dManager.isEnabled()) {
            throw new OCommandExecutionException("OrientDB is not started in distributed mode");
        }
        String databaseName = this.getName();
        ODistributedConfiguration cfg = dManager.getDatabaseConfiguration(databaseName);
        HashMap<String, Object> row = new HashMap<String, Object>();
        StringBuilder output = new StringBuilder();
        if (servers) {
            row.put("servers", dManager.getClusterConfiguration());
        }
        if (db) {
            row.put("database", cfg.getDocument());
        }
        if (latency) {
            row.put("latency", ODistributedOutput.formatLatency(dManager, dManager.getClusterConfiguration()));
        }
        if (messages) {
            row.put("messages", ODistributedOutput.formatMessages(dManager, dManager.getClusterConfiguration()));
        }
        return row;
    }

    public boolean removeHaServer(String serverName) {
        this.checkSecurity(ORule.ResourceGeneric.SERVER, "remove", ORole.PERMISSION_EXECUTE);
        String dbUrl = this.getURL();
        String path = dbUrl.substring(dbUrl.indexOf(":") + 1);
        OServer serverInstance = OServer.getInstanceByPath((String)path);
        OHazelcastPlugin dManager = (OHazelcastPlugin)serverInstance.getDistributedManager();
        if (dManager == null || !dManager.isEnabled()) {
            throw new OCommandExecutionException("OrientDB is not started in distributed mode");
        }
        String databaseName = this.getName();
        return dManager.removeNodeFromConfiguration(serverName, databaseName, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> syncCluster(String clusterName) {
        this.checkSecurity(ORule.ResourceGeneric.CLUSTER, "sync", ORole.PERMISSION_UPDATE);
        String dbUrl = this.getURL();
        String path = dbUrl.substring(dbUrl.indexOf(":") + 1);
        OServer serverInstance = OServer.getInstanceByPath((String)path);
        OHazelcastPlugin dManager = (OHazelcastPlugin)serverInstance.getDistributedManager();
        if (dManager == null || !dManager.isEnabled()) {
            throw new OCommandExecutionException("OrientDB is not started in distributed mode");
        }
        String databaseName = this.getName();
        ODistributedConfiguration cfg = dManager.getDatabaseConfiguration(databaseName);
        String dbPath = serverInstance.getDatabaseDirectory() + databaseName;
        String nodeName = dManager.getLocalNodeName();
        List nodesWhereClusterIsCfg = cfg.getServers(clusterName, null);
        nodesWhereClusterIsCfg.remove(nodeName);
        if (nodesWhereClusterIsCfg.isEmpty()) {
            throw new OCommandExecutionException("Cannot synchronize cluster '" + clusterName + "' because is not configured on any running nodes");
        }
        OSyncClusterTask task = new OSyncClusterTask(clusterName);
        ODistributedResponse response = dManager.sendRequest(databaseName, null, nodesWhereClusterIsCfg, (ORemoteTask)task, dManager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null, null);
        Map results = (Map)response.getPayload();
        File tempFile = null;
        OutputStream out = null;
        try {
            boolean openDatabaseHere;
            tempFile = new File(Orient.getTempPath() + "/backup_" + databaseName + "_" + clusterName + "_toInstall.zip");
            if (tempFile.exists()) {
                tempFile.delete();
            } else {
                tempFile.getParentFile().mkdirs();
            }
            tempFile.createNewFile();
            long fileSize = 0L;
            out = new FileOutputStream(tempFile, false);
            for (Map.Entry r : results.entrySet()) {
                Object value = r.getValue();
                if (value instanceof Boolean) continue;
                if (value instanceof Throwable) {
                    ODistributedServerLog.error(null, (String)nodeName, (String)((String)r.getKey()), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"error on installing cluster %s in %s", (Throwable)((Exception)value), (Object[])new Object[]{databaseName, dbPath});
                    continue;
                }
                if (!(value instanceof ODistributedDatabaseChunk)) continue;
                ODistributedDatabaseChunk chunk = (ODistributedDatabaseChunk)value;
                File completedFile = new File(tempFile.getAbsolutePath() + ".completed");
                if (completedFile.exists()) {
                    completedFile.delete();
                }
                fileSize = ODatabaseDocumentDistributed.writeDatabaseChunk(nodeName, 1, chunk, (FileOutputStream)out);
                int chunkNum = 2;
                while (!chunk.last) {
                    ODistributedResponse result = dManager.sendRequest(databaseName, null, OMultiValue.getSingletonList(r.getKey()), (ORemoteTask)new OCopyDatabaseChunkTask(chunk.filePath, chunkNum, chunk.offset + (long)chunk.buffer.length, false), dManager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null, null);
                    if (!(result instanceof Boolean)) {
                        if (result instanceof Exception) {
                            ODistributedServerLog.error(null, (String)nodeName, (String)((String)r.getKey()), (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.IN, (String)"error on installing database %s in %s (chunk #%d)", (Throwable)((Exception)result), (Object[])new Object[]{databaseName, dbPath, chunkNum});
                        } else if (result instanceof ODistributedDatabaseChunk) {
                            chunk = (ODistributedDatabaseChunk)result;
                            fileSize += ODatabaseDocumentDistributed.writeDatabaseChunk(nodeName, chunkNum, chunk, (FileOutputStream)out);
                        }
                    }
                    ++chunkNum;
                }
                out.flush();
                new File(tempFile.getAbsolutePath() + ".completed").createNewFile();
            }
            String tempDirectoryPath = Orient.getTempPath() + "/backup_" + databaseName + "_" + clusterName + "_toInstall";
            File tempDirectory = new File(tempDirectoryPath);
            tempDirectory.mkdirs();
            OZIPCompressionUtil.uncompressDirectory((InputStream)new FileInputStream(tempFile), (String)tempDirectory.getAbsolutePath(), null);
            ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().getIfDefined();
            boolean bl = openDatabaseHere = db == null;
            if (db == null) {
                db = serverInstance.openDatabase("plocal:" + dbPath, "", "", null, true);
            }
            try {
                OAbstractPaginatedStorage stg = (OAbstractPaginatedStorage)db.getStorage().getUnderlying();
                stg.freeze(false);
                try {
                    OPaginatedCluster cluster = (OPaginatedCluster)stg.getClusterByName(clusterName);
                    File tempClusterFile = new File(tempDirectoryPath + "/" + clusterName + ".pcl");
                    cluster.replaceFile(tempClusterFile);
                }
                finally {
                    stg.release();
                }
                db.getLocalCache().invalidate();
            }
            finally {
                if (openDatabaseHere) {
                    db.close();
                }
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("fileSize", fileSize);
            result.put("message", "Cluster correctly replaced");
            result.put("result", true);
            HashMap<String, Object> hashMap = result;
            return hashMap;
        }
        catch (Exception e) {
            ODistributedServerLog.error(null, (String)nodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"error on transferring database '%s' to '%s'", (Throwable)e, (Object[])new Object[]{databaseName, tempFile});
            throw OException.wrapException((OException)new ODistributedException("Error on transferring database"), (Throwable)e);
        }
        finally {
            try {
                if (out != null) {
                    out.flush();
                    ((FileOutputStream)out).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected static long writeDatabaseChunk(String iNodeName, int iChunkId, ODistributedDatabaseChunk chunk, FileOutputStream out) throws IOException {
        ODistributedServerLog.warn(null, (String)iNodeName, null, (ODistributedServerLog.DIRECTION)ODistributedServerLog.DIRECTION.NONE, (String)"- writing chunk #%d offset=%d size=%s", (Object[])new Object[]{iChunkId, chunk.offset, OFileUtils.getSizeAsString((long)chunk.buffer.length)});
        out.write(chunk.buffer);
        return chunk.buffer.length;
    }

    public OResultSet queryOnNode(String nodeName, OExecutionPlan executionPlan, Map<Object, Object> inputParameters) {
        ORunQueryExecutionPlanTask task = new ORunQueryExecutionPlanTask(executionPlan, inputParameters, nodeName);
        ODistributedResponse result = this.executeTaskOnNode((ORemoteTask)task, nodeName);
        return task.getResult(result, this);
    }

    public ODistributedResponse executeTaskOnNode(ORemoteTask task, String nodeName) {
        String dbUrl = this.getURL();
        String path = dbUrl.substring(dbUrl.indexOf(":") + 1);
        OServer serverInstance = OServer.getInstanceByPath((String)path);
        ODistributedServerManager dManager = serverInstance.getDistributedManager();
        if (dManager == null || !dManager.isEnabled()) {
            throw new ODistributedException("OrientDB is not started in distributed mode");
        }
        String databaseName = this.getName();
        return dManager.sendRequest(databaseName, null, Collections.singletonList(nodeName), task, dManager.getNextMessageIdCounter(), ODistributedRequest.EXECUTION_MODE.RESPONSE, null, null, null);
    }

    public void init(OrientDBConfig config) {
        OScenarioThreadLocal.executeAsDistributed(() -> {
            super.init(config);
            return null;
        });
    }

    protected void createMetadata() {
        OSharedContext shared = (OSharedContext)this.getStorage().getResource(OSharedContext.class.getName(), (Callable)new Callable<OSharedContext>(){

            @Override
            public OSharedContext call() throws Exception {
                OSharedContextDistributed shared = new OSharedContextDistributed(ODatabaseDocumentDistributed.this.getStorage());
                return shared;
            }
        });
        this.metadata.init(shared);
        ((OSharedContextDistributed)shared).create((ODatabaseDocumentInternal)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int assignAndCheckCluster(ORecord record, String iClusterName) {
        ORecordId rid = (ORecordId)record.getIdentity();
        if ((long)rid.getClusterId() <= -1L && iClusterName != null) {
            rid.setClusterId(this.getClusterIdByName(iClusterName));
            if (rid.getClusterId() == -1) {
                throw new IllegalArgumentException("Cluster name '" + iClusterName + "' is not configured");
            }
        }
        OClass schemaClass = null;
        if (rid.getClusterId() <= -1 && this.getStorage().isAssigningClusterIds()) {
            if (!(record instanceof ODocument)) throw new ODatabaseException("Cannot save (5) document " + record + ": no class or cluster defined");
            schemaClass = ((ODocument)record).getSchemaClass();
            if (schemaClass == null) throw new ODatabaseException("Cannot save (4) document " + record + ": no class or cluster defined");
            if (schemaClass.isAbstract()) {
                throw new OSchemaException("Document belongs to abstract class " + schemaClass.getName() + " and cannot be saved");
            }
            rid.setClusterId(schemaClass.getClusterForNewInstance((ODocument)record));
        } else if (record instanceof ODocument) {
            schemaClass = ((ODocument)record).getSchemaClass();
        }
        if (rid.getClusterId() <= -1 || schemaClass == null) return rid.getClusterId();
        String messageClusterName = this.getClusterNameById(rid.getClusterId());
        this.checkRecordClass(schemaClass, messageClusterName, rid);
        if (schemaClass.hasClusterId(rid.getClusterId())) return rid.getClusterId();
        throw new IllegalArgumentException("Cluster name '" + messageClusterName + "' (id=" + rid.getClusterId() + ") is not configured to store the class '" + schemaClass.getName() + "', valid are " + Arrays.toString(schemaClass.getClusterIds()));
    }

    public void internalCommit(OTransactionInternal iTx) {
        if (OScenarioThreadLocal.INSTANCE.isRunModeDistributed()) {
            super.internalCommit(iTx);
        } else {
            try {
                for (ORecordOperation txEntry : iTx.getRecordOperations()) {
                    ORecord record;
                    if (txEntry.type != 3 && txEntry.type != 1 || !((record = txEntry.getRecord()) instanceof ODocument)) continue;
                    ((ODocument)record).validate();
                }
                ODistributedConfiguration dbCfg = this.getStorageDistributed().getDistributedConfiguration();
                ODistributedServerManager dManager = this.getStorageDistributed().getDistributedManager();
                String localNodeName = dManager.getLocalNodeName();
                this.getStorageDistributed().checkNodeIsMaster(localNodeName, dbCfg, "Transaction Commit");
                ONewDistributedTransactionManager txManager = new ONewDistributedTransactionManager(this.getStorageDistributed(), dManager, this.getStorageDistributed().getLocalDistributedDatabase());
                ((OAbstractPaginatedStorage)this.getStorage().getUnderlying()).preallocateRids(iTx);
                txManager.commit(this, iTx, this.getStorageDistributed().getEventListener());
                return;
            }
            catch (OValidationException e) {
                throw e;
            }
            catch (HazelcastInstanceNotActiveException e) {
                throw new OOfflineNodeException("Hazelcast instance is not available");
            }
            catch (HazelcastException e) {
                throw new OOfflineNodeException("Hazelcast instance is not available");
            }
            catch (Exception e) {
                this.getStorageDistributed().handleDistributedException("Cannot route TX operation against distributed node", e, new Object[0]);
            }
        }
    }

    public void acquireLocksForTx(OTransactionInternal tx, ODistributedTxContext txContext) {
        TreeSet<ORID> rids = new TreeSet<ORID>();
        for (ORecordOperation entry : tx.getRecordOperations()) {
            rids.add(entry.getRID());
        }
        for (ORID rid : rids) {
            txContext.lock(rid);
        }
        TreeSet<OPair> keys = new TreeSet<OPair>();
        for (Map.Entry change : tx.getIndexOperations().entrySet()) {
            OIndex index = this.getMetadata().getIndexManager().getIndex((String)change.getKey());
            if (!OClass.INDEX_TYPE.UNIQUE.name().equals(index.getType()) && !OClass.INDEX_TYPE.UNIQUE_HASH_INDEX.name().equals(index.getType()) && !OClass.INDEX_TYPE.DICTIONARY.name().equals(index.getType()) && !OClass.INDEX_TYPE.DICTIONARY_HASH_INDEX.name().equals(index.getType())) continue;
            for (OTransactionIndexChangesPerKey changesPerKey : ((OTransactionIndexChanges)change.getValue()).changesPerKey.values()) {
                keys.add(new OPair((Comparable)((Object)String.valueOf(changesPerKey.key)), changesPerKey.key));
            }
        }
        for (OPair key : keys) {
            txContext.lockIndexKey(key.getValue());
        }
    }

    public boolean beginDistributedTx(ODistributedRequestId requestId, OTransactionInternal tx, boolean local, int retryCount) {
        ODistributedDatabase localDistributedDatabase = this.getStorageDistributed().getLocalDistributedDatabase();
        ONewDistributedTxContextImpl txContext = new ONewDistributedTxContextImpl((ODistributedDatabaseImpl)localDistributedDatabase, requestId, tx);
        try {
            txContext.begin((ODatabaseDocumentInternal)this, local);
        }
        catch (OConcurrentCreateException ex) {
            if ((retryCount >= 0 || retryCount < this.getConfiguration().getValueAsInteger(OGlobalConfiguration.DISTRIBUTED_CONCURRENT_TX_MAX_AUTORETRY)) && ex.getExpectedRid().getClusterPosition() > ex.getActualRid().getClusterPosition()) {
                return false;
            }
            throw ex;
        }
        catch (OConcurrentModificationException ex) {
            if ((retryCount >= 0 || retryCount < this.getConfiguration().getValueAsInteger(OGlobalConfiguration.DISTRIBUTED_CONCURRENT_TX_MAX_AUTORETRY)) && ex.getEnhancedRecordVersion() > ex.getEnhancedDatabaseVersion()) {
                return false;
            }
            throw ex;
        }
        localDistributedDatabase.registerTxContext(requestId, (ODistributedTxContext)txContext);
        return true;
    }

    public void commit2pcLocal(ODistributedRequestId transactionId) {
        this.commit2pc(transactionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commit2pc(ODistributedRequestId transactionId) {
        this.getStorageDistributed().resetLastValidBackup();
        ODistributedDatabase localDistributedDatabase = this.getStorageDistributed().getLocalDistributedDatabase();
        ODistributedTxContext txContext = localDistributedDatabase.getTxContext(transactionId);
        if (txContext != null) {
            try {
                txContext.commit((ODatabaseDocumentInternal)this);
                localDistributedDatabase.popTxContext(transactionId);
                OLiveQueryHook.notifyForTxChanges((ODatabase)this);
                OLiveQueryHookV2.notifyForTxChanges((ODatabaseDocument)this);
            }
            finally {
                OLiveQueryHook.removePendingDatabaseOps((ODatabase)this);
                OLiveQueryHookV2.removePendingDatabaseOps((ODatabaseDocument)this);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback2pc(ODistributedRequestId transactionId) {
        ODistributedDatabase localDistributedDatabase = this.getStorageDistributed().getLocalDistributedDatabase();
        ODistributedTxContext txContext = localDistributedDatabase.popTxContext(transactionId);
        if (txContext != null) {
            ODistributedTxContext oDistributedTxContext = txContext;
            synchronized (oDistributedTxContext) {
                txContext.destroy();
            }
            OLiveQueryHook.removePendingDatabaseOps((ODatabase)this);
            OLiveQueryHookV2.removePendingDatabaseOps((ODatabaseDocument)this);
        }
    }

    public void internalCommit2pc(ONewDistributedTxContextImpl txContext) {
        try {
            OTransactionInternal tx = txContext.getTransaction();
            ((OAbstractPaginatedStorage)this.getStorage().getUnderlying()).commitPreAllocated(tx);
        }
        finally {
            txContext.destroy();
        }
    }

    public void internalBegin2pc(ONewDistributedTxContextImpl txContext, boolean local) {
        this.getStorageDistributed().resetLastValidBackup();
        this.acquireLocksForTx(txContext.getTransaction(), txContext);
        for (Map.Entry change : txContext.getTransaction().getIndexOperations().entrySet()) {
            OIndex index = this.getMetadata().getIndexManager().getIndex((String)change.getKey());
            if (!OClass.INDEX_TYPE.UNIQUE.name().equals(index.getType()) && !OClass.INDEX_TYPE.UNIQUE_HASH_INDEX.name().equals(index.getType())) continue;
            for (OTransactionIndexChangesPerKey changesPerKey : ((OTransactionIndexChanges)change.getValue()).changesPerKey.values()) {
                OIdentifiable old = (OIdentifiable)index.get(changesPerKey.key);
                OIdentifiable newValue = ((OTransactionIndexChangesPerKey.OTransactionIndexEntry)changesPerKey.entries.get((int)(changesPerKey.entries.size() - 1))).value;
                if (old == null || old.equals(newValue)) continue;
                throw new ORecordDuplicatedException(String.format("Cannot index record %s: found duplicated key '%s' in index '%s' previously assigned to the record %s", newValue, changesPerKey.key, this.getName(), old.getIdentity()), this.getName(), old.getIdentity(), changesPerKey.key);
            }
        }
        for (ORecordOperation entry : txContext.getTransaction().getRecordOperations()) {
            if (entry.getType() == 3) continue;
            int changeVersion = entry.getRecord().getVersion();
            ORecordMetadata metadata = this.getStorage().getRecordMetadata(entry.getRID());
            if (metadata == null) {
                if (((OAbstractPaginatedStorage)this.getStorage().getUnderlying()).isDeleted(entry.getRID())) {
                    throw new OConcurrentModificationException(entry.getRID(), changeVersion, changeVersion, (int)entry.getType());
                }
                throw new OConcurrentCreateException((ORID)new ORecordId(-1, -1L), entry.getRID());
            }
            int persistentVersion = metadata.getVersion();
            if (changeVersion == persistentVersion) continue;
            throw new OConcurrentModificationException(entry.getRID(), persistentVersion, changeVersion, (int)entry.getType());
        }
        if (!local) {
            ((OAbstractPaginatedStorage)this.getStorage().getUnderlying()).preallocateRids(txContext.getTransaction());
        }
    }
}

