/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial.functions;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.spatial.BaseSpatialLuceneTest;
import java.util.Iterator;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class LuceneSpatialWithinTest
extends BaseSpatialLuceneTest {
    @Test
    public void testWithinNoIndex() {
        List execute = (List)this.db.command((OCommandRequest)new OCommandSQL("select ST_Within(smallc,smallc) as smallinsmall,ST_Within(smallc, bigc) As smallinbig, ST_Within(bigc,smallc) As biginsmall from (SELECT ST_Buffer(ST_GeomFromText('POINT(50 50)'), 20) As smallc,ST_Buffer(ST_GeomFromText('POINT(50 50)'), 40) As bigc)")).execute(new Object[0]);
        ODocument next = (ODocument)execute.iterator().next();
        Assert.assertEquals((Object)next.field("smallinsmall"), (Object)true);
        Assert.assertEquals((Object)next.field("smallinbig"), (Object)true);
        Assert.assertEquals((Object)next.field("biginsmall"), (Object)false);
    }

    @Test
    public void testWithinIndex() {
        this.db.command((OCommandRequest)new OCommandSQL("create class Polygon extends v")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create property Polygon.geometry EMBEDDED OPolygon")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("insert into Polygon set geometry = ST_Buffer(ST_GeomFromText('POINT(50 50)'), 20)")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("insert into Polygon set geometry = ST_Buffer(ST_GeomFromText('POINT(50 50)'), 40)")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create index Polygon.g on Polygon (geometry) SPATIAL engine lucene")).execute(new Object[0]);
        List execute = (List)this.db.command((OCommandRequest)new OCommandSQL("SELECT from Polygon where ST_Within(geometry, ST_Buffer(ST_GeomFromText('POINT(50 50)'), 50)) = true")).execute(new Object[0]);
        Assert.assertEquals((long)execute.size(), (long)2L);
        execute = (List)this.db.command((OCommandRequest)new OCommandSQL("SELECT from Polygon where ST_Within(geometry, ST_Buffer(ST_GeomFromText('POINT(50 50)'), 30)) = true")).execute(new Object[0]);
        Assert.assertEquals((long)execute.size(), (long)1L);
    }

    @Test
    public void testWithinNewExecutor() throws Exception {
        this.db.command("create class Polygon extends v", new Object[0]);
        this.db.command("create property Polygon.geometry EMBEDDED OPolygon", new Object[0]);
        this.db.command("insert into Polygon set geometry = ST_Buffer(ST_GeomFromText('POINT(50 50)'), 20)", new Object[0]);
        this.db.command("insert into Polygon set geometry = ST_Buffer(ST_GeomFromText('POINT(50 50)'), 40)", new Object[0]);
        this.db.command("create index Polygon.g on Polygon(geometry) SPATIAL ENGINE LUCENE", new Object[0]);
        OResultSet execute = this.db.query("SELECT from Polygon where ST_Within(geometry, ST_Buffer(ST_GeomFromText('POINT(50 50)'), 50)) = true", new Object[0]);
        Assertions.assertThat((Iterator)execute).hasSize(2);
        execute = this.db.query("SELECT from Polygon where ST_Within(geometry, ST_Buffer(ST_GeomFromText('POINT(50 50)'), 30)) = true", new Object[0]);
        Assertions.assertThat((Iterator)execute).hasSize(1);
    }
}

