/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial.functions;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.spatial.BaseSpatialLuceneTest;
import com.orientechnologies.spatial.shape.OShapeFactory;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.jts.JtsGeometry;

public class LuceneSpatialMiscFunctionsTest
extends BaseSpatialLuceneTest {
    @Test
    public void testStEquals() {
        List execute = (List)this.db.command((OCommandRequest)new OCommandSQL("SELECT ST_Equals(ST_GeomFromText('LINESTRING(0 0, 10 10)'), ST_GeomFromText('LINESTRING(0 0, 5 5, 10 10)'))")).execute(new Object[0]);
        ODocument next = (ODocument)execute.iterator().next();
        Assert.assertEquals((Object)next.field("ST_Equals"), (Object)true);
    }

    @Test
    public void testStEqualsPoint() {
        List execute = (List)this.db.command((OCommandRequest)new OCommandSQL("select ST_Equals(ST_GeomFromText('POINT (55.78639 37.58378)'), ST_GeomFromText('POINT (55.78639 37.58378)'))")).execute(new Object[0]);
        ODocument next = (ODocument)execute.iterator().next();
        Assert.assertEquals((Object)next.field("ST_Equals"), (Object)true);
    }

    @Test
    public void testStWithinPoint() {
        List execute = (List)this.db.command((OCommandRequest)new OCommandSQL("select ST_Within(ST_GeomFromText('POINT (55.78639 37.58378)'), ST_GeomFromText('POINT (55.78639 37.58378)'))")).execute(new Object[0]);
        ODocument next = (ODocument)execute.iterator().next();
        Assert.assertEquals((Object)true, (Object)next.field("ST_Within"));
    }

    @Test
    public void testStContainsPoint() {
        List execute = (List)this.db.command((OCommandRequest)new OCommandSQL("select ST_Contains(ST_GeomFromText('POINT (55.78639 37.58378)'), ST_GeomFromText('POINT (55.78639 37.58378)'))")).execute(new Object[0]);
        ODocument next = (ODocument)execute.iterator().next();
        Assert.assertEquals((Object)true, (Object)next.field("ST_Contains"));
    }

    @Test
    @Ignore
    public void testAsBinary() {
        List execute = (List)this.db.command((OCommandRequest)new OCommandSQL("SELECT ST_AsBinary(ST_GeomFromText('LINESTRING(0 0, 10 10)'))")).execute(new Object[0]);
        ODocument next = (ODocument)execute.iterator().next();
        Assert.assertNull((Object)next.field("ST_AsBinary"));
    }

    @Test
    public void testEnvelope() {
        List execute = (List)this.db.command((OCommandRequest)new OCommandSQL("SELECT ST_AsText(ST_Envelope('LINESTRING(0 0, 1 3)'))")).execute(new Object[0]);
        ODocument next = (ODocument)execute.iterator().next();
        Assert.assertEquals((Object)next.field("ST_AsText"), (Object)"POLYGON ((0 0, 0 3, 1 3, 1 0, 0 0))");
    }

    @Test
    public void testBuffer() {
        List actual;
        List<Double> expected;
        int i;
        List execute = (List)this.db.command((OCommandRequest)new OCommandSQL("SELECT ST_Buffer(ST_GeomFromText('POINT(100 90)'),50) as buffer;")).execute(new Object[0]);
        ODocument next = (ODocument)execute.iterator().next();
        OElement buffer = (OElement)next.getProperty("buffer");
        List coordinates = (List)buffer.getProperty("coordinates");
        Assert.assertNotNull((Object)coordinates);
        Assert.assertEquals((long)1L, (long)coordinates.size());
        List<List<Double>> arrays = this.buildArrays1();
        List exp = (List)coordinates.get(0);
        for (i = 0; i < arrays.size(); ++i) {
            expected = arrays.get(i);
            actual = (List)exp.get(i);
            Assert.assertEquals((double)expected.get(0), (double)((Double)actual.get(0)), (double)1.0E-8);
        }
        execute = (List)this.db.command((OCommandRequest)new OCommandSQL("SELECT ST_Buffer(ST_GeomFromText('POINT(100 90)'), 50, { quadSegs : 2 }) as buffer;")).execute(new Object[0]);
        next = (ODocument)execute.iterator().next();
        buffer = (OElement)next.getProperty("buffer");
        coordinates = (List)buffer.getProperty("coordinates");
        Assert.assertNotNull((Object)coordinates);
        Assert.assertEquals((long)1L, (long)coordinates.size());
        arrays = this.buildArrays2();
        exp = (List)coordinates.get(0);
        for (i = 0; i < arrays.size(); ++i) {
            expected = arrays.get(i);
            actual = (List)exp.get(i);
            Assert.assertEquals((double)expected.get(0), (double)((Double)actual.get(0)), (double)1.0E-8);
        }
        execute = (List)this.db.command((OCommandRequest)new OCommandSQL("SELECT ST_Buffer(ST_GeomFromText('LINESTRING(0 0,75 75,75 0)'), 10, { 'endCap' : 'square' }) as buffer;")).execute(new Object[0]);
        next = (ODocument)execute.iterator().next();
        buffer = (OElement)next.getProperty("buffer");
        coordinates = (List)buffer.getProperty("coordinates");
        Assert.assertNotNull((Object)coordinates);
        Assert.assertEquals((long)1L, (long)coordinates.size());
        arrays = this.buildArrays3();
        exp = (List)coordinates.get(0);
        for (i = 0; i < arrays.size(); ++i) {
            expected = arrays.get(i);
            actual = (List)exp.get(i);
            Assert.assertEquals((double)expected.get(0), (double)((Double)actual.get(0)), (double)1.0E-8);
        }
    }

    private List<List<Double>> buildArrays1() {
        ArrayList<List<Double>> list = new ArrayList<List<Double>>();
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(150.0);
        ((List)list.get(list.size() - 1)).add(90.0);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(149.0392640201615);
        ((List)list.get(list.size() - 1)).add(80.24548389919359);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(146.19397662556435);
        ((List)list.get(list.size() - 1)).add(70.86582838174552);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(141.57348061512727);
        ((List)list.get(list.size() - 1)).add(62.22148834901989);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(135.35533905932738);
        ((List)list.get(list.size() - 1)).add(54.64466094067263);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(127.77851165098011);
        ((List)list.get(list.size() - 1)).add(48.42651938487274);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(119.1341716182545);
        ((List)list.get(list.size() - 1)).add(43.80602337443566);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(109.75451610080641);
        ((List)list.get(list.size() - 1)).add(40.960735979838475);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(100.0);
        ((List)list.get(list.size() - 1)).add(40.0);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(90.24548389919359);
        ((List)list.get(list.size() - 1)).add(40.960735979838475);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(80.86582838174552);
        ((List)list.get(list.size() - 1)).add(43.80602337443566);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(72.2214883490199);
        ((List)list.get(list.size() - 1)).add(48.426519384872734);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(64.64466094067262);
        ((List)list.get(list.size() - 1)).add(54.64466094067262);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(58.426519384872734);
        ((List)list.get(list.size() - 1)).add(62.22148834901989);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(53.80602337443566);
        ((List)list.get(list.size() - 1)).add(70.86582838174553);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(50.960735979838475);
        ((List)list.get(list.size() - 1)).add(80.24548389919362);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(50.0);
        ((List)list.get(list.size() - 1)).add(90.00000000000004);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(50.96073597983849);
        ((List)list.get(list.size() - 1)).add(99.75451610080646);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(53.80602337443568);
        ((List)list.get(list.size() - 1)).add(109.13417161825454);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(58.426519384872776);
        ((List)list.get(list.size() - 1)).add(117.77851165098016);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(64.64466094067268);
        ((List)list.get(list.size() - 1)).add(125.35533905932743);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(72.22148834901996);
        ((List)list.get(list.size() - 1)).add(131.57348061512732);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(80.8658283817456);
        ((List)list.get(list.size() - 1)).add(136.19397662556437);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(90.2454838991937);
        ((List)list.get(list.size() - 1)).add(139.03926402016154);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(100.00000000000013);
        ((List)list.get(list.size() - 1)).add(140.0);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(109.75451610080654);
        ((List)list.get(list.size() - 1)).add(139.0392640201615);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(119.13417161825463);
        ((List)list.get(list.size() - 1)).add(136.1939766255643);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(127.77851165098025);
        ((List)list.get(list.size() - 1)).add(131.57348061512718);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(135.3553390593275);
        ((List)list.get(list.size() - 1)).add(125.35533905932726);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(141.57348061512735);
        ((List)list.get(list.size() - 1)).add(117.77851165097996);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(146.1939766255644);
        ((List)list.get(list.size() - 1)).add(109.13417161825431);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(149.03926402016157);
        ((List)list.get(list.size() - 1)).add(99.75451610080621);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(150.0);
        ((List)list.get(list.size() - 1)).add(90.0);
        return list;
    }

    private List<List<Double>> buildArrays2() {
        ArrayList<List<Double>> list = new ArrayList<List<Double>>();
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(150.0);
        ((List)list.get(list.size() - 1)).add(90.0);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(135.35533905932738);
        ((List)list.get(list.size() - 1)).add(54.64466094067263);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(100.0);
        ((List)list.get(list.size() - 1)).add(40.0);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(64.64466094067262);
        ((List)list.get(list.size() - 1)).add(54.64466094067262);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(50.0);
        ((List)list.get(list.size() - 1)).add(90.0);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(64.64466094067262);
        ((List)list.get(list.size() - 1)).add(125.35533905932738);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(99.99999999999999);
        ((List)list.get(list.size() - 1)).add(140.0);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(135.35533905932738);
        ((List)list.get(list.size() - 1)).add(125.35533905932738);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(150.0);
        ((List)list.get(list.size() - 1)).add(90.0);
        return list;
    }

    private List<List<Double>> buildArrays3() {
        ArrayList<List<Double>> list = new ArrayList<List<Double>>();
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(67.92893218813452);
        ((List)list.get(list.size() - 1)).add(82.07106781186548);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(69.44429766980397);
        ((List)list.get(list.size() - 1)).add(83.31469612302546);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(71.1731656763491);
        ((List)list.get(list.size() - 1)).add(84.23879532511287);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(73.04909677983872);
        ((List)list.get(list.size() - 1)).add(84.80785280403231);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(75.0);
        ((List)list.get(list.size() - 1)).add(85.0);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(76.95090322016128);
        ((List)list.get(list.size() - 1)).add(84.80785280403231);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(78.8268343236509);
        ((List)list.get(list.size() - 1)).add(84.23879532511287);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(80.55570233019603);
        ((List)list.get(list.size() - 1)).add(83.31469612302546);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(82.07106781186548);
        ((List)list.get(list.size() - 1)).add(82.07106781186548);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(83.31469612302546);
        ((List)list.get(list.size() - 1)).add(80.55570233019603);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(84.23879532511287);
        ((List)list.get(list.size() - 1)).add(78.8268343236509);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(84.80785280403231);
        ((List)list.get(list.size() - 1)).add(76.95090322016128);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(85.0);
        ((List)list.get(list.size() - 1)).add(75.0);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(85.0);
        ((List)list.get(list.size() - 1)).add(0.0);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(84.80785280403231);
        ((List)list.get(list.size() - 1)).add(-1.9509032201612824);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(84.23879532511287);
        ((List)list.get(list.size() - 1)).add(-3.826834323650898);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(83.31469612302546);
        ((List)list.get(list.size() - 1)).add(-5.555702330196022);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(82.07106781186548);
        ((List)list.get(list.size() - 1)).add(-7.071067811865475);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(80.55570233019603);
        ((List)list.get(list.size() - 1)).add(-8.314696123025453);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(78.8268343236509);
        ((List)list.get(list.size() - 1)).add(-9.238795325112868);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(76.95090322016128);
        ((List)list.get(list.size() - 1)).add(-9.807852804032304);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(75.0);
        ((List)list.get(list.size() - 1)).add(-10.0);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(73.04909677983872);
        ((List)list.get(list.size() - 1)).add(-9.807852804032304);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(71.1731656763491);
        ((List)list.get(list.size() - 1)).add(-9.238795325112868);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(69.44429766980397);
        ((List)list.get(list.size() - 1)).add(-8.314696123025453);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(67.92893218813452);
        ((List)list.get(list.size() - 1)).add(-7.0710678118654755);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(66.68530387697454);
        ((List)list.get(list.size() - 1)).add(-5.555702330196022);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(65.76120467488713);
        ((List)list.get(list.size() - 1)).add(-3.8268343236508944);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(65.19214719596769);
        ((List)list.get(list.size() - 1)).add(-1.9509032201612773);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(65.0);
        ((List)list.get(list.size() - 1)).add(0.0);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(65.0);
        ((List)list.get(list.size() - 1)).add(50.85786437626905);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(7.071067811865475);
        ((List)list.get(list.size() - 1)).add(-7.071067811865475);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(5.555702330196023);
        ((List)list.get(list.size() - 1)).add(-8.314696123025453);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(3.8268343236508984);
        ((List)list.get(list.size() - 1)).add(-9.238795325112868);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(1.9509032201612833);
        ((List)list.get(list.size() - 1)).add(-9.807852804032304);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(6.0E-16);
        ((List)list.get(list.size() - 1)).add(-10.0);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(-1.950903220161282);
        ((List)list.get(list.size() - 1)).add(-9.807852804032304);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(-3.826834323650897);
        ((List)list.get(list.size() - 1)).add(-9.238795325112868);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(-5.55570233019602);
        ((List)list.get(list.size() - 1)).add(-8.314696123025453);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(-7.071067811865475);
        ((List)list.get(list.size() - 1)).add(-7.0710678118654755);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(-8.314696123025453);
        ((List)list.get(list.size() - 1)).add(-5.555702330196022);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(-9.238795325112868);
        ((List)list.get(list.size() - 1)).add(-3.826834323650899);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(-9.807852804032304);
        ((List)list.get(list.size() - 1)).add(-1.9509032201612861);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(-10.0);
        ((List)list.get(list.size() - 1)).add(-1.2E-15);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(-9.807852804032304);
        ((List)list.get(list.size() - 1)).add(1.9509032201612837);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(-9.238795325112866);
        ((List)list.get(list.size() - 1)).add(3.8268343236509006);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(-8.314696123025449);
        ((List)list.get(list.size() - 1)).add(5.555702330196026);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(-7.071067811865475);
        ((List)list.get(list.size() - 1)).add(7.071067811865475);
        list.add(new ArrayList());
        ((List)list.get(list.size() - 1)).add(67.92893218813452);
        ((List)list.get(list.size() - 1)).add(82.07106781186548);
        return list;
    }

    @Test
    public void testDistance() {
        List execute = (List)this.db.command((OCommandRequest)new OCommandSQL("SELECT ST_Distance(ST_GeomFromText('POINT(-72.1235 42.3521)'),ST_GeomFromText('LINESTRING(-72.1260 42.45, -72.123 42.1546)'))")).execute(new Object[0]);
        ODocument next = (ODocument)execute.iterator().next();
        Assertions.assertThat((Double)((Double)next.field("ST_Distance"))).isEqualTo(0.0015056772638228177);
        execute = (List)this.db.command((OCommandRequest)new OCommandSQL("SELECT  ST_Distance( ST_GeomFromText('LINESTRING(13.45 52.47,13.46 52.48)'), ST_GeomFromText('LINESTRING(13.00 52.00,13.1 52.2)'))")).execute(new Object[0]);
        next = (ODocument)execute.iterator().next();
        Assertions.assertThat((Double)((Double)next.field("ST_Distance"))).isEqualTo(0.44204072210600415);
    }

    @Test
    public void testDisjoint() {
        List execute = (List)this.db.command((OCommandRequest)new OCommandSQL("SELECT ST_Disjoint('POINT(0 0)', 'LINESTRING ( 2 0, 0 2 )');")).execute(new Object[0]);
        ODocument next = (ODocument)execute.iterator().next();
        Assert.assertEquals((Object)next.field("ST_Disjoint"), (Object)true);
        execute = (List)this.db.command((OCommandRequest)new OCommandSQL("SELECT ST_Disjoint('POINT(0 0)', 'LINESTRING ( 0 0, 0 2 )');")).execute(new Object[0]);
        next = (ODocument)execute.iterator().next();
        Assert.assertEquals((Object)next.field("ST_Disjoint"), (Object)false);
    }

    @Test
    public void testWktPolygon() throws ParseException {
        Shape shape = OShapeFactory.INSTANCE.fromObject((Object)"POLYGON((0 0, 10 0, 10 5, 0 5, 0 0))");
        Assert.assertEquals((Object)(shape instanceof JtsGeometry), (Object)true);
        JtsGeometry geom = (JtsGeometry)shape;
        Assert.assertEquals((Object)(geom.getGeom() instanceof Polygon), (Object)true);
    }
}

