/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial.functions;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.spatial.BaseSpatialLuceneTest;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.spatial4j.distance.DistanceUtils;

public class LuceneSpatialDistanceSphereTest
extends BaseSpatialLuceneTest {
    @Test
    public void testDistanceSphereNoIndex() {
        List execute = (List)this.db.command((OCommandRequest)new OCommandSQL("select ST_Distance(ST_GEOMFROMTEXT('POINT(12.4662748 41.8914114)'),ST_GEOMFROMTEXT('POINT(12.4664632 41.8904382)')) as distanceDeg, \nST_Distance_Sphere(ST_GEOMFROMTEXT('POINT(12.4662748 41.8914114)'),ST_GEOMFROMTEXT('POINT(12.4664632 41.8904382)')) as distanceMeter")).execute(new Object[0]);
        Assert.assertEquals((long)1L, (long)execute.size());
        ODocument next = (ODocument)execute.iterator().next();
        Double distanceDeg = (Double)next.field("distanceDeg");
        Double distanceMeter = (Double)next.field("distanceMeter");
        Assert.assertNotNull((Object)distanceDeg);
        Assert.assertNotNull((Object)distanceMeter);
        Assert.assertEquals((long)109L, (long)distanceMeter.intValue());
        Double d = DistanceUtils.degrees2Dist((double)distanceDeg, (double)6378.137) * 1000.0;
        Assert.assertNotEquals((Object)d, (Object)distanceMeter);
    }

    @Test
    public void testWithinIndex() {
        this.db.command((OCommandRequest)new OCommandSQL("create class Place extends v")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create property Place.location EMBEDDED OPoint")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("insert into Place set name =  'Dar Poeta',location = ST_GeomFromText('POINT(12.4684635 41.8914114)')")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("insert into Place set name  = 'Antilia Pub',location = ST_GeomFromText('POINT(12.4686519 41.890438)')")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("insert into Place set name = 'Museo Di Roma in Trastevere',location = ST_GeomFromText('POINT(12.4689762 41.8898916)')")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create index Place.l on Place (location) SPATIAL engine lucene")).execute(new Object[0]);
        List execute = (List)this.db.command((OCommandRequest)new OCommandSQL("SELECT from Place where ST_Distance_Sphere(location, ST_GeomFromText('POINT(12.468933 41.890303)')) < 50")).execute(new Object[0]);
        Assert.assertEquals((long)2L, (long)execute.size());
        execute = (List)this.db.command((OCommandRequest)new OCommandSQL("SELECT from Place where ST_Distance_Sphere(location, ST_GeomFromText('POINT(12.468933 41.890303)')) > 50")).execute(new Object[0]);
        Assert.assertEquals((long)1L, (long)execute.size());
    }
}

