/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial.functions;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.spatial.BaseSpatialLuceneTest;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class LuceneSpatialContainsTest
extends BaseSpatialLuceneTest {
    @Test
    public void testContainsNoIndex() {
        List execute = (List)this.db.command((OCommandRequest)new OCommandSQL("select ST_Contains(smallc,smallc) as smallinsmall,ST_Contains(smallc, bigc) As smallinbig, ST_Contains(bigc,smallc) As biginsmall from (SELECT ST_Buffer(ST_GeomFromText('POINT(50 50)'), 20) As smallc,ST_Buffer(ST_GeomFromText('POINT(50 50)'), 40) As bigc)")).execute(new Object[0]);
        ODocument next = (ODocument)execute.iterator().next();
        Assert.assertTrue((boolean)((Boolean)next.field("smallinsmall")));
        Assert.assertFalse((boolean)((Boolean)next.field("smallinbig")));
        Assert.assertTrue((boolean)((Boolean)next.field("biginsmall")));
    }

    @Test
    public void testContainsIndex() {
        this.db.command((OCommandRequest)new OCommandSQL("create class Polygon extends v")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create property Polygon.geometry EMBEDDED OPolygon")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("insert into Polygon set geometry = ST_Buffer(ST_GeomFromText('POINT(50 50)'), 20)")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("insert into Polygon set geometry = ST_Buffer(ST_GeomFromText('POINT(50 50)'), 40)")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create index Polygon.g on Polygon (geometry) SPATIAL engine lucene")).execute(new Object[0]);
        List execute = (List)this.db.command((OCommandRequest)new OCommandSQL("SELECT from Polygon where ST_Contains(geometry, 'POINT(50 50)') = true")).execute(new Object[0]);
        Assert.assertEquals((long)2L, (long)execute.size());
        execute = (List)this.db.command((OCommandRequest)new OCommandSQL("SELECT from Polygon where ST_Contains(geometry, ST_Buffer(ST_GeomFromText('POINT(50 50)'), 30)) = true")).execute(new Object[0]);
        Assert.assertEquals((long)1L, (long)execute.size());
    }

    @Test
    public void testContainsIndex_GeometryCollection() {
        this.db.command((OCommandRequest)new OCommandSQL("create class TestInsert extends v")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create property TestInsert.geometry EMBEDDED OGeometryCollection")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("insert into TestInsert set geometry = {'@type':'d','@class':'OGeometryCollection','geometries':[{'@type':'d','@class':'OPolygon','coordinates':[[[0,0],[10,0],[10,10],[0,10],[0,0]]]}]}")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("insert into TestInsert set geometry = {'@type':'d','@class':'OGeometryCollection','geometries':[{'@type':'d','@class':'OPolygon','coordinates':[[[11,11],[21,11],[21,21],[11,21],[11,11]]]}]}")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("create index TestInsert.geometry on TestInsert (geometry) SPATIAL engine lucene")).execute(new Object[0]);
        String testGeometry = "{'@type':'d','@class':'OGeometryCollection','geometries':[{'@type':'d','@class':'OPolygon','coordinates':[[[1,1],[2,1],[2,2],[1,2],[1,1]]]}]}";
        List execute = (List)this.db.command((OCommandRequest)new OCommandSQL("SELECT from TestInsert where ST_Contains(geometry, " + testGeometry + ") = true")).execute(new Object[0]);
        Assert.assertEquals((long)1L, (long)execute.size());
    }
}

