/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class LuceneTransactionGeoQueryTest {
    private static String PWKT = "POINT(-160.2075374 21.9029803)";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPointTransactionRollBack() {
        ODatabaseDocumentTx db = new ODatabaseDocumentTx("memory:txPoint");
        try {
            db.create();
            OSchema schema = db.getMetadata().getSchema();
            OClass v = schema.getClass("V");
            OClass oClass = schema.createClass("City");
            oClass.setSuperClass(v);
            oClass.createProperty("location", OType.EMBEDDED, schema.getClass("OPoint"));
            oClass.createProperty("name", OType.STRING);
            db.command((OCommandRequest)new OCommandSQL("CREATE INDEX City.location ON City(location) SPATIAL ENGINE LUCENE")).execute(new Object[0]);
            OIndex idx = db.getMetadata().getIndexManager().getIndex("City.location");
            ODocument rome = this.newCity("Rome", 12.5, 41.9);
            ODocument london = this.newCity("London", -0.1275, 51.507222);
            db.begin();
            db.command((OCommandRequest)new OCommandSQL("insert into City set name = 'TestInsert' , location = ST_GeomFromText('" + PWKT + "')")).execute(new Object[0]);
            db.save((ORecord)rome);
            db.save((ORecord)london);
            String query = "select * from City where location && 'LINESTRING(-160.06393432617188 21.996535232496047,-160.1099395751953 21.94304553343818,-160.169677734375 21.89399562866819,-160.21087646484375 21.844928843026818,-160.21018981933594 21.787556698550834)' ";
            List docs = db.query((OQuery)new OSQLSynchQuery(query), new Object[0]);
            Assert.assertEquals((long)1L, (long)docs.size());
            Assert.assertEquals((long)4L, (long)idx.getSize());
            db.rollback();
            query = "select * from City where location && 'LINESTRING(-160.06393432617188 21.996535232496047,-160.1099395751953 21.94304553343818,-160.169677734375 21.89399562866819,-160.21087646484375 21.844928843026818,-160.21018981933594 21.787556698550834)' ";
            docs = db.query((OQuery)new OSQLSynchQuery(query), new Object[0]);
            Assert.assertEquals((long)0L, (long)docs.size());
            Assert.assertEquals((long)1L, (long)idx.getSize());
        }
        finally {
            db.drop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPointTransactionUpdate() {
        ODatabaseDocumentTx db = new ODatabaseDocumentTx("memory:txPoint");
        try {
            db.create();
            OSchema schema = db.getMetadata().getSchema();
            OClass v = schema.getClass("V");
            OClass oClass = schema.createClass("City");
            oClass.setSuperClass(v);
            oClass.createProperty("location", OType.EMBEDDED, schema.getClass("OPoint"));
            oClass.createProperty("name", OType.STRING);
            db.command((OCommandRequest)new OCommandSQL("CREATE INDEX City.location ON City(location) SPATIAL ENGINE LUCENE")).execute(new Object[0]);
            OIndex idx = db.getMetadata().getIndexManager().getIndex("City.location");
            ODocument rome = this.newCity("Rome", 12.5, 41.9);
            db.begin();
            db.save((ORecord)rome);
            db.commit();
            String query = "select * from City where location && 'LINESTRING(-160.06393432617188 21.996535232496047,-160.1099395751953 21.94304553343818,-160.169677734375 21.89399562866819,-160.21087646484375 21.844928843026818,-160.21018981933594 21.787556698550834)' ";
            List docs = db.query((OQuery)new OSQLSynchQuery(query), new Object[0]);
            Assert.assertEquals((long)0L, (long)docs.size());
            Assert.assertEquals((long)2L, (long)idx.getSize());
            db.begin();
            db.command((OCommandRequest)new OCommandSQL("update City set location = ST_GeomFromText('" + PWKT + "')")).execute(new Object[0]);
            query = "select * from City where location && 'LINESTRING(-160.06393432617188 21.996535232496047,-160.1099395751953 21.94304553343818,-160.169677734375 21.89399562866819,-160.21087646484375 21.844928843026818,-160.21018981933594 21.787556698550834)' ";
            docs = db.query((OQuery)new OSQLSynchQuery(query), new Object[0]);
            Assert.assertEquals((long)1L, (long)docs.size());
            Assert.assertEquals((long)2L, (long)idx.getSize());
            db.commit();
            query = "select * from City where location && 'LINESTRING(-160.06393432617188 21.996535232496047,-160.1099395751953 21.94304553343818,-160.169677734375 21.89399562866819,-160.21087646484375 21.844928843026818,-160.21018981933594 21.787556698550834)' ";
            docs = db.query((OQuery)new OSQLSynchQuery(query), new Object[0]);
            Assert.assertEquals((long)1L, (long)docs.size());
            Assert.assertEquals((long)2L, (long)idx.getSize());
        }
        finally {
            db.drop();
        }
    }

    protected ODocument newCity(String name, final Double longitude, final Double latitude) {
        ODocument location = new ODocument("OPoint");
        location.field("coordinates", (Object)new ArrayList<Double>(){
            {
                this.add(longitude);
                this.add(latitude);
            }
        });
        ODocument city = new ODocument("City");
        city.field("name", (Object)name);
        city.field("location", (Object)location);
        return city;
    }
}

