/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.orientechnologies.spatial.BaseSpatialLuceneTest;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LuceneSpatialTxPointTest
extends BaseSpatialLuceneTest {
    @Before
    public void init() {
        OSchema schema = this.db.getMetadata().getSchema();
        OClass v = schema.getClass("V");
        OClass oClass = schema.createClass("City");
        oClass.setSuperClass(v);
        oClass.createProperty("location", OType.EMBEDDED, schema.getClass("OPoint"));
        oClass.createProperty("name", OType.STRING);
        OClass place = schema.createClass("Place");
        place.setSuperClass(v);
        place.createProperty("latitude", OType.DOUBLE);
        place.createProperty("longitude", OType.DOUBLE);
        place.createProperty("name", OType.STRING);
        this.db.command((OCommandRequest)new OCommandSQL("CREATE INDEX City.location ON City(location) SPATIAL ENGINE LUCENE")).execute(new Object[0]);
    }

    protected ODocument newCity(String name, Double longitude, Double latitude) {
        ODocument location = this.newPoint(longitude, latitude);
        ODocument city = new ODocument("City");
        city.field("name", (Object)name);
        city.field("location", (Object)location);
        return city;
    }

    private ODocument newPoint(final Double longitude, final Double latitude) {
        ODocument location = new ODocument("OPoint");
        location.field("coordinates", (Object)new ArrayList<Double>(){
            {
                this.add(longitude);
                this.add(latitude);
            }
        });
        return location;
    }

    @Test
    public void testIndexingTxPoint() {
        ODocument rome = this.newCity("Rome", 12.5, 41.9);
        this.db.begin();
        this.db.save((ORecord)rome);
        String query = "select * from City where  ST_WITHIN(location,{ 'shape' : { 'type' : 'ORectangle' , 'coordinates' : [12.314015,41.8262816,12.6605063,41.963125]} }) = true";
        List docs = this.db.query((OQuery)new OSQLSynchQuery(query), new Object[0]);
        Assert.assertEquals((long)1L, (long)docs.size());
        this.db.rollback();
        query = "select * from City where  ST_WITHIN(location,{ 'shape' : { 'type' : 'ORectangle' , 'coordinates' : [12.314015,41.8262816,12.6605063,41.963125]} }) = true";
        docs = this.db.query((OQuery)new OSQLSynchQuery(query), new Object[0]);
        Assert.assertEquals((long)0L, (long)docs.size());
    }

    @Test
    public void testIndexingUpdateTxPoint() {
        ODocument rome = this.newCity("Rome", -0.1275, 51.507222);
        rome = (ODocument)this.db.save((ORecord)rome);
        this.db.begin();
        rome.field("location", (Object)this.newPoint(12.5, 41.9));
        this.db.save((ORecord)rome);
        this.db.commit();
        String query = "select * from City where  ST_WITHIN(location,{ 'shape' : { 'type' : 'ORectangle' , 'coordinates' : [12.314015,41.8262816,12.6605063,41.963125]} }) = true";
        List docs = this.db.query((OQuery)new OSQLSynchQuery(query), new Object[0]);
        Assert.assertEquals((long)1L, (long)docs.size());
        OIndex index = this.db.getMetadata().getIndexManager().getIndex("City.location");
        Assert.assertEquals((long)2L, (long)index.getSize());
    }

    @Test
    public void testIndexingComplexUpdateTxPoint() {
        ODocument rome = this.newCity("Rome", 12.5, 41.9);
        ODocument london = this.newCity("London", -0.1275, 51.507222);
        rome = (ODocument)this.db.save((ORecord)rome);
        london = (ODocument)this.db.save((ORecord)london);
        this.db.begin();
        rome.field("location", (Object)this.newPoint(12.5, 41.9));
        london.field("location", (Object)this.newPoint(-0.1275, 51.507222));
        london.field("location", (Object)this.newPoint(-0.1275, 51.507222));
        london.field("location", (Object)this.newPoint(12.5, 41.9));
        this.db.save((ORecord)rome);
        this.db.save((ORecord)london);
        this.db.commit();
        OIndex index = this.db.getMetadata().getIndexManager().getIndex("City.location");
        Assert.assertEquals((long)3L, (long)index.getSize());
    }
}

