/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.lucene.test.BaseLuceneTest;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.intent.OIntent;
import com.orientechnologies.orient.core.intent.OIntentMassiveInsert;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Enumeration;
import java.util.List;
import java.util.TimerTask;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class LuceneSpatialQueryTest
extends BaseLuceneTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void init() {
        OSchema schema = this.db.getMetadata().getSchema();
        OClass v = schema.getClass("V");
        OClass oClass = schema.createClass("Place");
        oClass.setSuperClass(v);
        oClass.createProperty("latitude", OType.DOUBLE);
        oClass.createProperty("longitude", OType.DOUBLE);
        oClass.createProperty("name", OType.STRING);
        this.db.command((OCommandRequest)new OCommandSQL("CREATE INDEX Place.l_lon ON Place(latitude,longitude) SPATIAL ENGINE LUCENE")).execute(new Object[0]);
        try {
            ZipFile zipFile = new ZipFile(new File(ClassLoader.getSystemResource("location.csv.zip").getPath()));
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            this.db.declareIntent((OIntent)new OIntentMassiveInsert());
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                Orient.instance().getTimer().schedule(new TimerTask(){

                    @Override
                    public void run() {
                        Runtime runtime = Runtime.getRuntime();
                        StringBuilder sb = new StringBuilder();
                        long maxMemory = runtime.maxMemory();
                        long allocatedMemory = runtime.totalMemory();
                        long freeMemory = runtime.freeMemory();
                        OLogManager.instance().info((Object)this, "Memory Stats: free [%d], allocated [%d], max [%d] total free [%d]", new Object[]{freeMemory / 1024L, allocatedMemory / 1024L, maxMemory / 1024L, (freeMemory + (maxMemory - allocatedMemory)) / 1024L});
                    }
                }, 10000L, 10000L);
                if (entry.getName().equals("location.csv")) {
                    String line;
                    InputStream stream = zipFile.getInputStream(entry);
                    LineNumberReader lnr = new LineNumberReader(new InputStreamReader(stream));
                    int i = 0;
                    while ((line = lnr.readLine()) != null) {
                        String[] nextLine = line.split(",");
                        ODocument doc = new ODocument("Place");
                        doc.field("name", (Object)nextLine[3]);
                        doc.field("country", (Object)nextLine[1]);
                        try {
                            Double lat = (double)((Double)OType.convert((Object)nextLine[5], Double.class));
                            Double lng = (double)((Double)OType.convert((Object)nextLine[6], Double.class));
                            doc.field("latitude", (Object)lat);
                            doc.field("longitude", (Object)lng);
                        }
                        catch (Exception e) {
                            continue;
                        }
                        doc.save();
                        if (i % 100000 == 0) {
                            OLogManager.instance().info((Object)this, "Imported: [%d] records", new Object[]{i});
                            this.db.commit();
                            this.db.begin();
                        }
                        ++i;
                    }
                    lnr.close();
                    stream.close();
                    this.db.commit();
                }
                this.db.declareIntent(null);
            }
        }
        catch (Exception exception) {
        }
    }

    @Test
    @Ignore
    public void testNearQuery() {
        String query = "select *,$distance from Place where [latitude,longitude,$spatial] NEAR [41.893056,12.482778,{\"maxDistance\": 0.5}]";
        List docs = this.db.query((OQuery)new OSQLSynchQuery(query), new Object[0]);
        Assert.assertEquals((long)1L, (long)docs.size());
        Assertions.assertThat((Float)((Float)((ODocument)docs.get(0)).field("$distance"))).isEqualTo((Object)0.2749329729746763);
    }

    @Test
    @Ignore
    public void testWithinQuery() {
        String query = "select * from Place where [latitude,longitude] WITHIN [[51.507222,-0.1275],[55.507222,-0.1275]]";
        List docs = this.db.query((OQuery)new OSQLSynchQuery(query), new Object[0]);
        Assert.assertEquals((long)238L, (long)docs.size());
    }
}

