/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.orientechnologies.spatial.BaseSpatialLuceneTest;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LuceneSpatialPolygonTest
extends BaseSpatialLuceneTest {
    @Before
    public void init() {
        this.db.set(ODatabase.ATTRIBUTES.CUSTOM, (Object)"strictSql=false");
        OSchema schema = this.db.getMetadata().getSchema();
        OClass v = schema.getClass("V");
        OClass oClass = schema.createClass("Place");
        oClass.setSuperClass(v);
        oClass.createProperty("location", OType.EMBEDDED, schema.getClass("OPolygon"));
        oClass.createProperty("name", OType.STRING);
        this.db.command((OCommandRequest)new OCommandSQL("CREATE INDEX Place.location ON Place(location) SPATIAL ENGINE LUCENE")).execute(new Object[0]);
    }

    @Test
    public void testPolygonWithoutIndex() throws IOException {
        this.testIndexingPolygon();
        this.db.command((OCommandRequest)new OCommandSQL("drop index Place.location")).execute(new Object[0]);
        this.queryPolygon();
    }

    protected void queryPolygon() {
        String query = "select * from Place where location && 'POINT(13.383333 52.516667)'";
        List docs = this.db.query((OQuery)new OSQLSynchQuery(query), new Object[0]);
        Assert.assertEquals((long)docs.size(), (long)1L);
        query = "select * from Place where location && 'POINT(12.5 41.9)'";
        docs = this.db.query((OQuery)new OSQLSynchQuery(query), new Object[0]);
        Assert.assertEquals((long)docs.size(), (long)0L);
    }

    @Test
    public void testIndexingPolygon() throws IOException {
        InputStream systemResourceAsStream = ClassLoader.getSystemResourceAsStream("germany.json");
        ODocument doc = new ODocument().fromJSON(systemResourceAsStream);
        Map geometry = (Map)doc.field("geometry");
        String type = (String)geometry.get("type");
        ODocument location = new ODocument("O" + type);
        location.field("coordinates", geometry.get("coordinates"));
        ODocument germany = new ODocument("Place");
        germany.field("name", (Object)"Germany");
        germany.field("location", (Object)location);
        this.db.save((ORecord)germany);
        OIndex index = this.db.getMetadata().getIndexManager().getIndex("Place.location");
        Assert.assertEquals((long)2L, (long)index.getSize());
        this.queryPolygon();
    }
}

