/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.orientechnologies.spatial.BaseSpatialLuceneTest;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LuceneSpatialPointTest
extends BaseSpatialLuceneTest {
    private static String PWKT = "POINT(-160.2075374 21.9029803)";

    @Before
    public void init() {
        OSchema schema = this.db.getMetadata().getSchema();
        OClass v = schema.getClass("V");
        OClass oClass = schema.createClass("City");
        oClass.setSuperClass(v);
        oClass.createProperty("location", OType.EMBEDDED, schema.getClass("OPoint"));
        oClass.createProperty("name", OType.STRING);
        OClass place = schema.createClass("Place");
        place.setSuperClass(v);
        place.createProperty("latitude", OType.DOUBLE);
        place.createProperty("longitude", OType.DOUBLE);
        place.createProperty("name", OType.STRING);
        this.db.command((OCommandRequest)new OCommandSQL("CREATE INDEX City.location ON City(location) SPATIAL ENGINE LUCENE")).execute(new Object[0]);
        this.db.command((OCommandRequest)new OCommandSQL("CREATE INDEX Place.l_lon ON Place(latitude,longitude) SPATIAL ENGINE LUCENE")).execute(new Object[0]);
        ODocument rome = this.newCity("Rome", 12.5, 41.9);
        ODocument london = this.newCity("London", -0.1275, 51.507222);
        ODocument rome1 = new ODocument("Place");
        rome1.field("name", (Object)"Rome");
        rome1.field("latitude", (Object)41.9);
        rome1.field("longitude", (Object)12.5);
        this.db.save((ORecord)rome1);
        this.db.save((ORecord)rome);
        this.db.save((ORecord)london);
        this.db.command((OCommandRequest)new OCommandSQL("insert into City set name = 'TestInsert' , location = ST_GeomFromText('" + PWKT + "')")).execute(new Object[0]);
    }

    @Test
    public void testPointWithoutIndex() {
        this.db.command((OCommandRequest)new OCommandSQL("Drop INDEX City.location")).execute(new Object[0]);
        this.queryPoint();
    }

    @Test
    public void testIndexingPoint() {
        this.queryPoint();
    }

    protected void queryPoint() {
        String query = "select * from City where  ST_WITHIN(location,{ 'shape' : { 'type' : 'ORectangle' , 'coordinates' : [12.314015,41.8262816,12.6605063,41.963125]} }) = true";
        List docs = this.db.query((OQuery)new OSQLSynchQuery(query), new Object[0]);
        Assert.assertEquals((long)1L, (long)docs.size());
        query = "select * from City where  ST_WITHIN(location,'POLYGON ((12.314015 41.8262816, 12.314015 41.963125, 12.6605063 41.963125, 12.6605063 41.8262816, 12.314015 41.8262816))') = true";
        docs = this.db.query((OQuery)new OSQLSynchQuery(query), new Object[0]);
        Assert.assertEquals((long)1L, (long)docs.size());
        query = "select * from City where  ST_WITHIN(location,ST_GeomFromText('POLYGON ((12.314015 41.8262816, 12.314015 41.963125, 12.6605063 41.963125, 12.6605063 41.8262816, 12.314015 41.8262816))')) = true";
        docs = this.db.query((OQuery)new OSQLSynchQuery(query), new Object[0]);
        Assert.assertEquals((long)1L, (long)docs.size());
        query = "select * from City where location && 'LINESTRING(-160.06393432617188 21.996535232496047,-160.1099395751953 21.94304553343818,-160.169677734375 21.89399562866819,-160.21087646484375 21.844928843026818,-160.21018981933594 21.787556698550834)' ";
        docs = this.db.query((OQuery)new OSQLSynchQuery(query), new Object[0]);
        Assert.assertEquals((long)1L, (long)docs.size());
    }

    @Test
    public void testOldNearQuery() {
        this.queryOldNear();
    }

    protected void queryOldNear() {
        String query = "select *,$distance from Place where [latitude,longitude,$spatial] NEAR [41.893056,12.482778,{\"maxDistance\": 2}]";
        List docs = this.db.query((OQuery)new OSQLSynchQuery(query), new Object[0]);
        Assert.assertEquals((long)1L, (long)docs.size());
        Assertions.assertThat((Double)((Double)((ODocument)docs.get(0)).field("$distance"))).isEqualTo(1.6229442709302933);
    }

    @Test
    public void testOldNearQueryWithoutIndex() {
        this.db.command((OCommandRequest)new OCommandSQL("Drop INDEX Place.l_lon")).execute(new Object[0]);
        this.queryOldNear();
    }

    protected ODocument newCity(String name, final Double longitude, final Double latitude) {
        ODocument location = new ODocument("OPoint");
        location.field("coordinates", (Object)new ArrayList<Double>(){
            {
                this.add(longitude);
                this.add(latitude);
            }
        });
        ODocument city = new ODocument("City");
        city.field("name", (Object)name);
        city.field("location", (Object)location);
        return city;
    }
}

