/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.orientechnologies.spatial.collections.OSpatialCompositeKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.junit.Assert;
import org.junit.Test;

public class LuceneSpatialMemoryTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void boundingBoxTest() {
        ODatabaseDocumentTx db = new ODatabaseDocumentTx("memory:test");
        db.create();
        try {
            OClass point = db.getMetadata().getSchema().createClass("Point");
            point.createProperty("latitude", OType.DOUBLE);
            point.createProperty("longitude", OType.DOUBLE);
            db.command((OCommandRequest)new OCommandSQL("CREATE INDEX Point.ll ON Point(latitude,longitude) SPATIAL ENGINE LUCENE")).execute(new Object[0]);
            ODocument document = new ODocument("Point");
            document.field("latitude", (Object)42.2814837);
            document.field("longitude", (Object)-83.7605452);
            db.save((ORecord)document);
            List query = db.query((OQuery)new OSQLSynchQuery("SELECT FROM Point WHERE [latitude, longitude] WITHIN [[42.26531323615103,-83.71986351411135],[42.29239784478525,-83.7662120858887]]"), new Object[0]);
            Assert.assertEquals((long)query.size(), (long)1L);
        }
        finally {
            db.drop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void boundingBoxTestTxRollBack() {
        ODatabaseDocumentTx db = new ODatabaseDocumentTx("memory:test");
        db.create();
        try {
            OClass point = db.getMetadata().getSchema().createClass("Point");
            point.createProperty("latitude", OType.DOUBLE);
            point.createProperty("longitude", OType.DOUBLE);
            db.command((OCommandRequest)new OCommandSQL("CREATE INDEX Point.ll ON Point(latitude,longitude) SPATIAL ENGINE LUCENE")).execute(new Object[0]);
            db.begin();
            ODocument document = new ODocument("Point");
            document.field("latitude", (Object)42.2814837);
            document.field("longitude", (Object)-83.7605452);
            db.save((ORecord)document);
            List query = db.query((OQuery)new OSQLSynchQuery("SELECT FROM Point WHERE [latitude, longitude] WITHIN [[42.26531323615103,-83.71986351411135],[42.29239784478525,-83.7662120858887]]"), new Object[0]);
            Assert.assertEquals((long)1L, (long)query.size());
            OSpatialCompositeKey oSpatialCompositeKey = new OSpatialCompositeKey((List)new ArrayList<List<Number>>(){
                {
                    this.add(new ArrayList<Number>(){
                        {
                            this.add(42.26531323615103);
                            this.add(-83.71986351411135);
                        }
                    });
                    this.add(new ArrayList<Number>(){
                        {
                            this.add(42.29239784478525);
                            this.add(-83.7662120858887);
                        }
                    });
                }
            }).setOperation(SpatialOperation.IsWithin);
            OIndex index = db.getMetadata().getIndexManager().getIndex("Point.ll");
            Collection coll = (Collection)index.get((Object)oSpatialCompositeKey);
            Assert.assertEquals((long)1L, (long)coll.size());
            db.rollback();
            query = db.query((OQuery)new OSQLSynchQuery("SELECT FROM Point WHERE [latitude, longitude] WITHIN [[42.26531323615103,-83.71986351411135],[42.29239784478525,-83.7662120858887]]"), new Object[0]);
            Assert.assertEquals((long)0L, (long)query.size());
        }
        finally {
            db.drop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void boundingBoxTestTxCommit() {
        ODatabaseDocumentTx db = new ODatabaseDocumentTx("memory:test");
        db.create();
        try {
            OClass point = db.getMetadata().getSchema().createClass("Point");
            point.createProperty("latitude", OType.DOUBLE);
            point.createProperty("longitude", OType.DOUBLE);
            db.command((OCommandRequest)new OCommandSQL("CREATE INDEX Point.ll ON Point(latitude,longitude) SPATIAL ENGINE LUCENE")).execute(new Object[0]);
            db.begin();
            ODocument document = new ODocument("Point");
            document.field("latitude", (Object)42.2814837);
            document.field("longitude", (Object)-83.7605452);
            db.save((ORecord)document);
            db.commit();
            List query = db.query((OQuery)new OSQLSynchQuery("SELECT FROM Point WHERE [latitude, longitude] WITHIN [[42.26531323615103,-83.71986351411135],[42.29239784478525,-83.7662120858887]]"), new Object[0]);
            Assert.assertEquals((long)1L, (long)query.size());
            OSpatialCompositeKey oSpatialCompositeKey = new OSpatialCompositeKey((List)new ArrayList<List<Number>>(){
                {
                    this.add(new ArrayList<Number>(){
                        {
                            this.add(42.26531323615103);
                            this.add(-83.71986351411135);
                        }
                    });
                    this.add(new ArrayList<Number>(){
                        {
                            this.add(42.29239784478525);
                            this.add(-83.7662120858887);
                        }
                    });
                }
            }).setOperation(SpatialOperation.IsWithin);
            OIndex index = db.getMetadata().getIndexManager().getIndex("Point.ll");
            Collection coll = (Collection)index.get((Object)oSpatialCompositeKey);
            Assert.assertEquals((long)1L, (long)coll.size());
            db.begin();
            db.delete((ORecord)document);
            query = db.query((OQuery)new OSQLSynchQuery("SELECT FROM Point WHERE [latitude, longitude] WITHIN [[42.26531323615103,-83.71986351411135],[42.29239784478525,-83.7662120858887]]"), new Object[0]);
            Assert.assertEquals((long)0L, (long)query.size());
            coll = (Collection)index.get((Object)oSpatialCompositeKey);
            Assert.assertEquals((long)0L, (long)coll.size());
            db.rollback();
            query = db.query((OQuery)new OSQLSynchQuery("SELECT FROM Point WHERE [latitude, longitude] WITHIN [[42.26531323615103,-83.71986351411135],[42.29239784478525,-83.7662120858887]]"), new Object[0]);
            Assert.assertEquals((long)1L, (long)query.size());
        }
        finally {
            db.drop();
        }
    }
}

